/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.command.MatchDoWork;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;

public class MatchChPrio
extends MatchDoWork {
    protected MatchChPrio(String host, int cmdType, String cmdName, int ubtNr, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        super(host, cmdType, cmdName, ubtNr, initiator, user, args, dispatcher);
    }

    @Override
    protected int doFIngWork() {
        Long[] jobIds = (Long[])cmdIDTable.get(this.cmdNo);
        int i = -1;
        int cnt = 0;
        int prio = 0;
        CtrlDispAppl.PrioChType chType = CtrlDispAppl.PrioChType.SET;
        if (log.isDebugEnabled()) {
            log.debug((Object)"MatchChPrio: start");
        }
        try {
            if (this.args != null) {
                for (int x = 0; x < this.args.length; ++x) {
                    if (!this.args[x].toUpperCase().startsWith("PRIORITY=")) continue;
                    int idx = this.args[x].indexOf(61);
                    String prioSpec = this.args[x].substring(idx + 1);
                    if (prioSpec.length() > 0) {
                        int offs;
                        switch (prioSpec.charAt(0)) {
                            case '+': {
                                chType = CtrlDispAppl.PrioChType.INCREASE;
                                offs = 1;
                                break;
                            }
                            case '-': {
                                chType = CtrlDispAppl.PrioChType.DECREASE;
                                offs = 1;
                                break;
                            }
                            default: {
                                chType = CtrlDispAppl.PrioChType.SET;
                                offs = 0;
                            }
                        }
                        try {
                            prio = Integer.parseInt(prioSpec.substring(offs));
                            break;
                        }
                        catch (Exception e) {
                            String msg = "Cannot parse job priority specfication: '" + prioSpec + "'";
                            log.error((Object)msg);
                            throw new IllegalArgumentException(msg);
                        }
                    }
                    throw new IllegalArgumentException("Empty priority specification found: '" + this.args[x]);
                }
            }
            for (i = 0; i < jobIds.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MatchChPrio: change prio of job: " + jobIds[i] + ", prio: " + prio + ", type: " + (Object)((Object)chType)));
                }
                if (!this.dispatcher.jobChangePrio(jobIds[i], prio, -1L, chType)) continue;
                ++cnt;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("MatchChPrio: prio of job " + jobIds[i] + " changed."));
            }
        }
        catch (Exception e) {
            if (i != -1 && jobIds != null && jobIds.length > i) {
                log.error((Object)("Cannot change prio of job " + jobIds[i]), (Throwable)e);
            }
            log.error((Object)"Cannot change prio of jobs.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MatchChPrio: " + cnt + " job's prio changed."));
        }
        return cnt;
    }

    @Override
    protected String getAnswMsgHead() {
        return "Jobs or Edi-Objects matched/priority changed: ";
    }
}

