/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.command.Cmd;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.command.StormWallRule;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SetEvtStormWall
extends Cmd {
    public static final int DEFAULT_TIME_UNTIL = 864000;
    public static List<StormWallRule> STORM_WALL_RULES = new ArrayList<StormWallRule>();
    private static CtrlDispAppl dispatcher;
    private static Connection connection;
    private static String[] copyArgs;

    public SetEvtStormWall(String host, int cmdType, String cmdName, int ubtNr, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        super(host, cmdType, cmdName, ubtNr, initiator, user, args, dispatcher);
        copyArgs = this.args;
        connection = dispatcher.getConnection();
    }

    @Override
    public CmdAnswer execute() {
        new Thread(){

            @Override
            public void run() {
                SetEvtStormWall.addRule(copyArgs);
                SetEvtStormWall.this.doSuspStopActiveJobs();
            }
        }.start();
        CmdAnswer answer = new CmdAnswer(0, this.cmdNo, 1, 62, null, null);
        return answer;
    }

    private static void addRule(String[] args) {
        StormWallRule rule = new StormWallRule();
        ArrayList<String> evtAttr = new ArrayList<String>();
        for (String arg : args) {
            if ("STOP_JOB".equals(arg.toUpperCase()) || "SUSPEND_JOB".equals(arg.toUpperCase())) {
                rule.setAction(arg.toUpperCase());
                continue;
            }
            if (arg.toUpperCase().contains("JOBNAME")) {
                rule.setJobName(arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.toUpperCase().contains("TIME_UNTIL")) {
                rule.setTimeUntil(arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.toUpperCase().contains("ACTIVATE_ATTR")) {
                rule.setActivateAttr(arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            evtAttr.add(arg);
        }
        if (evtAttr.isEmpty()) {
            log.warn((Object)"Storm wall rule is missing EVT_ATTRI! Rule not added.");
            return;
        }
        rule.setEvtAttr(evtAttr);
        if (STORM_WALL_RULES.contains(rule)) {
            log.info((Object)("Storm wall rule already added: " + rule.toString()));
        } else {
            STORM_WALL_RULES.add(rule);
            log.info((Object)("Added storm wall rule: " + rule.toString()));
        }
    }

    public static void doSuspStopJob(CtrlJob job, boolean doUnlock) {
        try {
            if (!STORM_WALL_RULES.isEmpty() && "USR".equals(job.getEvt().getInitiator())) {
                for (StormWallRule rule : STORM_WALL_RULES) {
                    if ("SUSPEND_JOB".equals(rule.getAction())) {
                        SetEvtStormWall.suspendJobStormWall(job, rule, doUnlock);
                        continue;
                    }
                    if (!"STOP_JOB".equals(rule.getAction())) continue;
                    SetEvtStormWall.stopJobStormWall(job, rule, doUnlock);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Fail to execute storm wall rule on job " + job.getId()), (Throwable)e);
        }
    }

    private static void stopJobStormWall(CtrlJob job, StormWallRule rule, boolean doUnlock) {
        if (!SetEvtStormWall.isJobNameMaching(job, rule) || !SetEvtStormWall.isEvtAttrMaching(job, rule)) {
            return;
        }
        try {
            SetEvtStormWall.callDispStopJob(job, rule, connection, doUnlock);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                log.warn((Object)("StormWall: error at stop job: " + job.getId() + ". Will retry."), (Throwable)e);
                connection = SetEvtStormWall.getConnection();
                SetEvtStormWall.callDispStopJob(job, rule, connection, doUnlock);
            }
            throw e;
        }
    }

    private static void suspendJobStormWall(CtrlJob job, StormWallRule rule, boolean doUnlock) {
        if (!SetEvtStormWall.isJobNameMaching(job, rule) || !SetEvtStormWall.isEvtAttrMaching(job, rule)) {
            return;
        }
        try {
            SetEvtStormWall.callDispSuspendJob(job, rule, connection, doUnlock);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                log.warn((Object)("StormWall: error at susp job:" + job.getId() + ". Will retry."), (Throwable)e);
                connection = SetEvtStormWall.getConnection();
                SetEvtStormWall.callDispSuspendJob(job, rule, connection, doUnlock);
            }
            throw e;
        }
    }

    private static void callDispStopJob(CtrlJob job, StormWallRule rule, Connection connection, boolean doUnlock) {
        boolean isJobUnlocked = false;
        LockJob lj = new LockJob(job.getId());
        try {
            if (doUnlock) {
                try {
                    dispatcher.getLockDaemon().globalUnLock((SyncObject)lj);
                    isJobUnlocked = true;
                }
                catch (LockException e) {
                    log.warn((Object)"Fail to unlock job", (Throwable)e);
                }
            }
            dispatcher.stopJob(job.getId(), -1L, connection);
            log.info((Object)("Storm wall : job " + job.getId() + " stopped because a maching storm wall rule was found. Rule: " + rule.toString()));
        }
        catch (InterruptedException e) {
            log.error((Object)("StormWall: error at stop job: " + job.getId()), (Throwable)e);
        }
        catch (LockException e) {
            log.error((Object)("StormWall: error at stop job: " + job.getId()), (Throwable)e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (doUnlock && isJobUnlocked) {
                    dispatcher.getLockDaemon().globalLock((SyncObject)lj);
                }
            }
            catch (LockException e) {
                log.warn((Object)"Fail to lock job", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callDispSuspendJob(CtrlJob job, StormWallRule rule, Connection connection, boolean doUnlock) {
        boolean isJobUnlocked = false;
        LockJob lj = new LockJob(job.getId());
        try {
            if (doUnlock) {
                try {
                    dispatcher.getLockDaemon().globalUnLock((SyncObject)lj);
                    isJobUnlocked = true;
                }
                catch (LockException e) {
                    log.warn((Object)"Fail to unlock job", (Throwable)e);
                }
            }
            dispatcher.suspendJob(job.getId(), SetEvtStormWall.getActivateAttrMaching(rule), SetEvtStormWall.getTimeUntil(rule.getTimeUntil()), -1L, connection);
            log.info((Object)("Storm wall : job " + job.getId() + " suspended because a maching storm wall rule was found. Rule: " + rule.toString()));
        }
        catch (InterruptedException e) {
            log.error((Object)("StormWall: error at susp job: " + job.getId()), (Throwable)e);
        }
        finally {
            try {
                if (doUnlock && isJobUnlocked) {
                    dispatcher.getLockDaemon().globalLock((SyncObject)lj);
                }
            }
            catch (LockException e) {
                log.warn((Object)"Fail to lock job", (Throwable)e);
            }
        }
    }

    private static boolean isJobNameMaching(CtrlJob job, StormWallRule rule) {
        if (rule.getJobName() == null || rule.getJobName().isEmpty()) {
            return true;
        }
        return rule.getJobName().equals(job.getEvt().getJob().getName());
    }

    private static boolean isEvtAttrMaching(CtrlJob job, StormWallRule rule) {
        ArrayList<String> jobEvtAttrToCompare = new ArrayList<String>();
        if (job.getEvt().getAttr() == null) {
            return false;
        }
        List attrList = job.getEvt().getAttrList();
        for (Attribute obj : attrList) {
            jobEvtAttrToCompare.add(obj.getName() + "=" + (String)obj.get());
        }
        return rule.getEvtAttr().size() == jobEvtAttrToCompare.size() && rule.getEvtAttr().containsAll(jobEvtAttrToCompare);
    }

    private static int getTimeUntil(String ruleTimeUntil) {
        int timeUntil;
        try {
            timeUntil = ruleTimeUntil != null ? TextCfg.getTime(ruleTimeUntil) : 864000;
        }
        catch (CfgException e1) {
            log.warn((Object)"SUSPEND_JOB. Wrong format time_until. Will set default time 10 days.");
            timeUntil = 864000;
        }
        return timeUntil;
    }

    private static Attributes<String> getActivateAttrMaching(StormWallRule rule) {
        Attributes activateAttr = null;
        if (rule.getActivateAttr() != null && !rule.getActivateAttr().isEmpty()) {
            activateAttr = new Attributes();
            String tmpAttr = rule.getActivateAttr();
            activateAttr = new Attributes(tmpAttr);
        }
        return activateAttr;
    }

    private void doSuspStopActiveJobs() {
        Map<Long, IJob> jobs = dispatcher.getJobs();
        for (Map.Entry<Long, IJob> entry : jobs.entrySet()) {
            CtrlJob job = (CtrlJob)entry.getValue();
            SetEvtStormWall.doSuspStopJob(job, false);
        }
    }

    public static void setDispatcher(CtrlDispAppl dispatcher) {
        SetEvtStormWall.dispatcher = dispatcher;
    }

    public static Connection getConnection() {
        try {
            connection = dispatcher.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)("Can't get sql connection: " + e.getMessage() + " "), (Throwable)e);
            throw new RuntimeException(e);
        }
        return connection;
    }
}

