/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.BaseAsciiWriter;
import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.ISchemahandler;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AttrStringsAsciiSchemaRowWriteHandler
extends BaseAsciiWriter
implements ISchemahandler {
    private Object currentStringId = null;
    private ArrayList<Object[]> rowDataHashList = null;
    private int stringIdIndex = -1;
    private int parentIdIndex = -1;
    private int typIndex = -1;
    private int attrIndex = -1;
    private int anykeyIndex = -1;
    private int anyvalueIndex = -1;
    private int vstringIndex = -1;
    private TableDescription fieldTableDescription;

    @Override
    public void close() {
    }

    @Override
    public void handleTableStart(IRowset rowSet) throws ConvertException {
        if (!rowSet.equals(this.rowSet) && rowSet.getTableDescription().getName().equals("attrstrings.new")) {
            this.rowSet = rowSet;
            this.fieldTableDescription = this.rowSet.getTableDescription();
            List<IColumnDescription> columnDescriptions = this.fieldTableDescription.getColumnDescriptions();
            for (int i = 0; i < columnDescriptions.size(); ++i) {
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("string_id")) {
                    this.stringIdIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("parent_id")) {
                    this.parentIdIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("typ")) {
                    this.typIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("attr")) {
                    this.attrIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("anykey")) {
                    this.anykeyIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("anyvalue")) {
                    this.anyvalueIndex = i;
                    continue;
                }
                if (!columnDescriptions.get(i).getName().equalsIgnoreCase("vstring")) continue;
                this.vstringIndex = i;
            }
            this.rowIndex = 0;
            String actisedi = System.getProperty("ACTISEDI");
            String name = rowSet.getTableDescription().getName();
            this.file = new File(actisedi + "/spool/asciidata/" + name);
            this.fileTmp = new File(actisedi + "/spool/asciidata/" + name + ".tmp");
            try {
                this.pw = new PrintWriter(new FileWriter(this.fileTmp));
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            String version = rowSet.getVersion();
            this.pw.println();
            this.pw.println("# ***** Creation date: " + rowSet.getCreationDate() + " *****");
            this.pw.println("# ***** Source: " + rowSet.getSource());
            this.pw.println("#");
            this.pw.println("#  1. ID=String_ID           (DB-Key)");
            this.pw.println("#  2. \tParent_ID            (DB-Ref)");
            this.pw.println("#  3. \tString_Typ");
            this.pw.println("#  4. \tNoS3                 (Number of Stringtriple)");
            this.pw.println("#  5. \tAttr1 Attr2 Attr3");
            this.pw.println("#  6. \tL<LeftString_1>      OR  l for Nil-LeftString");
            this.pw.println("#  7. \tR<RightString_1>     OR  r for Nil-RightString");
            this.pw.println("#  8. \tAttr1 Attr2 Attr3");
            this.pw.println("#  9. \tL    ...             OR  l     ...");
            this.pw.println("# 10. \tR    ...             OR  r     ...");
            this.pw.println("# 11. \tAttr1 Attr2 Attr3");
            this.pw.println("# 12. \tL<LeftString_NoS3>   OR  l for Nil-LeftString");
            this.pw.println("# 13. \tR<RightString_NoS3>  OR  r for Nil-RightString");
            this.pw.println("#");
            this.pw.println("# Expected Entries=");
            this.pw.println("                                                       ");
            this.pw.println("VERSION=" + version);
            this.pw.println();
            this.pw.println();
        }
    }

    @Override
    public void handleTableRow(Object[] rowDataArray) {
        if (this.rowSet != null) {
            Object stringId = rowDataArray[this.stringIdIndex];
            if (!stringId.equals(this.currentStringId)) {
                ++this.rowIndex;
                this.writeEntry();
                this.currentStringId = stringId;
                this.rowDataHashList = new ArrayList();
            }
            this.rowDataHashList.add(rowDataArray);
        }
    }

    @Override
    protected void writeEntry() {
        if (this.rowDataHashList != null) {
            Iterator<Object[]> rowDataHashIterator = this.rowDataHashList.iterator();
            Object[] rowDataArray = rowDataHashIterator.next();
            Object value = rowDataArray[this.stringIdIndex];
            this.pw.println("ID=" + value);
            value = rowDataArray[this.parentIdIndex];
            this.pw.println("\t" + value);
            value = rowDataArray[this.typIndex];
            this.pw.println("\t" + value);
            int noS3 = this.rowDataHashList.size();
            this.pw.println("\t" + noS3);
            while (true) {
                Object attr = rowDataArray[this.attrIndex];
                Object anykey = rowDataArray[this.anykeyIndex];
                Object anyvalue = rowDataArray[this.anyvalueIndex];
                this.pw.println("\t" + attr);
                value = rowDataArray[this.vstringIndex];
                if (anykey.equals("")) {
                    this.pw.println("\tl");
                } else {
                    this.pw.println("\tL" + anykey);
                }
                this.pw.println("\tR" + anyvalue);
                if (!rowDataHashIterator.hasNext()) break;
                rowDataArray = rowDataHashIterator.next();
            }
            this.pw.println();
            this.rowDataHashList = null;
        }
    }
}

