/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.ISchemahandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public abstract class BaseAsciiWriter
implements ISchemahandler {
    protected PrintWriter pw;
    protected File file;
    protected File fileTmp;
    protected IRowset rowSet = null;
    protected int rowIndex;

    protected abstract void writeEntry();

    @Override
    public void handleTableEnd(IRowset rowSet) throws ConvertException {
        if (this.rowSet != null) {
            this.writeEntry();
            this.rowSet = null;
            this.pw.println("# Entries: wrote/expected=" + this.rowIndex + "/" + this.rowIndex);
            this.pw.close();
            try {
                RandomAccessFile raf = new RandomAccessFile(this.fileTmp, "rw");
                long filePointer = raf.getFilePointer();
                String line = raf.readLine();
                while (line != null) {
                    if (line.startsWith("# Expected Entries=")) {
                        line = "# Expected Entries=" + this.rowIndex + "\n";
                        raf.seek(filePointer);
                        raf.writeBytes(line);
                        break;
                    }
                    filePointer = raf.getFilePointer();
                    line = raf.readLine();
                }
                raf.close();
            }
            catch (FileNotFoundException e) {
                throw new ConvertException(e);
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            this.file.delete();
            boolean isRcOk = this.fileTmp.renameTo(this.file);
            if (!isRcOk) {
                throw new ConvertException("can not rename '" + this.fileTmp.getAbsolutePath() + "' to '" + this.file.getAbsolutePath() + "'");
            }
        }
    }
}

