/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgFctnSequence;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgJobStep;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.cfg.TextCfgFctn;
import de.axway.aim.controller.master.cfg.TextCfgJob;
import de.axway.aim.controller.master.cfg.TextCfgRc;
import de.axway.aim.controller.master.cfg.TextCfgSlave;
import de.axway.aim.controller.master.cfg.TextCfgTimeWindow;
import de.axway.aim.controller.master.cfg.TextEdiboss;
import de.axway.aim.controller.master.convert.AllKeysAsciiSchemaRowWriteHandler;
import de.axway.aim.controller.master.convert.AsciiFileSchemaDataReader;
import de.axway.aim.controller.master.convert.AsciiToJdbcHandler;
import de.axway.aim.controller.master.convert.AttrStringsAsciiSchemaRowWriteHandler;
import de.axway.aim.controller.master.convert.BuiltInValue;
import de.axway.aim.controller.master.convert.CharColumnDescription;
import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.HexColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IntegerColumnDescription;
import de.axway.aim.controller.master.convert.JdbcSchemaDataReader;
import de.axway.aim.controller.master.convert.Main;
import de.axway.aim.controller.master.convert.MultiSchemaRowHandler;
import de.axway.aim.controller.master.convert.PreparedStatementFactory;
import de.axway.aim.controller.master.convert.SchemaDescription;
import de.axway.aim.controller.master.convert.StandardAsciiSchemaRowWriteHandler;
import de.axway.aim.controller.master.convert.StringColumnDescription;
import de.axway.aim.controller.master.convert.StringsAsciiSchemaRowWriteHandler;
import de.axway.aim.controller.master.convert.TableDescription;
import de.axway.aim.controller.master.convert.WrongVersionException;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.release.db.SqlExec;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Converter {
    private static final String[] C_ASCII_SCHEMA_XML = new String[]{"c_ascii_schema.xml", "c_ascii_schema.3401.xml"};
    private static final String[] J_JDBC_SCHEMA_XML = new String[]{"j_jdbc_schema.3901.xml", "j_jdbc_schema.xml", "j_jdbc_schema.3401.xml"};
    private static final SqlExec.IProtocolHandler PROTOCOL_HANDLER_DEFAULT;
    private final JAXBContext schemaContext;
    private static final int UBTNR_MASTER_NO_ATTR = 0;
    private static final int UBTNR_MASTER_FH_PERMANENT = 1;
    private static final int UBTNR_MASTER_SLAVE4BIG = 8;
    private static final int UBTNR_MASTER_DECL_LOCALHOST = 32;
    private static final int UBTNR_MASTER_DECL_LOOPBACK = 64;
    private static final int UBTNR_MASTER_NORMAL_SLAVE = 256;
    private static final int UBTNR_MASTER_BOM_SLAVE = 512;
    private static final SqlExec.IProtocolHandler SQL_PROTOCOL_HANDLER;
    private final int fMaxFetchSize;
    private final int fMaxBatchCount;
    private File actisediDir;
    private TextEdiboss parEdiboss;
    private TextCfgJob cfgJob;
    private TextCfgFctn cfgFctn;
    private TextCfgSlave cfgSlave;
    private TextCfgRc cfgRc;
    private File sqlDir;
    protected static final Log LOG;
    private PrintStream userOutput = System.out;
    private Connection connection;
    private PreparedStatementFactory preparedStatementFactory;

    public Connection getConnection() {
        return this.connection;
    }

    public TextCfgFctn getCfgFctn() {
        return this.cfgFctn;
    }

    public Converter(int maxBatchCount, int maxFetchSize) throws ConvertException {
        try {
            this.schemaContext = JAXBContext.newInstance((Class[])new Class[]{SchemaDescription.class});
            this.fMaxBatchCount = maxBatchCount;
            this.fMaxFetchSize = maxFetchSize;
            ConvertInvocationHandler handler = new ConvertInvocationHandler();
            ILogbook logbook = (ILogbook)Proxy.newProxyInstance(ILogbook.class.getClassLoader(), new Class[]{ILogbook.class}, (InvocationHandler)handler);
            Logbook.setLogbook(logbook);
            this.actisediDir = new File(System.getProperty("ACTISEDI"));
            this.parEdiboss = new TextEdiboss();
            Driver driver = (Driver)Class.forName(this.parEdiboss.getDbDriver()).newInstance();
            Properties info = new Properties();
            info.put("user", this.parEdiboss.getDbUser());
            info.put("password", this.parEdiboss.getDbPass());
            this.connection = driver.connect(this.parEdiboss.getDbUrl(), info);
            this.connection.setAutoCommit(false);
            String url = this.connection.getMetaData().getURL();
            String sqlDialect = url.replaceFirst("jdbc:([^:]*):.*", "$1");
            this.sqlDir = new File(this.actisediDir, "install/sql/" + sqlDialect);
            this.preparedStatementFactory = new PreparedStatementFactory(this.connection, this.fMaxBatchCount, maxFetchSize);
            this.cfgSlave = new TextCfgSlave(this.parEdiboss.getSlaveFile());
            this.cfgRc = new TextCfgRc(this.parEdiboss.getRccFile());
            ArrayList<CfgSlaveEntry> slaveList = new ArrayList<CfgSlaveEntry>(this.cfgSlave.getSlaves());
            this.cfgFctn = new TextCfgFctn(slaveList, (CfgRc)this.cfgRc, this.parEdiboss.getFctnFile());
            int globalRemoveDelay = 0;
            TextCfgTimeWindow cfgTimeWindow = new TextCfgTimeWindow(this.parEdiboss.getTimeWindowFile());
            this.cfgJob = new TextCfgJob(this.parEdiboss.getJobFile(), cfgTimeWindow, this.cfgRc, globalRemoveDelay, null, null);
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    protected void sqlExec(String fileName, boolean isFailOnErrorEnabled, boolean isAutocommitEnabled) throws ConvertException {
        try {
            this.connection.setAutoCommit(isAutocommitEnabled);
            SqlExec.sqlExec((SqlExec.IProtocolHandler)SQL_PROTOCOL_HANDLER, (Connection)this.connection, (Reader)new FileReader(new File(this.sqlDir, fileName)), (boolean)isFailOnErrorEnabled);
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    protected BigDecimal parseBuiltinCmd(String functionCall) {
        BigDecimal builtInCmd;
        if (functionCall == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"function not yet implemented");
            }
            builtInCmd = BigDecimal.valueOf(0L);
        } else {
            Pattern builtInPattern = Pattern.compile("^(?i)\\s*BUILT_IN\\s*=\\s*(\\S+).*");
            Matcher buildInMatcher = builtInPattern.matcher(functionCall);
            if (buildInMatcher.matches()) {
                String buildInString = buildInMatcher.group(1);
                BuiltInValue builtInValue = BuiltInValue.valueOf(buildInString);
                builtInCmd = BigDecimal.valueOf(builtInValue.getValue());
            } else {
                builtInCmd = BigDecimal.valueOf(0L);
            }
        }
        return builtInCmd;
    }

    protected void cfgFctnToDb() throws ConvertException {
        Date start = new Date();
        Map<String, CfgFctnEntry> entries = this.cfgFctn.getEntries();
        String insertStatementString = "insert into tmp_fctn (fcname, seq, rcname, actionName, fcslave, seqCount, maxCalls, maxRetry, currCalls, builtInCmd, fcGroupName) values (?,?,?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement insertStatement = this.preparedStatementFactory.prepareStatement(insertStatementString);
            for (Map.Entry<String, CfgFctnEntry> it : entries.entrySet()) {
                String fcname = it.getKey();
                CfgFctnEntry entry = it.getValue();
                int seqCount = entry.getSeqCount();
                List<CfgFctnSequence> seqList = entry.getSeq();
                Integer currCalls = seqList.size();
                Iterator<CfgFctnSequence> seqIterator = seqList.iterator();
                int seqIndex = 0;
                while (seqIterator.hasNext()) {
                    String fcslave;
                    CfgFctnSequence seq = seqIterator.next();
                    String fctncall = seq.getCmdLine();
                    BigDecimal builtInCmd = this.parseBuiltinCmd(fctncall);
                    if (seq.isBomSlave()) {
                        fcslave = "$(BOMSLAVE)";
                    } else {
                        List<CfgSlaveEntry> slaveEntryList = seq.getSlaveEntryList();
                        if (slaveEntryList.size() > 0) {
                            CfgSlaveEntry cfgSlaveEntry = slaveEntryList.get(0);
                            fcslave = cfgSlaveEntry.getName();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Slave '" + fcslave + "' found for fc: " + fcname + " seq: " + seqIndex));
                            }
                        } else if (!builtInCmd.equals(BigDecimal.valueOf(0L))) {
                            fcslave = "BIC_SLAVE";
                        } else {
                            throw new ConvertException("No slave found for fc: " + fcname + " seq: " + seqIndex + " is BOMSLAVE: " + seq.isBomSlave());
                        }
                    }
                    Integer maxCalls = seq.getMaxCalls();
                    Integer maxRetry = seq.getMaxRetry();
                    String fcGroupName = seq.getGroupName();
                    if (fcGroupName == null) {
                        fcGroupName = "";
                    }
                    Hashtable<CfgRcEntry, CfgFctnRcReaction> rcclass = seq.getRcclass();
                    for (CfgRcEntry rcEntry : rcclass.keySet()) {
                        String rcName = rcEntry.getName();
                        CfgFctnRcReaction rcReaction = (CfgFctnRcReaction)rcclass.get(rcEntry);
                        String actionName = this.getReactionName(rcReaction);
                        Object[] object = new Object[]{fcname, seqIndex, rcName, actionName, fcslave, seqCount, maxCalls, maxRetry, currCalls, builtInCmd, fcGroupName};
                        for (int i = 0; i < object.length; ++i) {
                            insertStatement.setObject(i + 1, object[i]);
                        }
                        insertStatement.addBatch();
                    }
                    ++seqIndex;
                }
            }
            insertStatement.executeBatch();
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
            insertStatement.close();
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " cfgFctnToDb "));
        }
        this.userOutput.println(Converter.durationString(start, end) + " cfgFctnToDb end ");
    }

    private String getReactionName(CfgFctnRcReaction rcReaction) {
        switch (rcReaction.getAction()) {
            case RETURN: {
                return "RETURN";
            }
            case RETRY: {
                return "RETRY";
            }
            case FAIL: {
                return "FAIL";
            }
            case SKIP: {
                return "SKIP";
            }
            case STOP_JOB: {
                return "STOP_JOB";
            }
            case SUSPEND_JOB: {
                return "SUSPEND_JOB";
            }
            case EXCEPTION: {
                return "EXCEPTION";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        return null;
    }

    protected void slavesToDb() throws SQLException {
        List<CfgSlaveEntry> slaveList = this.cfgSlave.getSlaves();
        Date start = new Date();
        Long sysTime = this.getCurrentDateTime().getTime() / 1000L;
        String insertStatementString = "insert into tmp_slaves (slave_id, slave_name, host, ip_port, max_processes, type, sys_time, ubtnr_master) values (?,?,?,?,?,?,?,?)";
        PreparedStatement insertStatement = this.preparedStatementFactory.prepareStatement(insertStatementString);
        int slaveId = 0;
        Object[] bicSlave = null;
        for (CfgSlaveEntry slave : slaveList) {
            String slaveName = slave.getName();
            String host = slave.getHost();
            CtrlSlave.Type type = slave.getType();
            Integer ipPort = slave.getPort();
            Integer maxProcesses = slave.getMax();
            boolean fhPermanent = slave.fhPermanent();
            String typeString = type.toString();
            Integer ubtnrMaster = this.calcUbtnrMaster(slaveName, fhPermanent, type);
            Object[] slaveData = new Object[]{slaveName, host, ipPort, maxProcesses, typeString, sysTime, ubtnrMaster};
            if ("BIC_SLAVE".equalsIgnoreCase(slaveName)) {
                bicSlave = slaveData;
                continue;
            }
            Integer slaveIdObject = ++slaveId;
            insertStatement.setObject(1, slaveIdObject);
            for (int i = 0; i < slaveData.length; ++i) {
                insertStatement.setObject(i + 2, slaveData[i]);
            }
            insertStatement.addBatch();
        }
        if (bicSlave != null) {
            Integer slaveIdObject = slaveId += 2;
            insertStatement.setObject(1, slaveIdObject);
            for (int i = 0; i < bicSlave.length; ++i) {
                String value = bicSlave[i];
                if (value == null) {
                    value = "";
                }
                insertStatement.setObject(i + 2, value);
            }
            insertStatement.addBatch();
        }
        insertStatement.executeBatch();
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
        }
        insertStatement.close();
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " slavesToDb "));
        }
        this.userOutput.println(Converter.durationString(start, end) + "slavesToDb end ");
    }

    private Integer calcUbtnrMaster(String slaveName, boolean fhPermanent, CtrlSlave.Type type) {
        int ubtnrMaster = 0;
        if (fhPermanent) {
            ubtnrMaster |= 1;
        }
        if ("BIC_SLAVE".equalsIgnoreCase(slaveName)) {
            ubtnrMaster |= 8;
        }
        if ("localhost".equalsIgnoreCase(slaveName)) {
            ubtnrMaster |= 0x20;
        }
        if ("loopback".equalsIgnoreCase(slaveName)) {
            ubtnrMaster |= 0x40;
        }
        ubtnrMaster = CtrlSlave.Type.BOMSLAVE.equals((Object)type) ? (ubtnrMaster |= 0x200) : (ubtnrMaster |= 0x100);
        return ubtnrMaster;
    }

    public Date getCurrentDateTime() {
        return new Date();
    }

    private static MultiSchemaRowHandler getCAsciiWriteHandler() throws ConvertException {
        StandardAsciiSchemaRowWriteHandler standardAsciiSchemaRowWriteHandler;
        AllKeysAsciiSchemaRowWriteHandler allKeysAsciiSchemaRowWriteHandler = new AllKeysAsciiSchemaRowWriteHandler();
        try {
            standardAsciiSchemaRowWriteHandler = new StandardAsciiSchemaRowWriteHandler();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        AttrStringsAsciiSchemaRowWriteHandler attrStringsAsciiSchemaRowWriteHandler = new AttrStringsAsciiSchemaRowWriteHandler();
        StringsAsciiSchemaRowWriteHandler stringsAsciiSchemaRowWriteHandler = new StringsAsciiSchemaRowWriteHandler();
        MultiSchemaRowHandler multiSchemaRowHandler = new MultiSchemaRowHandler();
        multiSchemaRowHandler.addSchemaRowhandler(allKeysAsciiSchemaRowWriteHandler);
        multiSchemaRowHandler.addSchemaRowhandler(standardAsciiSchemaRowWriteHandler);
        multiSchemaRowHandler.addSchemaRowhandler(attrStringsAsciiSchemaRowWriteHandler);
        multiSchemaRowHandler.addSchemaRowhandler(stringsAsciiSchemaRowWriteHandler);
        return multiSchemaRowHandler;
    }

    protected void cAsciiDbExport() throws ConvertException {
        SchemaDescription schemaDescription = this.readSchemaDescription(C_ASCII_SCHEMA_XML[0]);
        MultiSchemaRowHandler cAsciiWriteHandler = Converter.getCAsciiWriteHandler();
        try {
            this.connection.setAutoCommit(false);
            JdbcSchemaDataReader cJdbcDataReader = new JdbcSchemaDataReader(schemaDescription, cAsciiWriteHandler, this.connection);
            cJdbcDataReader.addOrder("account.new", "account_id");
            cJdbcDataReader.addOrder("jobsteps.new", "job_id, sequence_no");
            cJdbcDataReader.addOrder("strings.new", "string_id, str_index");
            cJdbcDataReader.addOrder("attrstrings.new", "string_id, part");
            cJdbcDataReader.addOrder("cfg_jselect.new", "jselect_id");
            cJdbcDataReader.addOrder("funccall.new", "job_id, js_sequence_no, js_curr_retry, fc_sequence_no, fc_curr_retry");
            cJdbcDataReader.setPostfix("_TMP");
            cJdbcDataReader.read();
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    protected void cAsciiDbImport() throws ConvertException {
        SchemaDescription schemaDescription = this.readSchemaDescription(C_ASCII_SCHEMA_XML[0]);
        try {
            this.connection.setAutoCommit(false);
            AsciiToJdbcHandler cAsciiToJJdbcSqlConvertHandler = new AsciiToJdbcHandler(this.connection, this.fMaxBatchCount, this.fMaxFetchSize);
            cAsciiToJJdbcSqlConvertHandler.setTablePostFix("_TMP");
            AsciiFileSchemaDataReader cAsciiDataReader = new AsciiFileSchemaDataReader(schemaDescription, cAsciiToJJdbcSqlConvertHandler);
            cAsciiDataReader.read();
        }
        catch (Exception e) {
            throw new ConvertException(e.getMessage(), e);
        }
    }

    public void jAsciiDbImport() throws ConvertException {
        this.dbCreate();
        try {
            this.connection.setAutoCommit(false);
            SchemaDescription schemaDescription = this.readSchemaDescription(J_JDBC_SCHEMA_XML[0]);
            AsciiToJdbcHandler asciiToJdbcHandler = new AsciiToJdbcHandler(this.connection, this.fMaxBatchCount, this.fMaxFetchSize);
            AsciiFileSchemaDataReader schemaDataReader = new AsciiFileSchemaDataReader(schemaDescription, asciiToJdbcHandler);
            try {
                schemaDataReader.read();
                this.connection.commit();
            }
            catch (WrongVersionException e) {
                String version = e.getVersion();
                LOG.info((Object)("Update ASCII files from version " + version));
                SchemaDescription oldSchemaDescription = this.getJAsciiSchema(version);
                this.update(oldSchemaDescription);
            }
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    private void update(SchemaDescription oldSchemaDescription) throws ConvertException {
        String version = oldSchemaDescription.getVersion();
        boolean isAutocommitEnabled = true;
        this.sqlExec("removeTmpTables." + version + ".sql", false, isAutocommitEnabled);
        this.sqlExec("createTmpTables." + version + ".sql", true, isAutocommitEnabled);
        try {
            this.readCtrlCfgJsRcblog();
            this.connection.setAutoCommit(false);
            AsciiToJdbcHandler asciiToJdbcHandler = new AsciiToJdbcHandler(this.connection, this.fMaxBatchCount, this.fMaxFetchSize);
            asciiToJdbcHandler.setTablePostFix("_TMP");
            AsciiFileSchemaDataReader schemaDataReader = new AsciiFileSchemaDataReader(oldSchemaDescription, asciiToJdbcHandler);
            schemaDataReader.read();
            this.connection.commit();
            boolean isAutocommitEnabled2 = false;
            this.sqlExec("update." + version + ".sql", true, isAutocommitEnabled2);
            this.checkCtrlCfgJsRcblog();
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCtrlCfgJsRcblog() throws SQLException {
        Date start = new Date();
        String selectStatementString = "select JOBID, STEP from tmp_jobstep_rcblog where jobid is not null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                Object jobId = resultSet.getObject(colIndex++);
                Object step = resultSet.getObject(colIndex++);
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Can not read 'rcblog' attribute for jobstep: " + jobId + "." + step));
            }
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " checkCtrlCfgJsRcblog "));
        }
        this.userInfo(Converter.durationString(start, end) + " checkCtrlCfgJsRcblog end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCtrlCfgJsRcblog() throws SQLException {
        Date start = new Date();
        String insertStatementString = "insert into tmp_jobstep_rcblog (JOBNAME, STEP, RCBLOG) values (?, ?, ?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            for (Map.Entry<String, CfgJobEntry> entry : this.cfgJob.getEntries().entrySet()) {
                String jobName = entry.getKey();
                List<CfgJobStep> steps = entry.getValue().getSteps();
                for (int step = 1; step <= steps.size(); ++step) {
                    CfgJobStep cfgJobStep = steps.get(step - 1);
                    Integer rcblog = cfgJobStep.getRcbLog() ? Integer.valueOf(1) : Integer.valueOf(0);
                    int varIndex = 1;
                    insertStatement.setObject(varIndex++, jobName);
                    insertStatement.setObject(varIndex++, step);
                    insertStatement.setObject(varIndex++, rcblog);
                    insertStatement.addBatch();
                }
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " readCtrlCfgJsRcblog "));
        }
        this.userInfo(Converter.durationString(start, end) + " readCtrlCfgJsRcblog end ");
    }

    private SchemaDescription getJAsciiSchema(String version) throws ConvertException {
        for (String schemaName : J_JDBC_SCHEMA_XML) {
            SchemaDescription schemaDescription = this.readSchemaDescription(schemaName);
            if (!version.equals(schemaDescription.getVersion())) continue;
            return schemaDescription;
        }
        throw new ConvertException("Schema description not found for version " + version);
    }

    public void jAsciiDbExport() throws ConvertException {
        SchemaDescription schemaDescription = this.readSchemaDescription(J_JDBC_SCHEMA_XML[0]);
        try {
            StandardAsciiSchemaRowWriteHandler cAsciiWriteHandler = new StandardAsciiSchemaRowWriteHandler();
            this.connection.setAutoCommit(false);
            JdbcSchemaDataReader cJdbcDataReader = new JdbcSchemaDataReader(schemaDescription, cAsciiWriteHandler, this.connection);
            cJdbcDataReader.addOrder("CTRL_CFGJS", "ID, STEP");
            cJdbcDataReader.addOrder("CTRL_CFGJSL", "ID");
            cJdbcDataReader.addOrder("CTRL_FC", "JOBID, JOBSTEP, STEPRETRY, SEQNR, SEQRETRY, CALL_LEVEL");
            cJdbcDataReader.addOrder("CTRL_CFGJSPAR", "JSID, STEP, NR");
            cJdbcDataReader.read();
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    public void dbRemove() throws ConvertException {
        this.userOutput.println("dbRemove start");
        Date start = new Date();
        boolean isAutocommitEnabled = true;
        this.sqlExec("controllerUninstall.sql", false, isAutocommitEnabled);
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " dbRemove "));
        }
        this.userOutput.println(Converter.durationString(start, end) + " dbRemove end ");
    }

    public void dbCreate() throws ConvertException {
        this.userOutput.println("dbCreate start");
        Date start = new Date();
        boolean isAutocommitEnabled = true;
        this.sqlExec("controllerInstall.sql", true, isAutocommitEnabled);
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Converter.durationString(start, end) + " dbCreate "));
        }
        this.userOutput.println(Converter.durationString(start, end) + " dbCreate end ");
    }

    public static String durationString(Date start, Date end) {
        long durationFullMillis = end.getTime() - start.getTime();
        long milliseconds = durationFullMillis % 1000L;
        long seconds = durationFullMillis / 1000L;
        long minutes = seconds / 60L;
        long hours = (seconds %= 60L) / 60L;
        String durationString = MessageFormat.format("{0, number, ####00}:{1,number,00}:{2,number,00}.{3,number,000} ({4} ms)", hours, minutes %= 60L, seconds, milliseconds, durationFullMillis);
        return durationString;
    }

    private SchemaDescription readSchemaDescription(InputStream schemaInputStream) throws ConvertException {
        SchemaDescription schemaDescription;
        try {
            Unmarshaller unmarschaller = this.schemaContext.createUnmarshaller();
            schemaDescription = (SchemaDescription)unmarschaller.unmarshal(schemaInputStream);
        }
        catch (JAXBException e) {
            throw new ConvertException(e);
        }
        return schemaDescription;
    }

    private SchemaDescription readSchemaDescription(String name) throws ConvertException {
        InputStream schemaInputStream = Main.class.getClassLoader().getResourceAsStream(name);
        SchemaDescription schemaDescription = this.readSchemaDescription(schemaInputStream);
        try {
            schemaInputStream.close();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        return schemaDescription;
    }

    public void userInfo(String message) {
        this.userOutput.println(message);
    }

    public void createTmpSqlSchema(File sqlDerbyDstDir) throws ConvertException {
        List<String> jJdbcSchemaXmlList = Arrays.asList(J_JDBC_SCHEMA_XML);
        for (int schemaIndex = 1; schemaIndex < jJdbcSchemaXmlList.size(); ++schemaIndex) {
            PrintWriter createTmpTablesPrintWriter;
            PrintWriter dropTmpTablesPrintWriter;
            String jJdbcSchemaXml = jJdbcSchemaXmlList.get(schemaIndex);
            SchemaDescription schemaDescription = this.readSchemaDescription(jJdbcSchemaXml);
            if (!sqlDerbyDstDir.mkdirs() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Can not create directory: " + sqlDerbyDstDir.getAbsolutePath()));
            }
            List<TableDescription> tableDescriptionList = schemaDescription.getTableDescriptions();
            String version = schemaDescription.getVersion();
            File createTmpTablesFile = new File(sqlDerbyDstDir, "createTmpTables." + version + ".sql");
            File dropTmpTablesFile = new File(sqlDerbyDstDir, "removeTmpTables." + version + ".sql");
            try {
                dropTmpTablesPrintWriter = new PrintWriter(new FileWriter(dropTmpTablesFile));
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            for (TableDescription tableDescription : tableDescriptionList) {
                String fileName = tableDescription.getName();
                String postfix = "_TMP";
                String tableName = fileName.replaceAll("\\.", "_").toUpperCase(Locale.ENGLISH) + postfix;
                dropTmpTablesPrintWriter.print("DROP TABLE " + tableName + ";\n\n");
            }
            dropTmpTablesPrintWriter.close();
            try {
                createTmpTablesPrintWriter = new PrintWriter(new FileWriter(createTmpTablesFile));
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            List<TableDescription> tableDescriptionList2 = schemaDescription.getTableDescriptions();
            for (TableDescription tableDescription : tableDescriptionList2) {
                String fileName = tableDescription.getName();
                String postfix = "_TMP";
                String tableName = fileName.replaceAll("\\.", "_").toUpperCase(Locale.ENGLISH) + postfix;
                createTmpTablesPrintWriter.print("CREATE TABLE " + tableName + "(\n");
                List<IColumnDescription> columnDescriptionList = tableDescription.getColumnDescriptions();
                for (int i = 0; i < columnDescriptionList.size(); ++i) {
                    IColumnDescription columnDescription = columnDescriptionList.get(i);
                    String columnName = columnDescription.getName();
                    if (i != 0) {
                        createTmpTablesPrintWriter.print(",\n");
                    }
                    if (columnDescription instanceof IntegerColumnDescription) {
                        createTmpTablesPrintWriter.print("\t" + columnName + " DECIMAL(30,0)");
                        continue;
                    }
                    if (columnDescription instanceof HexColumnDescription) {
                        createTmpTablesPrintWriter.print("\t" + columnName + " DECIMAL(30,0)");
                        continue;
                    }
                    if (columnDescription instanceof StringColumnDescription) {
                        StringColumnDescription stringColumnDescription = (StringColumnDescription)columnDescription;
                        Integer maxlength = stringColumnDescription.getMaxlength();
                        if (maxlength == null) {
                            maxlength = 200;
                        }
                        createTmpTablesPrintWriter.print("\t" + columnName + " VARCHAR(" + maxlength + ")");
                        continue;
                    }
                    if (columnDescription instanceof CharColumnDescription) {
                        createTmpTablesPrintWriter.print("\t" + columnName + " VARCHAR(200)");
                        continue;
                    }
                    createTmpTablesPrintWriter.print("\t" + columnName);
                }
                createTmpTablesPrintWriter.print("\n);\n\n");
            }
            createTmpTablesPrintWriter.close();
        }
    }

    public CfgJob getCfgJob() {
        return this.cfgJob;
    }

    public PreparedStatement prepareStatement(String statementString) throws SQLException {
        return this.preparedStatementFactory.prepareStatement(statementString);
    }

    protected Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    static {
        SQL_PROTOCOL_HANDLER = PROTOCOL_HANDLER_DEFAULT = new SqlExec.IProtocolHandler(){
            private Date start = null;
            private PrintStream userOutput = System.out;

            public void protocol(Date date, int lineNo, SqlExec.EState state, String sqlStatement) {
                if (state.equals((Object)SqlExec.EState.START)) {
                    this.start = date;
                } else if (state.equals((Object)SqlExec.EState.FAIL)) {
                    String diff = Converter.durationString(this.start, date);
                    this.userOutput.println(diff + " ms FAIL   : " + sqlStatement);
                } else if (state.equals((Object)SqlExec.EState.SUCCESS)) {
                    String diff = Converter.durationString(this.start, date);
                    this.userOutput.println(diff + " ms SUCCESS: " + sqlStatement);
                }
            }

            public void protocol(Date date, int lineNo, SqlExec.EState fail, String sqlStatement, SQLException exception) {
                String diff = Converter.durationString(this.start, date);
                this.userOutput.println(diff + " ms FAIL   : " + sqlStatement);
                exception.printStackTrace(this.userOutput);
            }
        };
        LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.convert");
    }

    private static final class ConvertInvocationHandler
    implements InvocationHandler {
        private ConvertInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return Void.TYPE;
        }
    }
}

