/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.HexColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.IRowsetReader;
import de.axway.aim.controller.master.convert.SimpleRowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalsRowset
implements IRowsetReader {
    private static final Log LOG = LogFactory.getLog((String)"de.axway.Controller");
    private BufferedReader br;
    private boolean isHeader;
    private int lineNr = 0;
    private File file;
    private SimpleRowset rs;
    private Object[] rowDataHash;
    private boolean hasAlreadyRead = false;

    public GlobalsRowset(TableDescription tableDescription, File dirAsciiData) throws Exception {
        this.rs = new SimpleRowset(tableDescription);
        this.isHeader = true;
        String tableName = tableDescription.getName();
        this.file = new File(dirAsciiData, tableName);
        this.br = new BufferedReader(new FileReader(this.file));
        this.rs.setExpectedEntries(-1);
        Pattern patternVersion = Pattern.compile("VERSION=(.*)");
        Pattern patternExpectedEntries = Pattern.compile("# Expected Entries=(.*)");
        Pattern patternCreationDate = Pattern.compile("# \\*\\*\\*\\*\\* Creation date: (.*) \\*\\*\\*\\*\\*");
        Pattern patternSource = Pattern.compile("# \\*\\*\\*\\*\\* Source: (.*)");
        String line = this.br.readLine();
        while (line != null) {
            Matcher versionMatcher = patternVersion.matcher(line);
            Matcher matcherExpectedEntries = patternExpectedEntries.matcher(line);
            Matcher matcherSource = patternSource.matcher(line);
            Matcher matcherCreationDate = patternCreationDate.matcher(line);
            if (matcherExpectedEntries.matches()) {
                this.rs.setExpectedEntries(Integer.parseInt(matcherExpectedEntries.group(1)));
            } else {
                if (versionMatcher.matches()) {
                    this.rs.setVersion(versionMatcher.group(1));
                    break;
                }
                if (matcherSource.matches()) {
                    this.rs.source = matcherSource.group(1);
                } else if (matcherCreationDate.matches()) {
                    this.rs.creationDate = matcherCreationDate.group(1);
                }
            }
            line = this.br.readLine();
            ++this.lineNr;
        }
    }

    @Override
    public Object[] getRowData() {
        return this.rowDataHash;
    }

    @Override
    public boolean next() throws Exception {
        if (this.hasAlreadyRead) {
            return false;
        }
        Pattern idPattern = Pattern.compile("\\s*ID\\s*=(.*)");
        int fieldCount = 0;
        String line = this.br.readLine();
        while (line != null) {
            Matcher idMatcher = idPattern.matcher(line);
            if (idMatcher.matches()) {
                this.isHeader = false;
                if (this.rs.getExpectedEntries() > 0) {
                    List<IColumnDescription> columnDescriptions = this.rs.tableDescription.getColumnDescriptions();
                    Iterator<IColumnDescription> iterator2 = columnDescriptions.iterator();
                    IColumnDescription columnDescription = iterator2.next();
                    Object value = idMatcher.group(1).trim().replaceFirst("^\"(.*)\"", "$1");
                    ++fieldCount;
                    this.rowDataHash = new Object[columnDescriptions.size()];
                    int i = 0;
                    this.rowDataHash[i++] = value;
                    while (iterator2.hasNext()) {
                        columnDescription = iterator2.next();
                        line = this.br.readLine();
                        ++this.lineNr;
                        String valueString = line.trim().replaceFirst("^\"(.*)\"", "$1");
                        value = columnDescription instanceof HexColumnDescription ? Integer.valueOf(valueString, 16) : valueString;
                        ++fieldCount;
                        this.rowDataHash[i++] = value;
                    }
                    this.hasAlreadyRead = true;
                    return true;
                }
            } else if (!this.isHeader) {
                if (line.matches("^\\s*(#.*)?$")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ignore line " + this.lineNr + ": " + line));
                    }
                } else {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("error at line " + this.lineNr + ": " + line + " " + this.file.getAbsolutePath() + ")"));
                    }
                    throw new Exception("parse error");
                }
            }
            line = this.br.readLine();
            ++this.lineNr;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        this.br.close();
    }

    @Override
    public IRowset getRowSet() {
        return this.rs;
    }
}

