/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.PreparedStatementInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PreparedStatementFactory {
    private final Connection fieldConnection;
    private int fieldMaxBatchCount;
    private final int fieldMaxFetchSize;

    public PreparedStatementFactory(Connection connection, int maxBatchCount, int maxFetchSize) {
        this.fieldConnection = connection;
        this.fieldMaxBatchCount = maxBatchCount;
        this.fieldMaxFetchSize = maxFetchSize;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatementInvocationHandler preparedStatementInvocationHandler = new PreparedStatementInvocationHandler(this.fieldConnection, sql, this.fieldMaxBatchCount, this.fieldMaxFetchSize);
        PreparedStatement preparedStatement = (PreparedStatement)Proxy.newProxyInstance(PreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)preparedStatementInvocationHandler);
        return preparedStatement;
    }
}

