/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.convert");
    private int fieldMaxBatchCount;
    private PreparedStatement preparedStatement;
    private int currBatchCount = 0;

    public PreparedStatementInvocationHandler(Connection connection, String insertStatement, int maxBatchCount, int maxFetchSize) throws SQLException {
        this.fieldMaxBatchCount = maxBatchCount;
        this.preparedStatement = connection.prepareStatement(insertStatement);
        this.preparedStatement.setFetchSize(maxFetchSize);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (method.getName().equals("addBatch")) {
            this.addBatch();
            result = Void.TYPE;
        } else {
            try {
                result = method.invoke((Object)this.preparedStatement, args);
            }
            catch (Throwable t) {
                throw new Exception("Invocation failed: " + method.getName() + Arrays.toString(args), t);
            }
        }
        return result;
    }

    private void addBatch() throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addBatch count: " + this.currBatchCount));
        }
        this.preparedStatement.addBatch();
        ++this.currBatchCount;
        if (this.fieldMaxBatchCount != -1 && this.currBatchCount > this.fieldMaxBatchCount) {
            this.preparedStatement.executeBatch();
            this.currBatchCount = 0;
        }
    }
}

