/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.Converter;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.IRowsetReader;
import de.axway.aim.controller.master.convert.ISchemahandler;
import de.axway.aim.controller.master.convert.SchemaDescription;
import de.axway.aim.controller.master.convert.TableDescription;
import de.axway.aim.controller.master.convert.WrongVersionException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class SchemaDataReader {
    private ISchemahandler fieldSchemaRowhandler;
    private SchemaDescription fieldSchemaDescription;

    public SchemaDataReader(SchemaDescription schemaDescription, ISchemahandler schemaRowhandler) {
        this.fieldSchemaDescription = schemaDescription;
        this.fieldSchemaRowhandler = schemaRowhandler;
    }

    public void read() throws WrongVersionException, Exception {
        PrintStream userPrintStream = System.out;
        List<TableDescription> tableDescriptionList = this.fieldSchemaDescription.getTableDescriptions();
        String schemaVersion = this.fieldSchemaDescription.getVersion();
        Iterator<TableDescription> tableDescriptionIterator = tableDescriptionList.iterator();
        while (tableDescriptionIterator.hasNext()) {
            Date start = new Date();
            TableDescription tableDescription = tableDescriptionIterator.next();
            String tableName = tableDescription.getName();
            IRowsetReader rowsetReader = this.getRowSetReader(tableDescription, tableName);
            IRowset rowset = rowsetReader.getRowSet();
            String asciiVersion = rowset.getVersion();
            userPrintStream.println("====================================");
            userPrintStream.println("TABLE: " + tableName + " (" + asciiVersion + ") start");
            if (!schemaVersion.equals(asciiVersion)) {
                throw new WrongVersionException(asciiVersion, "ASCII file format (" + asciiVersion + ") differs to current schema format (" + schemaVersion + ").");
            }
            this.fieldSchemaRowhandler.handleTableStart(rowset);
            while (rowsetReader.next()) {
                Object[] rowDataArray = rowsetReader.getRowData();
                this.fieldSchemaRowhandler.handleTableRow(rowDataArray);
            }
            rowsetReader.close();
            this.fieldSchemaRowhandler.handleTableEnd(rowset);
            Date end = new Date();
            String diff = Converter.durationString(start, end);
            userPrintStream.println(diff + " TABLE: " + tableName + " (" + asciiVersion + ") end ");
        }
        this.fieldSchemaRowhandler.close();
    }

    protected abstract IRowsetReader getRowSetReader(TableDescription var1, String var2) throws Exception;
}

