/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.BaseAsciiWriter;
import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringsAsciiSchemaRowWriteHandler
extends BaseAsciiWriter {
    private Object currentStringId = null;
    private ArrayList<Object[]> rowDataHashList = null;
    private int stringIdIndex = -1;
    private int jTypeIndex = -1;
    private int nameIndex = -1;
    private int valueIndex = -1;

    @Override
    public void close() {
    }

    @Override
    public void handleTableStart(IRowset rowSet) throws ConvertException {
        if (!rowSet.equals(this.rowSet) && rowSet.getTableDescription().getName().equals("strings.new")) {
            this.rowSet = rowSet;
            TableDescription tableDescription = this.rowSet.getTableDescription();
            List<IColumnDescription> columnDescriptions = tableDescription.getColumnDescriptions();
            for (int i = 0; i < columnDescriptions.size(); ++i) {
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("string_id")) {
                    this.stringIdIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("j_type")) {
                    this.jTypeIndex = i;
                    continue;
                }
                if (columnDescriptions.get(i).getName().equalsIgnoreCase("name")) {
                    this.nameIndex = i;
                    continue;
                }
                if (!columnDescriptions.get(i).getName().equalsIgnoreCase("value")) continue;
                this.valueIndex = i;
            }
            this.rowIndex = 0;
            String actisedi = System.getProperty("ACTISEDI");
            String name = rowSet.getTableDescription().getName();
            this.file = new File(actisedi + "/spool/asciidata/" + name);
            this.fileTmp = new File(actisedi + "/spool/asciidata/" + name + ".tmp");
            try {
                this.pw = new PrintWriter(new FileWriter(this.fileTmp));
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            String version = rowSet.getVersion();
            this.pw.println();
            this.pw.println("# ***** Creation date: " + rowSet.getCreationDate() + " *****");
            this.pw.println("# ***** Source: " + rowSet.getSource());
            this.pw.println("#");
            this.pw.println("#  1. ID=String_ID         (DB-Key)");
            this.pw.println("#  2. \tNoS (Number of Stringpairs)\t\t\t\t\t\t(since v1202)");
            this.pw.println("#  3. \tL<LeftString_1>\t\tOR\tl for Nil-LeftString\t(since v1202)");
            this.pw.println("#  4. \tR<RightString_1>\tOR\tr for Nil-RightString\t(since v1202)");
            this.pw.println("#  5. \tL\t...\t\t\t\tOR\tl\t\t...");
            this.pw.println("#  6. \tR\t...\t\t\t\tOR\tr\t\t...");
            this.pw.println("#  7. \tL<LeftString_NoS>\tOR\tl for Nil-LeftString\t(since v1202)");
            this.pw.println("#  8. \tR<RightString_NoS>\tOR\tr for Nil-RightString\t(since v1202)");
            this.pw.println("#");
            this.pw.println("# Expected Entries=");
            this.pw.println("                                                                     ");
            this.pw.println("VERSION=" + version);
            this.pw.println();
            this.pw.println();
        }
    }

    @Override
    public void handleTableRow(Object[] rowDataArray) {
        if (this.rowSet != null) {
            Object stringId = rowDataArray[this.stringIdIndex];
            if (!stringId.equals(this.currentStringId)) {
                ++this.rowIndex;
                this.writeEntry();
                this.currentStringId = stringId;
                this.rowDataHashList = new ArrayList();
            }
            this.rowDataHashList.add(rowDataArray);
        }
    }

    @Override
    protected void writeEntry() {
        if (this.rowDataHashList != null) {
            Iterator<Object[]> rowDataHashIterator = this.rowDataHashList.iterator();
            Object[] rowDataArray = rowDataHashIterator.next();
            Object id = rowDataArray[this.stringIdIndex];
            this.pw.println("ID=" + id);
            int noS3 = this.rowDataHashList.size();
            this.pw.println("\t" + noS3);
            while (true) {
                String right;
                String left;
                Object jType = rowDataArray[this.jTypeIndex];
                Object rName = rowDataArray[this.nameIndex];
                Object rValue = rowDataArray[this.valueIndex];
                if ("EA".equals(jType) || "SA".equals(jType)) {
                    left = "l";
                    right = "R" + rName + "=" + rValue;
                } else {
                    left = rName == null || rName.equals("") ? "l" : "L" + rName;
                    right = "R" + rValue;
                }
                this.pw.println("\t" + left);
                this.pw.println("\t" + right);
                if (!rowDataHashIterator.hasNext()) break;
                rowDataArray = rowDataHashIterator.next();
            }
            this.pw.println();
            this.rowDataHashList = null;
        }
    }
}

