/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.queue.ActivateJob;
import de.axway.aim.controller.master.queue.IWait;
import de.axway.aim.controller.master.queue.WaitQueue;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivateQueue
extends WaitQueue {
    private Log log = LogFactory.getLog((String)"master.queue.Activate");
    private CtrlDispAppl dispatcher;

    public ActivateQueue(CtrlDispAppl dispatcher) {
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)"created");
        }
        this.setName("ActivateQueue");
        this.dispatcher = dispatcher;
    }

    public void newJob(IJob job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId()));
        }
        super.newWaitJob(new ActivateJob(job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exec(IWait job) throws SQLException, InterruptedException, LockException {
        Connection con = null;
        if (this.getLog().isTraceEnabled()) {
            this.log.trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)("ID: " + job.getId()));
        }
        try {
            con = this.dispatcher.getConnection();
        }
        catch (SQLException e) {
            try {
                this.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.getLog().isDebugEnabled()) {
                this.log.debug((Object)"return false");
            }
            return false;
        }
        try {
            this.dispatcher.activateJob(job.getId(), -1L, con, "TIMEOUT: TIME_UNTIL=" + Logbook.getStrDate(job.getWaitDate()));
        }
        finally {
            con.close();
        }
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)"return true");
        }
        return true;
    }

    @Override
    public Log getLog() {
        return this.log;
    }
}

