/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.IId;
import de.axway.aim.controller.master.IJob;

public abstract class IWait
implements Comparable<IWait> {
    private IId job;
    private long waitDate;

    protected abstract long getWaitDate();

    public IId getJob() {
        return this.job;
    }

    public long getId() {
        return this.job.getId();
    }

    @Override
    public int compareTo(IWait job) {
        long ret = this.waitDate - job.waitDate;
        if (ret < 0L) {
            return -1;
        }
        if (ret > 0L) {
            return 1;
        }
        if (this.getId() < job.getId()) {
            return -1;
        }
        if (this.getId() == job.getId()) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return Long.valueOf(this.job.getId()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IWait) {
            return this.job.getId() == ((IWait)obj).job.getId();
        }
        return false;
    }

    public boolean hasNameAndStep() {
        return this.job instanceof IJob;
    }

    public String getJobAndStep() {
        if (this.job instanceof IJob) {
            String step = ((IJob)this.job).getCurrentStepName();
            if (step == null) {
                return ((IJob)this.job).getName() + "/-";
            }
            return ((IJob)this.job).getName() + "/" + step;
        }
        return "?/?";
    }

    public IWait(IId job) {
        this.job = job;
        this.waitDate = this.getWaitDate();
    }

    protected void reset() {
        this.waitDate = this.getWaitDate();
    }

    protected long getFirstWaitDate() {
        return this.waitDate;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getId() + ", execDate: " + this.waitDate + ", jobAndStep: " + this.getJobAndStep();
    }
}

