/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.JobSeq;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSeqQueue
implements JobQueue {
    private Log log = LogFactory.getLog((String)"master.queue.JobSeq");
    private JobQueue jssq;
    private Hashtable<String, JobSeq> seqs = new Hashtable();
    private Hashtable<IJob, JobSeq> jobSeqs = new Hashtable();
    private boolean started = false;

    public JobSeqQueue(JobQueue queue) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("created: " + queue));
        }
        this.jssq = queue;
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(boolean verbose) {
        String ret = "Sequences: " + this.seqs.size() + ", Jobs: " + this.jobSeqs.size();
        Hashtable<String, JobSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            Enumeration<JobSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                JobSeq seq = e.nextElement();
                ret = ret + "\n   " + seq.getName() + ": " + seq.size() + " waiting jobs, running job ID: " + (seq.getRunning() == null ? "NO job running" : seq.getRunning().getId() + ", Status: " + seq.getRunning().getStatusText());
                if (!verbose) continue;
                ret = ret + seq.getStatus("    ", verbose);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Hashtable<String, JobSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            this.started = true;
            Enumeration<JobSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                e.nextElement().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Hashtable<String, JobSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            this.started = false;
            Enumeration<JobSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                e.nextElement().shutdown();
            }
            this.seqs.clear();
        }
    }

    public void newJob(IJob job) {
        this.runJob(job, false, job.getStatus() == 5);
    }

    @Override
    public void runJob(IExecutable job) {
        if (job instanceof IJob) {
            this.runJob((IJob)job, true, false);
        } else {
            this.jssq.runJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob(IJob job, boolean doRun, boolean isRun) {
        JobSeq seq;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId()));
        }
        if (!job.isSeq()) {
            if (this.getLog().isDebugEnabled()) {
                this.log.debug((Object)("job " + job.getId() + " IS NOT sequentialized"));
            }
            if (doRun) {
                this.jssq.runJob(job);
            }
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)("job " + job.getId() + " IS sequentialized"));
        }
        String seqName = job.getSeqName();
        Hashtable<String, JobSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            seq = this.seqs.get(seqName);
            if (seq == null) {
                seq = new JobSeq(this.log, this.jssq, seqName, this.started);
                this.seqs.put(seqName, seq);
            }
            this.jobSeqs.put(job, seq);
        }
        seq.add(job, doRun, isRun);
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)("end true: " + job.getId()));
        }
    }

    public void jobDone(IJob job) {
        JobSeq seq = this.jobSeqs.get(job);
        if (this.jobSeqs.remove(job) == null) {
            this.log.error((Object)("job " + job.getId() + " not removed from job seqs"));
        }
        if (seq == null) {
            this.getLog().error((Object)("jobSequence " + job.getSeqName() + " (job " + job.getId() + ") not found"));
            return;
        }
        if (!seq.remove(job)) {
            this.getLog().error((Object)("Job " + job.getId() + " not found in jobsequence " + job.getSeqName()));
        }
    }

    public Log getLog() {
        return this.log;
    }
}

