/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.StepSeq;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStepSeqQueue
implements JobQueue {
    private Log log = LogFactory.getLog((String)"master.queue.JobStepSeq");
    private JobQueue sleepQueue;
    private Hashtable<String, StepSeq> seqs = new Hashtable();
    private Hashtable<IJobStep, StepSeq> stepSeqs = new Hashtable();
    private boolean started = false;
    private CtrlDispAppl dispatcher;

    public JobStepSeqQueue(JobQueue sleepQueue, CtrlDispAppl dispatcher) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("create: " + sleepQueue));
        }
        this.sleepQueue = sleepQueue;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Hashtable<String, StepSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            this.started = true;
            Enumeration<StepSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                e.nextElement().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Hashtable<String, StepSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            this.started = false;
            Enumeration<StepSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                e.nextElement().shutdown();
            }
            this.seqs.clear();
        }
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(boolean verbose) {
        String ret = "Sequences: " + this.seqs.size() + ", SeqJobSteps: " + this.stepSeqs.size();
        Hashtable<String, StepSeq> hashtable = this.seqs;
        synchronized (hashtable) {
            Enumeration<StepSeq> e = this.seqs.elements();
            while (e.hasMoreElements()) {
                StepSeq seq = e.nextElement();
                ret = ret + seq.getStatus("    ", verbose);
            }
        }
        return ret;
    }

    @Override
    public void runJob(IExecutable executable) {
        StepSeq seq;
        if (!(executable instanceof IJob)) {
            this.sleepQueue.runJob(executable);
            return;
        }
        IJob job = (IJob)executable;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId()));
        }
        IJobStep js = (IJobStep)job.getCurrentStep();
        if (js.isSeq()) {
            seq = this.seqs.get(js.getSeqName());
            if (seq == null) {
                this.dispatcher.stopJob(job, (Exception)((Object)new CfgException("seq " + js.getSeqName() + " not found")));
                return;
            }
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("job step " + job.getId() + "." + job.getActiveStep() + " IS NOT sequentialized"));
            }
            this.sleepQueue.runJob(job);
            return;
        }
        seq.runJs(js);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end: true");
        }
    }

    public void jobStepDone(IJobStep js) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start: " + (Object)((Object)js)));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start: ID:" + js.getJobId()));
        }
        if (js.isSeq()) {
            StepSeq seq = this.stepSeqs.get((Object)js);
            if (seq != null) {
                if (this.stepSeqs.remove((Object)js) == null) {
                    this.log.error((Object)("step " + js.getJobId() + '.' + js.getStepNo() + " not removed in js seq queue"));
                }
                seq.removeJobStep(js);
            } else {
                this.log.error((Object)("step seq queue for step " + js.getJobId() + '.' + js.getStepNo() + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSeqJob(IJob job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId()));
        }
        List steps = job.getSeqSteps();
        for (IJobStep js : steps) {
            StepSeq sts;
            String seqName = js.getSeqName();
            Hashtable<String, StepSeq> hashtable = this.seqs;
            synchronized (hashtable) {
                sts = this.seqs.get(seqName);
                if (sts == null) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("new jobstepseq: " + seqName));
                    }
                    sts = new StepSeq(seqName, this.sleepQueue, this.log, this.started);
                    this.seqs.put(seqName, sts);
                }
                this.stepSeqs.put(js, sts);
            }
            sts.addJobStep(js);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end:");
        }
    }

    public Log getLog() {
        return this.log;
    }
}

