/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IRemovable;
import de.axway.aim.controller.master.queue.IWait;
import de.axway.aim.controller.master.queue.RemoveJob;
import de.axway.aim.controller.master.queue.RemoveThread;
import de.axway.aim.controller.master.queue.WaitQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoveQueue
extends WaitQueue {
    private CtrlDispAppl dispatcher;
    private static Log log = LogFactory.getLog((String)"master.queue.Remove");

    public RemoveQueue(CtrlDispAppl dispatcher) {
        this(dispatcher, "RemoveQueue");
    }

    public RemoveQueue(CtrlDispAppl dispatcher, String name) {
        if (this.getLog().isDebugEnabled()) {
            log.debug((Object)"created");
        }
        this.setName(name);
        this.dispatcher = dispatcher;
    }

    public void newRemoveJob(IRemovable job) {
        if (job instanceof IJob) {
            if (!this.dispatcher.getEdiboss().delDbJob()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DEL_DB_JOB=y, job " + job.getId() + " ignored"));
                }
                return;
            }
        } else if (job instanceof CtrlEvent && !this.dispatcher.getEdiboss().delDbEvent()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DEL_DB_EVENT=y, event " + job.getId() + " ignored"));
            }
            return;
        }
        super.newWaitJob(new RemoveJob(job));
    }

    @Override
    protected boolean exec(IWait job) {
        if (this.getLog().isTraceEnabled()) {
            if (job instanceof RemoveJob) {
                IRemovable job2 = ((RemoveJob)job).getRemovable();
                this.getLog().trace((Object)("start remove job: " + job2));
            } else {
                this.getLog().trace((Object)("start remove job: " + job));
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start remove job ID: " + job.getId()));
        }
        this.dispatcher.getRemoveThreadPool().execute(new RemoveThread(0, (RemoveJob)job, this.dispatcher));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end: true");
        }
        return true;
    }

    @Override
    public Log getLog() {
        return log;
    }
}

