/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.queue.RemoveJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RemoveThread
extends WorkerThread {
    private static Log log = LogFactory.getLog((String)"master.queue.Remove");
    private RemoveJob job;
    private CtrlDispAppl dispatcher;

    public RemoveThread(int retry, RemoveJob job, CtrlDispAppl dispatcher) {
        super("Remove " + job.getId(), 3);
        this.job = job;
        this.dispatcher = dispatcher;
    }

    @Override
    public void doRun() {
        try {
            for (int i = 1; i <= 10; ++i) {
                try {
                    this.dispatcher.remove(this.job.getRemovable(), true);
                    return;
                }
                catch (Exception e) {
                    if (i != 10) {
                        log.error((Object)("Error (count=" + i + "/10) at remove of job " + this.job.getId() + " , will retry in 10 minutes. Cause: "), (Throwable)e);
                        Thread.sleep(600000L);
                        continue;
                    }
                    log.error((Object)("Error (count=" + i + "/10) at remove of job " + this.job.getId() + " . It is the last try, will not be tried again. Cause: "), (Throwable)e);
                    continue;
                }
            }
        }
        catch (InterruptedException ie) {
            log.debug((Object)(" remove thread for job " + this.job.getId() + " interrupted: "), (Throwable)ie);
        }
    }
}

