/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.SyncJob;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunQueue
implements JobQueue {
    private static Log log = LogFactory.getLog((String)"master.queue.Run");
    private Map<IExecutable, List<SlaveHandler>> jobSlavelist = new Hashtable<IExecutable, List<SlaveHandler>>();
    private Hashtable<SlaveHandler, SortedSet<IExecutable>> slaveJoblist = new Hashtable();
    private boolean shutdown = false;
    private LockDaemon ld;
    private CtrlDispAppl dispatcher;
    private long tGetJob = 0L;
    private long tGetRemove = 0L;
    private long tGetSync = 0L;

    public RunQueue(LockDaemon ld, CtrlDispAppl dispatcher) {
        this.getLog().debug((Object)"created");
        this.ld = ld;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Set<SlaveHandler> shl) {
        this.shutdown = true;
        this.getLog().debug((Object)"start:");
        Iterator<SlaveHandler> it = shl.iterator();
        while (it.hasNext()) {
            SlaveHandler sh;
            SlaveHandler slaveHandler = sh = it.next();
            synchronized (slaveHandler) {
                SortedSet<IExecutable> jobs = this.slaveJoblist.get(sh);
                if (jobs != null) {
                    jobs.clear();
                }
            }
        }
        this.jobSlavelist.clear();
        this.slaveJoblist.clear();
        this.getLog().debug((Object)"end:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(IJob job) {
        IJobStep js = (IJobStep)job.getCurrentStep();
        if (js == null) {
            return false;
        }
        List<SlaveHandler> shl = this.jobSlavelist.get(job);
        if (shl == null || shl.size() < 1) {
            return false;
        }
        IJob iJob = job;
        synchronized (iJob) {
            Iterator<SlaveHandler> it = shl.iterator();
            while (it.hasNext()) {
                SlaveHandler sh;
                SlaveHandler slaveHandler = sh = it.next();
                synchronized (slaveHandler) {
                    SortedSet<IExecutable> jobs = this.slaveJoblist.get(sh);
                    if (jobs != null && jobs.size() > 0) {
                        return jobs.remove(job);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(IJob job) {
        IJobStep js = (IJobStep)job.getCurrentStep();
        if (js == null) {
            return;
        }
        List<SlaveHandler> shl = this.jobSlavelist.get(job);
        if (shl == null || shl.size() < 1) {
            return;
        }
        IJob iJob = job;
        synchronized (iJob) {
            Iterator<SlaveHandler> it = shl.iterator();
            while (it.hasNext()) {
                SlaveHandler sh;
                SlaveHandler slaveHandler = sh = it.next();
                synchronized (slaveHandler) {
                    SortedSet<IExecutable> jobs = this.slaveJoblist.get(sh);
                    if (jobs != null && jobs.size() > 0) {
                        jobs.add(job);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(SlaveHandler sh) {
        SlaveHandler slaveHandler = sh;
        synchronized (slaveHandler) {
            SortedSet<IExecutable> jobs = this.slaveJoblist.get(sh);
            if (jobs == null) {
                return 0;
            }
            return jobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob(IExecutable job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start: job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start: ID: " + job.getId()));
        }
        List<SlaveHandler> fh = null;
        try {
            fh = job.getSlaves();
        }
        catch (CfgException e) {
            this.dispatcher.stopJob(job, (Exception)((Object)e));
            return;
        }
        if (fh == null || fh.size() < 1) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("end: " + job.getId()));
            }
            this.dispatcher.stopJob(job, (Exception)((Object)new CfgException("no functionhandler defined")));
            return;
        }
        if (this.jobSlavelist.put(job, fh) != null) {
            this.dispatcher.stopJob(job, (Exception)((Object)new CfgException("Job " + job.getId() + " is already in jobSlavelist!!!")));
            return;
        }
        IExecutable iExecutable = job;
        synchronized (iExecutable) {
            for (SlaveHandler sh : fh) {
                if (sh.getSlave().getName() == null) {
                    log.error((Object)("slave name for job " + job.getId() + " is null"));
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                SlaveHandler slaveHandler = sh;
                synchronized (slaveHandler) {
                    SortedSet<IExecutable> joblist;
                    if (this.shutdown) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"runJob ends because of shutdown: true");
                        }
                        return;
                    }
                    Hashtable<SlaveHandler, SortedSet<IExecutable>> hashtable = this.slaveJoblist;
                    synchronized (hashtable) {
                        joblist = this.slaveJoblist.get(sh);
                        if (joblist == null) {
                            joblist = new TreeSet<IExecutable>();
                            if (this.slaveJoblist.put(sh, joblist) != null) {
                                this.getLog().error((Object)("Create new TreeSet for slave " + sh.getSlave().getName() + ", but already exists"));
                            } else {
                                this.getLog().info((Object)("Create new TreeSet for slave " + sh.getSlave().getName()));
                            }
                        }
                    }
                    if (!joblist.add(job)) {
                        this.getLog().error((Object)("Job " + job.getId() + " is already in List for " + sh.getSlave().getName()));
                    }
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("newJob for " + sh.getName()));
                }
                sh.newJob();
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end: true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IExecutable getNext(SlaveHandler sh) throws LockException {
        long tGetSyncTemp;
        Set joblist;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("RunQueue:getNext[slave=" + sh.getSlave().getName() + "]"));
        }
        if ((joblist = (Set)this.slaveJoblist.get(sh)) == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("No joblist for SlaveHandler " + sh.getName()));
            }
            return null;
        }
        IExecutable nextJob = null;
        long tStart = System.currentTimeMillis();
        boolean syncLockAquired = false;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("RunQueue:getNext[slave=" + sh.getSlave().getName() + "]: Wait to enter synchronized (sh)"));
        }
        SlaveHandler slaveHandler = sh;
        synchronized (slaveHandler) {
            try {
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("RunQueue:getNext[slave=" + sh.getSlave().getName() + "]: Entered synchronized (sh)"));
                }
                if (this.shutdown) {
                    IExecutable iExecutable = null;
                    return iExecutable;
                }
                tGetSyncTemp = System.currentTimeMillis();
                this.tGetSync += tGetSyncTemp - tStart;
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("RunQueue:getNext[slave=" + sh.getSlave().getName() + "]: joblist.size=" + joblist.size()));
                }
                Iterator itJoblist = joblist.iterator();
                while (itJoblist.hasNext() && nextJob == null) {
                    IExecutable job = (IExecutable)itJoblist.next();
                    try {
                        syncLockAquired = this.ld.globalLock((SyncObject)new SyncJob(job));
                        if (!syncLockAquired) continue;
                        if (this.getLog().isTraceEnabled()) {
                            this.getLog().trace((Object)("RunQueue:getNext[job=" + job.getId() + ", slave=" + sh.getSlave().getName() + "]: sync locked job."));
                        }
                        if (!this.ld.globalLock((SyncObject)new LockJob(job.getId(), false))) continue;
                        nextJob = job;
                    }
                    finally {
                        if (nextJob != null) continue;
                        try {
                            if (this.getLog().isTraceEnabled()) {
                                this.getLog().trace((Object)("RunQueue:getNext[job=" + job.getId() + ", slave=" + sh.getSlave().getName() + ", syncLockAquired=" + syncLockAquired + "]: sync unlocked job."));
                            }
                            this.ld.globalUnLock((SyncObject)new SyncJob(job));
                        }
                        catch (LockException le) {
                            this.getLog().error((Object)("RunQueue:getNext[job=" + job.getId() + ", slave=" + sh.getSlave().getName() + ", syncLockAquired=" + syncLockAquired + "]: Failed to sync unlock job."), (Throwable)le);
                        }
                    }
                }
            }
            finally {
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("RunQueue:getNext[slave=" + sh.getSlave().getName() + "]: Exit synchronized (sh)"));
                }
            }
        }
        long tGetJobTemp = System.currentTimeMillis();
        this.tGetJob += tGetJobTemp - tGetSyncTemp;
        if (nextJob != null) {
            this.remove(nextJob);
            try {
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("RunQueue:getNext[job=" + nextJob.getId() + ", slave=" + sh.getSlave().getName() + ", syncLockAquired=" + syncLockAquired + "]: sync unlocked job."));
                }
                this.ld.globalUnLock((SyncObject)new SyncJob(nextJob));
            }
            catch (LockException le) {
                this.getLog().error((Object)("RunQueue:getNext[job=" + nextJob.getId() + ", slave=" + sh.getSlave().getName() + ", syncLockAquired=" + syncLockAquired + "]: Failed to sync unlock job."), (Throwable)le);
            }
        }
        long tGetRemoveTemp = System.currentTimeMillis();
        this.tGetRemove += tGetRemoveTemp - tGetJobTemp;
        return nextJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IExecutable job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start ID: " + job.getId()));
        }
        List<SlaveHandler> fh = this.jobSlavelist.get(job);
        if (fh != null) {
            IExecutable iExecutable = job;
            synchronized (iExecutable) {
                Iterator<SlaveHandler> itHandler = fh.iterator();
                while (itHandler.hasNext()) {
                    SlaveHandler sh;
                    SlaveHandler slaveHandler = sh = itHandler.next();
                    synchronized (slaveHandler) {
                        SortedSet<IExecutable> lex = this.slaveJoblist.get(sh);
                        if (lex != null) {
                            if (!lex.remove(job)) {
                                this.getLog().error((Object)("Cannot remove Job " + job.getId() + " from " + sh.getName() + ", job not found in slaveJobList"));
                            }
                        } else {
                            this.getLog().error((Object)("Cannot remove Job " + job.getId() + " from " + sh.getName() + ", no slaveJobList"));
                        }
                    }
                }
            }
            if (this.jobSlavelist.remove(job) == null) {
                this.getLog().error((Object)("RunQueue.remove: Cannot remove job " + job.getId() + " from jobSlavelist"));
            }
        }
        List<SlaveHandler> jsh = null;
        try {
            jsh = job.getSlaves();
        }
        catch (CfgException e) {
            this.dispatcher.stopJob(job, (Exception)((Object)e));
            jsh = null;
        }
        if (jsh != null) {
            for (SlaveHandler sh : jsh) {
                sh.delQueuedJob(job.getId());
            }
        }
        this.getLog().debug((Object)"end: ");
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getStatus(boolean verbose) {
        StringBuffer buf = new StringBuffer();
        try {
            Iterator jobs = null;
            IExecutable job2 = null;
            buf.append("Jobs: ");
            buf.append(this.jobSlavelist.size());
            Enumeration<SlaveHandler> sh = this.slaveJoblist.keys();
            while (sh.hasMoreElements()) {
                SlaveHandler slave;
                SlaveHandler slaveHandler = slave = sh.nextElement();
                synchronized (slaveHandler) {
                    buf.append("\n    Slave name: ");
                    buf.append(slave.getSlave().getName());
                    buf.append(", size: ");
                    buf.append(this.slaveJoblist.get(slave).size());
                    buf.append(" jobs");
                    if (verbose && this.slaveJoblist.get(slave).size() != 0) {
                        buf.append(String.format("\n    %10s | %32s | %32s | %4s", "Job ID", "Job name", "Step name", "Prio"));
                        buf.append(String.format("\n----%10.10s-+-%32.32s-+-%32.32s-+-%4.4s", "--------------------------------", "--------------------------------", "--------------------------------", "--------------------------------"));
                        for (IExecutable job2 : this.slaveJoblist.get(slave)) {
                            buf.append(String.format("\n    %10s | %32s | %32s | %4s", job2.getId(), job2.getName(), job2.getCurrentStepName(), job2.getPrio()));
                        }
                    }
                }
            }
            return buf.toString();
        }
        catch (Throwable e) {
            log.info((Object)"getStatus", e);
        }
        return buf.toString();
    }

    public Log getLog() {
        return log;
    }
}

