/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.SortedJobStepId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

class StepSeq {
    private Log log;
    private String name;
    private JobQueue queue;
    private Set<IJobStep> waiting = Collections.synchronizedSet(new HashSet());
    private SortedSet<SortedJobStepId> steps = Collections.synchronizedSortedSet(new TreeSet());
    private Object runSync = new Object();
    private IJobStep running = null;
    private boolean run;

    public StepSeq(String name, JobQueue queue, Log log, boolean started) {
        this.run = started;
        this.name = name;
        this.queue = queue;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.run = true;
        Object object = this.runSync;
        synchronized (object) {
            this.nextRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.runSync;
        synchronized (object) {
            this.run = false;
            this.waiting.clear();
            this.steps.clear();
        }
    }

    public String getStatus(String indent, boolean verbose) {
        StringBuffer buf = new StringBuffer();
        IJobStep step = null;
        Iterator sSteps = null;
        buf.append("\n");
        buf.append(indent);
        buf.append(this.getName());
        buf.append(": ");
        buf.append(this.steps.size());
        buf.append(", ");
        buf.append(this.waiting.size());
        buf.append(" waiting on ");
        if (this.steps.size() >= 1) {
            buf.append(this.steps.first().getStep().getJobId());
        }
        if (this.run) {
            buf.append(", running");
        } else {
            buf.append(", NOT RUNNING");
        }
        buf.append(", running job: ");
        if (this.running != null) {
            buf.append(this.running.getJobId());
            buf.append(".");
            buf.append(this.running.getStepNo());
        }
        buf.append("\n");
        if (this.waiting.size() > 0 && verbose) {
            TreeSet<SortedJobStepId> sortedWaiting = new TreeSet<SortedJobStepId>();
            Iterator<IJobStep> wSteps = this.waiting.iterator();
            while (wSteps.hasNext()) {
                sortedWaiting.add(new SortedJobStepId(wSteps.next()));
            }
            sSteps = sortedWaiting.iterator();
            buf.append(indent);
            buf.append("Waiting steps:");
            buf.append("\n");
            buf.append(indent);
            buf.append(String.format("%10s | %32s | %32s | %4s\n", "Job Id", "Job name", "Step name", "Prio"));
            while (sSteps.hasNext()) {
                step = ((SortedJobStepId)sSteps.next()).getStep();
                buf.append(indent);
                buf.append(String.format("%10s | %32s | %32s | %4d\n", step.getJobId(), step.getJobName(), step.getName(), step.getJob().getPrio()));
            }
        }
        if (this.steps.size() > 0 && verbose) {
            buf.append(indent);
            buf.append("Sorted steps:");
            buf.append(indent);
            buf.append("\n");
            buf.append(String.format("%10s | %32s | %32s | %4s\n", "Job Id", "Job name", "Step name", "Prio"));
            sSteps = this.steps.iterator();
            while (sSteps.hasNext()) {
                step = ((SortedJobStepId)sSteps.next()).getStep();
                buf.append(indent);
                buf.append(String.format("%10s | %32s | %32s | %4d\n", step.getJobId(), step.getJobName(), step.getName(), step.getJob().getPrio()));
            }
        }
        return buf.toString();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobStep(IJobStep step) {
        Object object = this.runSync;
        synchronized (object) {
            if (!this.steps.add(new SortedJobStepId(step))) {
                this.log.error((Object)("step " + step.getJobId() + "." + step.getStepNo() + " already in steplist " + this.name));
            }
            if (step.getJob().getStatus() == 5) {
                this.running = step;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobStep(IJobStep step) {
        Object object = this.runSync;
        synchronized (object) {
            SortedJobStepId first = this.steps.first();
            if (this.running == step) {
                this.running = null;
                if (first.getStep() != step) {
                    this.log.warn((Object)("step " + step.getJobId() + "." + step.getStepNo() + " remove: is running, but not the first in list!"));
                }
                if (!this.steps.remove(new SortedJobStepId(step))) {
                    this.log.error((Object)("step " + step.getJobId() + "." + step.getStepNo() + " can not remove from steplist"));
                }
                this.nextRun();
            } else {
                if (!this.steps.remove(new SortedJobStepId(step))) {
                    this.log.error((Object)("step " + step.getJobId() + "." + step.getStepNo() + " can not remove from steplist"));
                }
                this.waiting.remove((Object)step);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJs(IJobStep js) {
        Object object = this.runSync;
        synchronized (object) {
            if (this.running == js) {
                if (this.run) {
                    this.queue.runJob((IJob)js.getJob());
                }
            } else {
                if (!this.waiting.add(js)) {
                    this.log.error((Object)("step " + js.getJobId() + "." + js.getStepNo() + "is already in waiting list"));
                }
                this.nextRun();
            }
        }
    }

    private void nextRun() {
        if (this.run && this.running == null && this.steps.size() > 0) {
            SortedJobStepId first = this.steps.first();
            if (this.waiting.contains((Object)first.getStep())) {
                if (!this.waiting.remove((Object)first.getStep())) {
                    this.log.error((Object)("step " + first.getStep().getJobId() + "." + first.getStep().getStepNo() + " can not remove from waitlist"));
                }
                this.running = first.getStep();
                this.queue.runJob((IJob)this.running.getJob());
            } else {
                this.running = null;
            }
        }
    }
}

