/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.slave;

import de.axway.aim.controller.lib.Result;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.JslBuiltin;
import de.axway.aim.controller.master.RunJobException;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.UnexpectedRuntimeException;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuiltinSlaveHandler
extends SlaveHandler {
    private static Log log = LogFactory.getLog((String)"master.BuiltinSlaveHandler");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execBuiltin(JslBuiltin builtin) {
        Connection con = null;
        try {
            long start = System.currentTimeMillis();
            con = this.getConnection();
            builtin.exec(this.dispatcher, con);
            con.commit();
            WorkerThread.addDbTime(System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            log.error((Object)"exec builtin", (Throwable)e);
            Logbook.getLogbook().error("execute " + builtin.getId() + ": " + e);
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    protected void runJob(CtrlFunctionCall fc, Connection con) throws RunJobException {
        boolean ret = false;
        try {
            Result rs;
            try {
                fc.setRealFromBuiltin();
            }
            catch (CfgException e) {
                log.warn((Object)"can not set realfc", (Throwable)((Object)e));
            }
            fc.insert(con);
            con.commit();
            Logbook.getLogbook().executeJS(fc, this.slave);
            try {
                ret = fc.execBuiltin(this.getDispatcher(), con);
                rs = new Result(fc.getJobId(), fc.getStepNo(), fc.getStepRetry(), fc.getStepLevel(), fc.getSeqNo(), fc.getSeqRetry(), fc.getLevel(), 4, ret ? 0 : -1, null, this.slave.getHostname());
            }
            catch (Exception e) {
                Logbook.getLogbook().error("execute " + fc.getJobId() + ": " + e);
                log.error((Object)"exec builtin", (Throwable)e);
                rs = new Result(fc.getJobId(), fc.getStepNo(), fc.getStepRetry(), fc.getStepLevel(), fc.getSeqNo(), fc.getSeqRetry(), fc.getLevel(), 4, -1, null, this.slave.getHostname());
            }
            if (!this.getDispatcher().setResult(rs, con)) {
                con.commit();
            }
        }
        catch (SQLException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, ret);
        }
        catch (InterruptedException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, ret);
        }
        catch (LockException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, ret);
        }
        catch (UnexpectedRuntimeException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, ret);
        }
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public SlaveHandler.FcStat checkFc(CtrlFunctionCall fc) {
        return SlaveHandler.FcStat.ZOMBIE;
    }

    @Override
    public SlaveHandler.FcStat killFc(CtrlFunctionCall fc) {
        return SlaveHandler.FcStat.WAIT4RESULT;
    }

    @Override
    public int[] rmFiles(String[] fileNames) {
        int[] rcs = null;
        if (fileNames != null) {
            rcs = new int[fileNames.length];
            for (int i = 0; i < rcs.length; ++i) {
                rcs[i] = -1;
            }
            return rcs;
        }
        return null;
    }
}

