/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.slave;

import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.JobStep;
import de.axway.aim.controller.lib.Result;
import de.axway.aim.controller.lib.Slave;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.Globals;
import de.axway.aim.controller.master.RunJobException;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.UnexpectedRuntimeException;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.command.Cmd;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.jeif.LittleJOE;
import de.axway.lib.logprot.LogProtSendPort;
import de.axway.lib.logprot.LogProtVersion;
import de.axway.lib.message.Message;
import de.axway.lib.message.MessageController;
import de.axway.lib.message.MessageEncodingException;
import de.axway.lib.message.Port;
import de.axway.lib.util.ActisFile;
import de.axway.lib.util.StringOp;
import de.axway.lockDaemon.LockException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogprotSlaveHandler
extends SlaveHandler
implements MessageController {
    private static Log log = LogFactory.getLog((String)"master.LogprotSlaveHandler");

    @Override
    protected void runJob(CtrlFunctionCall fc, Connection con) throws RunJobException {
        boolean realFcExecuted = false;
        try {
            realFcExecuted = this.sendFc(fc);
            if (!realFcExecuted) {
                fc.insert(con);
                Result rs = new Result(fc.getJobId(), fc.getStepNo(), fc.getStepRetry(), 0, fc.getSeqNo(), fc.getSeqRetry(), fc.getLevel(), fc.getRcType(), fc.getRc(), null, null);
                if (!this.getDispatcher().setResult(rs, con)) {
                    con.commit();
                }
            } else {
                long start = System.currentTimeMillis();
                fc.insert(con);
                con.commit();
                WorkerThread.addDbTime(System.currentTimeMillis() - start);
            }
        }
        catch (SQLException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, realFcExecuted);
        }
        catch (InterruptedException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, realFcExecuted);
        }
        catch (LockException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, realFcExecuted);
        }
        catch (UnexpectedRuntimeException ex) {
            throw new RunJobException("Failed to run job " + fc.getJobId() + ".", ex, realFcExecuted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ping() {
        LogProtVersion lpVersion = new LogProtVersion(Globals.getLogProtVersion());
        try (Socket line = this.slave.connect(this.getEdiboss());){
            boolean bl;
            LogProtSendPort lpsp = new LogProtSendPort("TestLPSP", (MessageController)this, lpVersion, line.getInputStream(), line.getOutputStream(), line);
            lpsp.startPort();
            try {
                Message pingAnswer = lpsp.send(new Message("Ping"));
                if (pingAnswer == null) {
                    throw new IOException("answer is null");
                }
                bl = (Integer)pingAnswer.get("answer") == 0;
            }
            catch (MessageEncodingException e) {
                this.logError("ping failed: " + (Object)((Object)e));
                boolean bl2 = false;
                lpsp.stopPort();
                line.close();
                return bl2;
                {
                    catch (Throwable throwable) {
                        lpsp.stopPort();
                        throw throwable;
                    }
                }
            }
            lpsp.stopPort();
            return bl;
        }
        catch (Throwable e) {
            this.logError("ping failed: " + e);
            return false;
        }
    }

    @Override
    public SlaveHandler.FcStat checkFc(CtrlFunctionCall fc) {
        String[] args = new String[]{fc.getInstanceName()};
        try {
            CmdAnswer cAnswer = this.sendCmp(55, Cmd.getName(55), 0, Globals.getTxtEdiman(), Globals.getMasterUser(), args);
            String[] anyData = cAnswer.getAnyData();
            if (anyData != null && anyData.length > 0) {
                switch (Integer.parseInt(anyData[0])) {
                    case 2: {
                        return SlaveHandler.FcStat.WAIT4RESULT;
                    }
                    case 128: {
                        return SlaveHandler.FcStat.EMERGENCY;
                    }
                    case 256: {
                        return SlaveHandler.FcStat.ZOMBIE;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"CHECK_FCALL failed: ", (Throwable)e);
        }
        return SlaveHandler.FcStat.WAIT4RESULT;
    }

    @Override
    public SlaveHandler.FcStat killFc(CtrlFunctionCall fc) {
        String[] args = new String[]{fc.getInstanceName() + ":0"};
        try {
            CmdAnswer cAnswer = this.sendCmp(54, Cmd.getName(54), 0, Globals.getTxtEdiman(), Globals.getMasterUser(), args);
            String[] anyData = cAnswer.getAnyData();
            if (anyData != null && anyData.length > 0) {
                switch (Integer.parseInt(anyData[0])) {
                    case 2048: {
                        return SlaveHandler.FcStat.KILLED;
                    }
                }
                return SlaveHandler.FcStat.WAIT4RESULT;
            }
        }
        catch (Exception e) {
            log.error((Object)"KILL_PROCESS failed: ", (Throwable)e);
        }
        return SlaveHandler.FcStat.WAIT4RESULT;
    }

    @Override
    public int[] rmFiles(String[] fileNames) {
        int i;
        int[] rcs = new int[fileNames.length];
        if (log.isDebugEnabled()) {
            log.debug((Object)("rmFiles start: " + (fileNames == null ? 0 : fileNames.length) + " files to delete."));
            for (i = 0; fileNames != null && i < fileNames.length; ++i) {
                log.debug((Object)("   file[" + i + "] = '" + fileNames[i] + "'"));
            }
        }
        if (fileNames == null) {
            return null;
        }
        if (fileNames.length == 0) {
            return new int[0];
        }
        try {
            CmdAnswer cAnswer = this.sendCmp(56, Cmd.getName(56), 0, Globals.getTxtEdiman(), Globals.getMasterUser(), fileNames);
            String[] anyData = cAnswer.getAnyData();
            if (anyData != null && anyData.length > 0) {
                rcs = new int[anyData.length];
                for (i = 0; i < rcs.length; ++i) {
                    rcs[i] = Integer.valueOf(anyData[i]);
                }
            } else {
                log.error((Object)"Number of return codes does not match number of files!");
                if (anyData == null) {
                    log.error((Object)"Number of RCs: null!");
                } else {
                    log.error((Object)("Number of RCs: " + anyData.length));
                }
                rcs = new int[]{};
            }
        }
        catch (Exception e) {
            log.error((Object)"RM_FILE failed: ", (Throwable)e);
        }
        return rcs;
    }

    public CmdAnswer sendCmp(int cmdCode, String cmdName, int cmdNo, String initiator, String user, String[] args) throws IOException, MessageEncodingException, InterruptedException {
        Socket line = null;
        Message cmp = null;
        Message cmpAnswer = null;
        LogProtVersion lpVersion = new LogProtVersion(Globals.getLogProtVersion());
        LogProtSendPort lpsp = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendCmp start: " + cmdCode + "/" + cmdName));
            log.debug((Object)("        cmdNo: " + cmdNo + ", initiator/user: " + initiator + "/" + user));
            log.trace((Object)("        args : " + StringOp.arrayToString((Object[])args)));
        }
        Logbook.getLogbook().command(initiator, cmdNo, user, this.slave.getHostname(), cmdName, args);
        try {
            line = this.slave.connect(this.getEdiboss());
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendCmp connect: " + line.getRemoteSocketAddress() + ", local port: " + line.getLocalPort()));
            }
            lpsp = new LogProtSendPort("TestLPSP", (MessageController)this, lpVersion, line.getInputStream(), line.getOutputStream(), line);
            lpsp.startPort();
            cmp = new Message("SendCommand");
            cmp.set("cmdType", (Object)cmdCode);
            cmp.set("currUbtnr", (Object)cmdNo);
            cmp.set("cmdName", (Object)cmdName);
            cmp.set("initiator", (Object)initiator);
            cmp.set("ediUser", (Object)user);
            if (args != null && args.length != 0) {
                cmp.set("args", (Object)args);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("CMP: " + cmp));
            }
            cmpAnswer = lpsp.send(cmp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("cmpAnswer: " + cmpAnswer));
            }
        }
        catch (InterruptedException ie) {
            log.error((Object)("sendCmp terminates: " + cmdCode + "/" + cmdName), (Throwable)ie);
            throw ie;
        }
        catch (MessageEncodingException mee) {
            log.error((Object)("sendCmp terminates: " + cmdCode + "/" + cmdName), (Throwable)mee);
            throw mee;
        }
        catch (IOException ioe) {
            log.error((Object)("sendCmp terminates: " + cmdCode + "/" + cmdName), (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (lpsp != null) {
                lpsp.stopPort();
            } else if (line != null) {
                try {
                    line.close();
                }
                catch (Exception ignore) {
                    log.error((Object)("sendCmp close line failed: " + ignore), (Throwable)ignore);
                }
                line = null;
            }
        }
        if (cmpAnswer == null) {
            log.error((Object)"sendCmp end false (cmpAnswer is null)");
            throw new IOException("sendCmp end false (cmpAnswer is null)");
        }
        int answerCode = (Integer)cmpAnswer.get("answer");
        String[] anyData = (String[])cmpAnswer.get("anyData");
        String[] logData = new String[]{};
        Logbook.getLogbook().answInfo("CMP", true, this.slave, answerCode, 0L, "Command: " + cmdName + "|Sender: " + Globals.getTxtSlave());
        switch (cmdCode) {
            case 54: 
            case 55: {
                if (cmdCode == 55) {
                    log.debug((Object)"sendCmp: create CHECK_FCALL logData");
                } else if (cmdCode == 54) {
                    log.debug((Object)"sendCmp: create KILL_PROCESS logData");
                }
                if (anyData == null || answerCode != 0) break;
                logData = new String[anyData.length];
                for (int i = 0; i < anyData.length && i < args.length; ++i) {
                    if (anyData[i] != null) {
                        try {
                            int idx = args[i].indexOf(58);
                            String fcNameWoPid = idx == -1 ? args[i] : args[i].substring(0, idx);
                            logData[i] = fcNameWoPid + ":" + JobStep.stat2Str((int)Integer.parseInt(anyData[i]));
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("sendCmp: data/logData = " + anyData[i] + "/" + JobStep.stat2Str((int)Integer.parseInt(anyData[i]))));
                        }
                        catch (NumberFormatException nfe) {
                            logData[i] = anyData[i];
                        }
                        continue;
                    }
                    logData[i] = "";
                }
                break;
            }
            default: {
                if (anyData == null || answerCode != 0) break;
                logData = anyData;
            }
        }
        Logbook.getLogbook().commandEnd(initiator, ((Integer)cmpAnswer.get("currUbtnr")).intValue(), user, this.slave.getHostname(), cmdName, logData);
        return new CmdAnswer(answerCode, ((Integer)cmpAnswer.get("currUbtnr")).intValue(), (Integer)cmpAnswer.get("noOfEntries"), (Integer)cmpAnswer.get("typeOfAnyData"), anyData, logData);
    }

    private long alert(long start, String label) {
        long now = System.currentTimeMillis();
        if (now - start > 10000L) {
            log.error((Object)("ALERT: " + label + " " + (now - start) / 1000L + "s"));
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFc(CtrlFunctionCall fc) {
        Socket line = null;
        Message fcp = null;
        Message fcAnswer = null;
        LogProtSendPort lpsp = null;
        LogProtVersion lpVersion = new LogProtVersion(Globals.getLogProtVersion());
        int rc = -1;
        long start = System.currentTimeMillis();
        try {
            fcp = this.getLogProtFC(fc);
            long startTcp = System.currentTimeMillis();
            try {
                line = this.slave.connect(this.getEdiboss());
            }
            catch (IOException e) {
                this.logError("connect: " + e);
                throw e;
            }
            start = this.alert(start, " time to connect to slave " + this.slave.getName() + " is: ");
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendFc connect: " + line.getRemoteSocketAddress() + ", local port: " + line.getLocalPort()));
            }
            lpsp = new LogProtSendPort("TestLPSP", (MessageController)this, lpVersion, line.getInputStream(), line.getOutputStream(), line);
            lpsp.startPort();
            start = this.alert(start, "init logprot");
            if (log.isDebugEnabled()) {
                log.debug((Object)("build FCP message from " + (Object)((Object)fc)));
                log.debug((Object)("FCP: " + fcp));
            }
            start = System.currentTimeMillis();
            fcAnswer = lpsp.send(fcp);
            WorkerThread.addTcpTime(System.currentTimeMillis() - startTcp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("fcAnswer: " + fcAnswer));
            }
        }
        catch (Exception e) {
            log.error((Object)("sendFc terminates: Job ID: " + fc.getJobId() + ", Slave: " + this.slave), (Throwable)e);
            if (e instanceof MessageEncodingException) {
                rc = e.toString().contains("Timeout") ? -10 : -2;
                fc.setRcType(1);
            } else if (e instanceof SocketTimeoutException) {
                rc = -10;
                fc.setRcType(1);
            } else if (e instanceof ConnectException) {
                rc = -1;
                fc.setRcType(1);
            } else {
                rc = -2;
                fc.setRcType(1);
            }
            fc.setRc(rc);
            fc.setReal(fc.getCmd());
            Logbook.getLogbook().executeJS(fc, this.slave);
            this.dispatcher.sentinelFcStartMsg(fc);
            Logbook.getLogbook().sendLog("FCP", this.slave, rc, fc.getJobId(), fc.getInstanceName() + "|" + e.toString() + "|");
            boolean bl = false;
            return bl;
        }
        finally {
            if (lpsp != null) {
                lpsp.stopPort();
            } else if (line != null) {
                block31: {
                    try {
                        line.close();
                    }
                    catch (Exception ignore) {
                        if (!log.isDebugEnabled()) break block31;
                        log.debug((Object)("sendFc close line failed: " + ignore));
                    }
                }
                line = null;
            }
        }
        if (fcAnswer == null) {
            log.error((Object)"sendFc end false (fcAnswer is null)");
            fc.setRc(-2);
            fc.setRcType(1);
            fc.setReal(fc.getCmd());
            Logbook.getLogbook().executeJS(fc, this.slave);
            this.dispatcher.sentinelFcStartMsg(fc);
            return false;
        }
        String[] realFc = (String[])fcAnswer.get("realFunctionCall");
        rc = (Integer)fcAnswer.get("answer");
        if (realFc != null && realFc.length > 0) {
            fc.setReal(realFc);
        } else {
            fc.setReal(fc.getCmd());
        }
        fc.setRc(rc);
        fc.setRcType(2);
        Logbook.getLogbook().executeJS(fc, this.slave);
        this.dispatcher.sentinelFcStartMsg(fc);
        if (rc != 0) {
            Logbook.getLogbook().answError("FCP", true, this.slave, rc, fc.getJobId(), fc.getInstanceName() + "|");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendFc end answer: " + rc + ", fc.real: " + fc.getReal()));
        }
        return rc == 0;
    }

    public Message getLogProtFC(CtrlFunctionCall cfc) throws SQLException {
        Message fc = new Message("FCP");
        Message ediObj = null;
        fc.set("maxSlaveLoad", (Object)0);
        fc.set("nicePrio", (Object)0);
        fc.set("createsResult", (Object)0);
        String initiatorBuf = cfc.getJobId() + "." + cfc.getStepNo() + "." + cfc.getRetryNo() + "." + cfc.getSeqNo() + "." + cfc.getSeqRetry() + "." + cfc.getLevel();
        if (initiatorBuf.length() > 16) {
            initiatorBuf = initiatorBuf.substring(0, 16);
        }
        fc.set("initiator", (Object)initiatorBuf);
        fc.set("jobId", (Object)((int)cfc.getJobId()));
        fc.set("jsSequenceNo", (Object)cfc.getStepNo());
        fc.set("jsCurrRetry", (Object)cfc.getRetryNo());
        fc.set("jsExceptLevel", (Object)cfc.getStepLevel());
        fc.set("fcSequenceNo", (Object)cfc.getSeqNo());
        fc.set("fcCurrRetry", (Object)cfc.getSeqRetry());
        fc.set("fctnCallLevel", (Object)cfc.getLevel());
        if (cfc.getCmd() == null || cfc.getCmd().size() == 0) {
            fc.set("functionCall", (Object)new String[0]);
        } else {
            fc.set("functionCall", (Object)cfc.getCmdArr());
        }
        ediObj = this.getEdiObject(cfc);
        if (ediObj == null) {
            fc.set("noOfObjects", (Object)0);
        } else {
            fc.set("noOfObjects", (Object)1);
            fc.set("ediObjects", (Object)ediObj);
        }
        return fc;
    }

    protected Message getEdiObject(CtrlFunctionCall cfc) throws SQLException {
        Message ediObj = new Message("EdiObject");
        ArrayList<Message> compList = new ArrayList<Message>();
        Message compMessage = null;
        CtrlJob job = (CtrlJob)cfc.getJob();
        Slave compSlave = job.getCompSlave();
        Iterator<EdiComp> compIt = null;
        EdiComp comp2 = null;
        if (job != null && job.getCompSize() != 0) {
            if (compSlave == null) {
                ediObj.set("slaveHost", (Object)"localhost");
                ediObj.set("slavePort", (Object)9125);
                ediObj.set("slaveName", (Object)"edislave");
            } else {
                ediObj.set("slaveHost", (Object)compSlave.getHostname());
                ediObj.set("slavePort", (Object)compSlave.getPort());
                ediObj.set("slaveName", (Object)compSlave.getName());
            }
            for (EdiComp comp2 : job.getComps()) {
                compMessage = new Message("Component");
                compMessage.set("name", (Object)comp2.getName());
                compMessage.set("path", (Object)comp2.getFileName());
                compMessage.set("size", (Object)((int)comp2.getSize()));
                compMessage.set("creationDate", (Object)new Date((long)comp2.getCreationDate() / 1000L));
                compMessage.set("modificationDate", (Object)new Date((long)comp2.getModificationDate() / 1000L));
                compMessage.set("compNumber", (Object)comp2.getNum());
                compList.add(compMessage);
            }
            ediObj.set("components", (Object)compList.toArray(new Message[compList.size()]));
        }
        return ediObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getRemoteFile(String filename) throws Exception {
        File file = null;
        LittleJOE ljoe = null;
        String tmpFileName = null;
        LogProtVersion lpVersion = new LogProtVersion(Globals.getLogProtVersion());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start: " + filename));
        }
        try {
            ljoe = new LittleJOE(this.slave.getHostname(), this.slave.getPort(), lpVersion.EDImanVersion);
            LogprotSlaveHandler logprotSlaveHandler = this;
            synchronized (logprotSlaveHandler) {
                do {
                    Thread.sleep(1L);
                } while ((file = new File(tmpFileName = new ActisFile("tmp/shtmp." + this.slave.getHostname() + "." + System.currentTimeMillis()).toString())).exists());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting data from " + this.slave + ", remote file: " + filename + ", local file: " + file));
            }
            ljoe.get(file.toString(), filename, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("File " + file + " received."));
            }
        }
        catch (Exception e) {
            Logbook.getLogbook().error("Receiving file " + filename + " from " + this.slave + " to local file " + file + " failed");
            log.error((Object)("Receiving file " + filename + " from " + this.slave + " to local file " + file + " failed"));
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: file: " + file));
        }
        return file;
    }

    public Message inject(Message message, Port port) {
        return null;
    }

    public void registerPort(Port port) {
    }

    public void deregisterPort(Port port) {
    }

    public Port getPort(String portName) {
        return null;
    }

    public String toString() {
        return "LogprotSlaveHandler: " + this.slave.getHostname() + "/" + this.slave.getPort();
    }
}

