/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.AbstractRangeNode;
import de.axway.aim.controller.master.tcontrol.CompareUtil;
import de.axway.aim.controller.master.tcontrol.RangeState;
import de.axway.aim.controller.master.tcontrol.Relation;
import de.axway.aim.controller.master.tcontrol.TControlError;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractRangeTree<GComparableRange extends Comparable<GComparableRange>, GRangeTree extends AbstractRangeTree<GComparableRange, GRangeTree, GChildRangeNode>, GChildRangeNode extends AbstractRangeNode<GComparableRange, GChildRangeNode>>
extends AbstractRangeNode<GComparableRange, GRangeTree> {
    private TreeSet<GChildRangeNode> treeData = new TreeSet();
    private CompareUtil<GChildRangeNode, GComparableRange> dateCompareUtil = new CompareUtil();

    public void merge(GChildRangeNode dateRangeNode) {
        TreeSet mergedTreeData = new TreeSet();
        Object dateRangeNode2 = dateRangeNode;
        block11: for (AbstractRangeNode dateRangeNode1 : this.treeData) {
            if (dateRangeNode2 == null) {
                mergedTreeData.add(dateRangeNode1);
                continue;
            }
            Relation relation = this.dateCompareUtil.relation(dateRangeNode1, dateRangeNode2);
            if (relation.equals((Object)Relation.RANGE1_AFTER_RANGE2) || relation.equals((Object)Relation.RANGE1_FOLLOWS_RANGE2)) {
                mergedTreeData.add(dateRangeNode2);
                dateRangeNode2 = null;
                mergedTreeData.add(dateRangeNode1);
                continue;
            }
            if (relation.equals((Object)Relation.RANGE2_AFTER_RANGE1) || relation.equals((Object)Relation.RANGE2_FOLLOWS_RANGE1)) {
                mergedTreeData.add(dateRangeNode1);
                continue;
            }
            GChildRangeNode intersectionDateRangeNode = dateRangeNode1.intersectionMerge(relation, dateRangeNode2);
            switch (relation) {
                case EQUAL: {
                    mergedTreeData.add(intersectionDateRangeNode);
                    continue block11;
                }
                case RANGE1_ENDS_AFTER_RANGE2: {
                    Object from1 = ((AbstractRangeNode)dateRangeNode2).getTo();
                    dateRangeNode1.setFrom(from1);
                    mergedTreeData.add(intersectionDateRangeNode);
                    mergedTreeData.add(dateRangeNode1);
                    continue block11;
                }
                case RANGE1_STARTS_BEFORE_RANGE2: {
                    Object to1 = ((AbstractRangeNode)dateRangeNode2).getFrom();
                    dateRangeNode1.setTo(to1);
                    mergedTreeData.add(dateRangeNode1);
                    mergedTreeData.add(intersectionDateRangeNode);
                    continue block11;
                }
                case RANGE2_IN_RANGE1: {
                    Object dateRangeNodeAfterIntersection = dateRangeNode1.cloneNode();
                    ((AbstractRangeNode)dateRangeNodeAfterIntersection).setFrom(((AbstractRangeNode)dateRangeNode2).getTo());
                    Object to1 = ((AbstractRangeNode)dateRangeNode2).getFrom();
                    dateRangeNode1.setTo(to1);
                    mergedTreeData.add(dateRangeNode1);
                    mergedTreeData.add(intersectionDateRangeNode);
                    mergedTreeData.add(dateRangeNodeAfterIntersection);
                    dateRangeNode2 = null;
                    continue block11;
                }
                case RANGE1_IN_RANGE2: {
                    Object dateRangeNodeAfterIntersection = ((AbstractRangeNode)dateRangeNode2).cloneNode();
                    ((AbstractRangeNode)dateRangeNodeAfterIntersection).setFrom(dateRangeNode1.getTo());
                    Object to2 = dateRangeNode1.getFrom();
                    ((AbstractRangeNode)dateRangeNode2).setTo(to2);
                    mergedTreeData.add(((AbstractRangeNode)dateRangeNode2).cloneNode());
                    mergedTreeData.add(intersectionDateRangeNode);
                    dateRangeNode2 = dateRangeNodeAfterIntersection;
                    continue block11;
                }
                case RANGE1_ENDS_BEFORE_RANGE2: {
                    Object from2 = dateRangeNode1.getTo();
                    ((AbstractRangeNode)dateRangeNode2).setFrom(from2);
                    mergedTreeData.add(intersectionDateRangeNode);
                    continue block11;
                }
                case RANGE1_STARTS_AFTER_RANGE2: {
                    Object to2 = dateRangeNode1.getFrom();
                    ((AbstractRangeNode)dateRangeNode2).setTo(to2);
                    mergedTreeData.add(((AbstractRangeNode)dateRangeNode2).cloneNode());
                    mergedTreeData.add(intersectionDateRangeNode);
                    continue block11;
                }
                case RANGE2_ENDS_IN_RANGE1: {
                    Object to2 = dateRangeNode1.getFrom();
                    Object from1 = ((AbstractRangeNode)dateRangeNode2).getTo();
                    ((AbstractRangeNode)dateRangeNode2).setTo(to2);
                    dateRangeNode1.setFrom(from1);
                    mergedTreeData.add(((AbstractRangeNode)dateRangeNode2).cloneNode());
                    mergedTreeData.add(intersectionDateRangeNode);
                    mergedTreeData.add(dateRangeNode1);
                    continue block11;
                }
                case RANGE1_ENDS_IN_RANGE2: {
                    Object to1 = ((AbstractRangeNode)dateRangeNode2).getFrom();
                    Object from2 = dateRangeNode1.getTo();
                    dateRangeNode1.setTo(to1);
                    ((AbstractRangeNode)dateRangeNode2).setFrom(from2);
                    mergedTreeData.add(dateRangeNode1);
                    mergedTreeData.add(intersectionDateRangeNode);
                    continue block11;
                }
            }
            throw new TControlError("fatal error");
        }
        if (dateRangeNode2 != null) {
            mergedTreeData.add(dateRangeNode2);
        }
        this.treeData = mergedTreeData;
    }

    public Set<GChildRangeNode> getTreeData() {
        return this.treeData;
    }

    @Override
    public RangeState getState() {
        RangeState s = super.getState();
        if (s.equals((Object)RangeState.ENABLED) && this.getTreeData().size() > 0) {
            return RangeState.NEUTRAL;
        }
        return s;
    }
}

