/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.builtin.Reconfig;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelect;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.tcontrol.DispatchTimeEventProcessor;
import de.axway.aim.controller.master.tcontrol.DstPeriode;
import de.axway.aim.controller.master.tcontrol.FixPeriode;
import de.axway.aim.controller.master.tcontrol.IDispatcher;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.ITimeEventProcessor;
import de.axway.aim.controller.master.tcontrol.ITimeable;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import de.axway.aim.controller.master.tcontrol.Scheduler;
import de.axway.aim.controller.master.tcontrol.TimeEventEntry;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CfgJSelectScheduler
extends Scheduler<TimeEventEntry>
implements ITimeEventProcessor {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.ENGLISH);
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.tcontrol.Timer");
    private ITimeEventProcessor timeEventProcessor;
    private static Long twcrc32 = null;

    public CfgJSelectScheduler(CfgJSelect jselect, IDispatcher dispatcher, Date calculationStart) throws IOException, CfgException {
        DstPeriode periodey;
        Date nextx;
        this.timeEventProcessor = new DispatchTimeEventProcessor(dispatcher);
        List<CfgJSelectEntry> cfgJSelectEntryList = jselect.getTimeEntries();
        Iterator<CfgJSelectEntry> cfgJSelectEntryIterator = cfgJSelectEntryList.iterator();
        int id = 0;
        CfgJob cfgJob = jselect.getCfgJob();
        Map<String, NormalizedTimewindow> normalizedTimewindowHash = jselect.getNormalizedTimewindow();
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            Set<Map.Entry<String, NormalizedTimewindow>> keys = normalizedTimewindowHash.entrySet();
            for (Map.Entry<String, NormalizedTimewindow> entry : keys) {
                String key = entry.getKey();
                NormalizedTimewindow nw = entry.getValue();
                sb.append("  Timewindow: " + key + "\n");
                sb.append(nw.toString() + "\n");
            }
            String twout = sb.toString();
            CRC32 crc32 = new CRC32();
            crc32.reset();
            crc32.update(twout.getBytes());
            long twcrc32new = crc32.getValue();
            if (twcrc32 == null) {
                sb.insert(0, "Timewindows: (initial read)\n");
            } else if (twcrc32 == twcrc32new) {
                sb.insert(0, "Timewindows: (unchanged since last reconfig)\n");
            } else {
                sb.insert(0, "Timewindows: (CHANGED SINCE LAST RECONFIG!!!)\n");
            }
            LOG.debug((Object)sb.toString());
            twcrc32 = twcrc32new;
        }
        CfgJSelectEntry entry = new CfgJSelectEntry(null, dispatcher.getEdiboss(), -1, null, null);
        entry.setBuiltin(new Reconfig());
        entry.setPrio(600);
        entry.setTimeEvent(true);
        entry.setAttr("periode=DST_SWITCH");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addHiddenBuiltin: " + (Object)((Object)entry)));
        }
        if ((nextx = (periodey = new DstPeriode()).calcNearestPeriode(calculationStart)) == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("No next DST switch found for " + DATE_FORMAT.format(calculationStart)));
            }
        } else {
            this.add(new TimeEventEntry(nextx, periodey, entry, new NormalizedTimewindow(""), id, entry.getAttr(), cfgJob, this));
            ++id;
        }
        while (cfgJSelectEntryIterator.hasNext()) {
            Date next;
            int periode;
            String tn;
            CfgJSelectEntry cfgJSelectEntry = cfgJSelectEntryIterator.next();
            CfgTimeWindowEntry cfgTimeWindowEntry = cfgJSelectEntry.getTimeWindow();
            NormalizedTimewindow normalizedTimewindow = null;
            if (cfgTimeWindowEntry != null && (normalizedTimewindow = normalizedTimewindowHash.get(tn = cfgTimeWindowEntry.getName().toUpperCase())) == null) {
                throw new CfgException("Unknown timewindow used in jselect entry '" + cfgJSelectEntry.getName() + "': " + tn);
            }
            if (normalizedTimewindow == null) {
                cfgJSelectEntry.getName();
                normalizedTimewindow = new NormalizedTimewindow("");
            }
            if ((periode = cfgJSelectEntry.getTPeriode()) == 0) {
                IPeriode periodex = null;
                next = normalizedTimewindow.getNearest(calculationStart, periodex);
                if (next != null) {
                    this.add(new TimeEventEntry(next, periodex, cfgJSelectEntry, normalizedTimewindow, id, cfgJSelectEntry.getAttr(), cfgJob, this));
                }
            } else {
                FixPeriode fixPeriode;
                try {
                    fixPeriode = new FixPeriode(normalizedTimewindow.getNearest(null, null), periode);
                }
                catch (Exception e1) {
                    throw new CfgException("Error on processing time window " + normalizedTimewindow.toString() + "  for j_select entry: " + cfgJSelectEntry.toString() + " with " + e1);
                }
                next = normalizedTimewindow.getNearest(calculationStart, fixPeriode);
                if (next != null) {
                    FixPeriode periodex;
                    try {
                        periodex = new FixPeriode(normalizedTimewindow.getNearest(null, null), cfgJSelectEntry.getTPeriode());
                    }
                    catch (Exception e1) {
                        throw new CfgException(e1);
                    }
                    this.add(new TimeEventEntry(next, periodex, cfgJSelectEntry, normalizedTimewindow, id, cfgJSelectEntry.getAttr(), cfgJob, this));
                }
            }
            ++id;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.getStatus(true));
        }
    }

    @Override
    public void process(Date now, TimeEventEntry timeEventEntry) {
        this.timeEventProcessor.process(now, timeEventEntry);
    }

    public void setTimeEventProcessor(ITimeEventProcessor paramTimeEventProcessor) {
        this.timeEventProcessor = paramTimeEventProcessor;
    }

    public ITimeEventProcessor getTimeEventProcessor() {
        return this.timeEventProcessor;
    }

    public final String getStatus(boolean isVerbose) {
        Date earliest = this.getEarliest();
        int nodeCount = this.treeSet.size();
        StringBuffer sb = new StringBuffer();
        sb.append("Timeevents:\n");
        sb.append("  next execution             : ");
        sb.append(DATE_FORMAT.format(earliest));
        sb.append("\n");
        sb.append("  appending time events count: ");
        sb.append(nodeCount);
        sb.append("\n");
        if (isVerbose) {
            Iterator treeSetIterator = this.treeSet.iterator();
            sb.append("  time events:\n");
            while (treeSetIterator.hasNext()) {
                ITimeable node = (ITimeable)treeSetIterator.next();
                sb.append("    ");
                sb.append(node.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

