/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.AbstractRangeTree;
import de.axway.aim.controller.master.tcontrol.FixPeriode;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import de.axway.aim.controller.master.tcontrol.RangeState;
import de.axway.aim.controller.master.tcontrol.WeekdayRangeNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;

public class DateRangeNode
extends AbstractRangeTree<Date, DateRangeNode, WeekdayRangeNode> {
    private NormalizedTimewindow normalizedTimewindow = null;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateRangeNode(Date from, Date to, RangeState state) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (from == null) {
            Date time;
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.clear();
                time = calendar.getTime();
            }
            this.setFrom(time);
        } else {
            this.setFrom(from);
        }
        this.setTo(to);
        this.setState(state);
    }

    public DateRangeNode(DateRangeNode dateRange) {
        this((Date)dateRange.getFrom(), (Date)dateRange.getTo(), dateRange.getState());
        this.normalizedTimewindow = dateRange.normalizedTimewindow;
    }

    public DateRangeNode(NormalizedTimewindow normalizedTimewindow2) {
        this(null, null, RangeState.INITIAL);
        this.normalizedTimewindow = normalizedTimewindow2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getState().equals((Object)RangeState.ENABLED)) {
            sb.append("+");
        } else if (this.getState().equals((Object)RangeState.DISABLED)) {
            sb.append("-");
        } else if (this.getState().equals((Object)RangeState.INITIAL)) {
            sb.append("I");
        } else {
            sb.append("?");
        }
        String fromString = this.getFrom() == null ? null : DATE_FORMAT.format((Date)this.getFrom());
        String toString = this.getTo() == null ? null : DATE_FORMAT.format((Date)this.getTo());
        sb.append("[" + fromString + ", " + toString + "), \n");
        for (WeekdayRangeNode weekdayData : this.getTreeData()) {
            sb.append("  " + weekdayData.toString());
        }
        return sb.toString();
    }

    @Override
    public void mergeContent(DateRangeNode newDateRangeNode) {
        if ((this.getState().equals((Object)RangeState.ENABLED) || this.getState().equals((Object)RangeState.INITIAL)) && newDateRangeNode.getTreeData().size() > 0) {
            this.setState(RangeState.NEUTRAL);
        }
        for (WeekdayRangeNode weekdayRangeNode : newDateRangeNode.getTreeData()) {
            this.merge(weekdayRangeNode.cloneNode());
        }
    }

    @Override
    public DateRangeNode cloneNode() {
        DateRangeNode dateRangeNode = new DateRangeNode(this);
        dateRangeNode.mergeContent(this);
        return dateRangeNode;
    }

    public Date maxValid(Date requestDate) {
        Date to = (Date)this.getTo();
        if (to.compareTo(requestDate) < 0) {
            return null;
        }
        return this.maxValid(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date nearestValid(IPeriode periode, Date requestDate, Date maxDate) {
        Date maxNearestValid;
        FixPeriode fixPeriode;
        Calendar calendar = GregorianCalendar.getInstance();
        if (this.getState().equals((Object)RangeState.INITIAL)) {
            Set treeData = this.normalizedTimewindow.getTreeData();
            for (DateRangeNode dateRangeNode : treeData) {
                if (!dateRangeNode.getState().equals((Object)RangeState.ENABLED) && !dateRangeNode.getState().equals((Object)RangeState.NEUTRAL)) continue;
                return null;
            }
        }
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            return null;
        }
        Date nearestValid = null;
        Date verifyDate = requestDate;
        if (periode != null && periode instanceof FixPeriode) {
            fixPeriode = (FixPeriode)periode;
            if (requestDate.compareTo((Date)this.getFrom()) < 0) {
                verifyDate = fixPeriode.calcNearestPeriode((Date)this.getFrom());
            }
        } else {
            fixPeriode = null;
            if (requestDate == null) {
                verifyDate = (Date)this.getFrom();
            } else if (requestDate.compareTo((Date)this.getFrom()) < 0) {
                verifyDate = (Date)this.getFrom();
            }
        }
        Date verifyFromTime = (Date)this.getFrom();
        Date verifyToTime = (Date)this.getTo();
        if (maxDate != null && (this.getTo() == null || maxDate.before((Date)this.getTo()))) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.setTime(maxDate);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                maxNearestValid = calendar.getTime();
            }
        } else {
            maxNearestValid = (Date)this.getTo();
        }
        if ((nearestValid = this.nearestValidLocal(periode, requestDate, maxNearestValid)) != null) {
            return nearestValid;
        }
        while (verifyDate == null || verifyDate.compareTo(maxNearestValid) == -1) {
            for (WeekdayRangeNode dateData : this.getTreeData()) {
                Date subNearestValid = dateData.nearestValid(periode, verifyDate, maxNearestValid);
                if (nearestValid != null && (subNearestValid == null || nearestValid.compareTo(subNearestValid) != 1)) continue;
                nearestValid = subNearestValid;
            }
            if (nearestValid == null) {
                return null;
            }
            verifyDate = nearestValid;
            int requestDateCompareToFromDate = nearestValid.compareTo(verifyFromTime);
            int requestDateCompareToToDate = nearestValid.compareTo(verifyToTime);
            if (requestDateCompareToFromDate > -1 && requestDateCompareToToDate < 0) {
                return nearestValid;
            }
            nearestValid = null;
            long lastTime = verifyDate.getTime();
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.setTime(verifyDate);
                calendar.add(5, 1);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                verifyDate = calendar.getTime();
                long newTime = verifyDate.getTime();
                if (fixPeriode == null) {
                    nearestValid = null;
                } else {
                    int periodeOffset = (int)((long)fixPeriode.getPeriode() - (newTime - lastTime) / 1000L % (long)fixPeriode.getPeriode());
                    calendar.add(13, periodeOffset);
                    verifyDate = calendar.getTime();
                }
            }
        }
        return nearestValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date nearestValidLocal(IPeriode periode, Date requestDate, Date maxDate) {
        Date cleanRequestDate;
        Calendar calendar = GregorianCalendar.getInstance();
        if (this.getState().equals((Object)RangeState.NEUTRAL)) {
            return null;
        }
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            if (requestDate == null) {
                calendar.clear();
            } else {
                calendar.setTime(requestDate);
            }
            cleanRequestDate = calendar.getTime();
        }
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            if (cleanRequestDate.before((Date)this.getFrom()) || this.getTo() != null && !cleanRequestDate.before((Date)this.getTo())) {
                return cleanRequestDate;
            }
            return (Date)this.getTo();
        }
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            return null;
        }
        if (requestDate == null) {
            return (Date)this.getFrom();
        }
        int requestDateCompareToFromDate = requestDate.compareTo((Date)this.getFrom());
        int requestDateCompareToToDate = this.getTo() == null ? -1 : requestDate.compareTo((Date)this.getTo());
        if (requestDateCompareToFromDate < 0) {
            return (Date)this.getFrom();
        }
        if (requestDateCompareToToDate < 0) {
            return requestDate;
        }
        return null;
    }

    @Override
    public void setTo(Date to) {
        super.setTo(this.getDate(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getDate(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (date == null) {
            return null;
        }
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
    }

    @Override
    public final void setFrom(Date from) {
        super.setFrom(this.getDate(from));
    }

    @Override
    public void setState(RangeState state) {
        super.setState(state);
        if (state.equals((Object)RangeState.DISABLED)) {
            this.getTreeData().clear();
        }
    }
}

