/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.IPeriode;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DstPeriode
implements IPeriode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getNextDstSwitch(Date startDate, Date endDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        long endDateMillis = endDate.getTime();
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTime(startDate);
            if (calendar.get(2) < 7) {
                calendar.set(2, 1);
            } else {
                calendar.set(2, 7);
            }
            long dateMillis = calendar.getTimeInMillis();
            int dateDstOffset = calendar.get(16);
            while (dateMillis < endDateMillis) {
                Date d;
                long lowerBound = dateMillis;
                int lowerDstOffset = dateDstOffset;
                calendar.setTimeInMillis(dateMillis);
                calendar.add(2, 6);
                dateMillis = calendar.getTimeInMillis();
                dateDstOffset = calendar.get(16);
                long upperBound = dateMillis;
                int upperDstOffset = dateDstOffset;
                if (lowerDstOffset == upperDstOffset || (d = this.getDstSwitchHelp(lowerBound, lowerDstOffset, upperBound)).before(startDate)) continue;
                return d;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getDstSwitchHelp(long plowerBound, int lowerDstOffset, long pupperBound) {
        int nextDstOffset;
        Calendar calendar = GregorianCalendar.getInstance();
        long lowerBound = plowerBound;
        long upperBound = pupperBound;
        long diffBounds = upperBound - lowerBound;
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            if (diffBounds < 2L) {
                calendar.setTimeInMillis(upperBound);
                return calendar.getTime();
            }
        }
        long nextBound = lowerBound + diffBounds / 2L;
        calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(nextBound);
            nextDstOffset = calendar.get(16);
        }
        if (nextDstOffset == lowerDstOffset) {
            lowerBound = nextBound;
        } else {
            upperBound = nextBound;
        }
        return this.getDstSwitchHelp(lowerBound, lowerDstOffset, upperBound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date calcNearestPeriode(Date requestDate) {
        Date endDate;
        Calendar calendar;
        Calendar calendar2 = calendar = GregorianCalendar.getInstance();
        synchronized (calendar2) {
            calendar.setTime(requestDate);
            calendar.add(1, 50);
            endDate = calendar.getTime();
        }
        Date startDate = new Date(requestDate.getTime() + 1000L);
        Date nextDstSwitchDate = this.getNextDstSwitch(startDate, endDate);
        if (nextDstSwitchDate == null) {
            return null;
        }
        return new Date(nextDstSwitchDate.getTime() - 1000L);
    }
}

