/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.AbstractRangeTree;
import de.axway.aim.controller.master.tcontrol.DateRangeNode;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.RangeState;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NormalizedTimewindow
extends AbstractRangeTree<Date, NormalizedTimewindow, DateRangeNode> {
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.tcontrol");
    private final String aName;

    public NormalizedTimewindow(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("create NormalizedTimewindow: " + name));
        }
        this.aName = name;
        this.merge(new DateRangeNode(this));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (DateRangeNode dateRangeNode : this.getTreeData()) {
            sb.append(dateRangeNode.toString());
        }
        return sb.toString();
    }

    @Override
    public NormalizedTimewindow cloneNode() {
        return null;
    }

    @Override
    public void mergeContent(NormalizedTimewindow newDateRangeNode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date nearestValid(IPeriode periode, Date requestDate, Date maxDate) {
        Date maxNearestValid;
        Date verifyDate;
        Calendar calendar;
        Calendar calendar2 = GregorianCalendar.getInstance();
        if (this.getTreeData().size() == 0) {
            if (requestDate == null) {
                Calendar calendar3 = calendar2;
                synchronized (calendar3) {
                    calendar2.clear();
                    return calendar2.getTime();
                }
            }
            return requestDate;
        }
        Date nearestValid = null;
        if (periode != null) {
            int reqMilli;
            calendar = calendar2;
            synchronized (calendar) {
                calendar2.setTime(requestDate);
                reqMilli = calendar2.get(14);
            }
            verifyDate = periode.calcNearestPeriode(requestDate);
            verifyDate = new Date(verifyDate.getTime() / 1000L * 1000L + (long)reqMilli);
        } else {
            verifyDate = requestDate;
        }
        if (maxDate != null && (this.getTo() == null || maxDate.before((Date)this.getTo()))) {
            calendar = calendar2;
            synchronized (calendar) {
                calendar2.setTime(maxDate);
                calendar2.set(10, 0);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
                calendar2.set(14, 0);
                maxNearestValid = calendar2.getTime();
            }
        } else {
            maxNearestValid = (Date)this.getTo();
        }
        if ((nearestValid = this.nearestValidLocal(periode, requestDate, maxDate)) != null) {
            return nearestValid;
        }
        for (DateRangeNode dateData : this.getTreeData()) {
            Date subNearestValid = dateData.nearestValid(periode, verifyDate, maxNearestValid);
            if (nearestValid != null && (subNearestValid == null || nearestValid.compareTo(subNearestValid) != 1)) continue;
            nearestValid = subNearestValid;
        }
        return nearestValid;
    }

    private Date nearestValidLocal(IPeriode periode, Date requestDate, Date maxDate) {
        if (!this.getState().equals((Object)RangeState.ENABLED) && !this.getState().equals((Object)RangeState.INITIAL)) {
            return null;
        }
        int requestDateCompareToFromDate = requestDate.compareTo((Date)this.getFrom());
        int requestDateCompareToToDate = requestDate.compareTo((Date)this.getTo());
        if (requestDateCompareToFromDate > -1 && requestDateCompareToToDate < 0) {
            return requestDate;
        }
        return null;
    }

    public Date getNearest(Date requestDate, IPeriode periode) {
        Date nearest;
        Date firstValid;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NormalizedTimewindow.getNearest: {name=" + this.aName + ", requestDate=" + requestDate + ", periode=" + periode + "}"));
        }
        if ((firstValid = this.nearestValid((IPeriode)null, (Date)null, (Date)null)) == null) {
            nearest = null;
        } else if (requestDate == null) {
            nearest = firstValid;
        } else {
            Date d = new Date(requestDate.getTime() / 1000L * 1000L);
            if (d.compareTo(firstValid) < 0) {
                nearest = firstValid;
            } else if (d.compareTo(firstValid) == 0) {
                nearest = requestDate;
            }
            Date verifyDate = periode != null ? periode.calcNearestPeriode(requestDate) : requestDate;
            nearest = this.nearestValid(periode, verifyDate, (Date)null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NormalizedTimewindow.getNearest result: {name=" + this.aName + ", requestDate=" + requestDate + ", periode=" + periode + "} - " + (nearest == null ? " nearest is null" : nearest.toString())));
        }
        return nearest;
    }
}

