/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.tcontrol.IDispatcher;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.ITimeEventProcessor;
import de.axway.aim.controller.master.tcontrol.ITimeable;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeEventEntry
implements Comparable<TimeEventEntry>,
ITimeable<TimeEventEntry> {
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.tcontrol.TimeEventEntry");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.ENGLISH);
    private final CfgJSelectEntry cfgJSelectEntry;
    private final int evtCfgId;
    private Date nextEarliest;
    private ITimeEventProcessor timeEventProcessor;
    private final CfgJob cfgJob;
    private NormalizedTimewindow normalizedTimewindow;
    private IPeriode periode;
    private String cfgIdString;

    public TimeEventEntry(Date next, IPeriode paramPeriode, CfgJSelectEntry paramCfgJSelectEntry, NormalizedTimewindow paramNormalizedTimewindow, int paramEvtCfgId, String paramCfgIdString, CfgJob paramCfgJob, ITimeEventProcessor paramTimeEventProcessor) {
        this.periode = paramPeriode;
        this.normalizedTimewindow = paramNormalizedTimewindow;
        this.nextEarliest = next;
        this.cfgJSelectEntry = paramCfgJSelectEntry;
        this.evtCfgId = paramEvtCfgId;
        this.cfgIdString = paramCfgIdString;
        this.cfgJob = paramCfgJob;
        this.timeEventProcessor = paramTimeEventProcessor;
    }

    public CfgJob getCfgJob() {
        return this.cfgJob;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeEventEntry) {
            return this.compareTo((TimeEventEntry)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.evtCfgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(TimeEventEntry timeEventEntry) {
        int c;
        TimeEventEntry timeEventEntry2 = this;
        synchronized (timeEventEntry2) {
            if (this.nextEarliest == null && timeEventEntry.nextEarliest == null) {
                return 0;
            }
            if (this.nextEarliest == null) {
                return -1;
            }
            if (timeEventEntry.nextEarliest == null) {
                return 1;
            }
            c = this.nextEarliest.compareTo(timeEventEntry.nextEarliest);
        }
        if (c == 0) {
            c = timeEventEntry.evtCfgId - this.evtCfgId;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(Date now) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("timeevent process: " + this.evtCfgId + " - " + now));
        }
        this.timeEventProcessor.process(now, this);
        if (this.periode != null) {
            Date cnNextDate = new Date(now.getTime() + 1000L);
            TimeEventEntry timeEventEntry = this;
            synchronized (timeEventEntry) {
                this.nextEarliest = this.getNext(cnNextDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("timeevent next earliest run: " + this.evtCfgId + " - " + this.nextEarliest));
                }
            }
        }
        TimeEventEntry timeEventEntry = this;
        synchronized (timeEventEntry) {
            this.nextEarliest = null;
        }
    }

    public int getId() {
        return this.evtCfgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getNext(Date now) {
        Date cnNextDate;
        TimeEventEntry timeEventEntry = this;
        synchronized (timeEventEntry) {
            cnNextDate = now == null ? this.nextEarliest : (this.nextEarliest == null ? now : (now.before(this.nextEarliest) ? this.nextEarliest : now));
        }
        Date next = this.normalizedTimewindow.getNearest(cnNextDate, this.periode);
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getEarliest() {
        TimeEventEntry timeEventEntry = this;
        synchronized (timeEventEntry) {
            return this.nextEarliest;
        }
    }

    public String toString() {
        return DATE_FORMAT.format(this.getEarliest()) + ": " + this.evtCfgId + " / " + this.cfgIdString;
    }

    public void createJob(IDispatcher dispatcher) {
        this.cfgJSelectEntry.createJob(dispatcher, this.cfgJob);
    }
}

