/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.AbstractRangeNode;
import de.axway.aim.controller.master.tcontrol.FixPeriode;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.RangeState;
import de.axway.aim.controller.master.tcontrol.WeekdayRangeNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;

public class TimeRangeNode
extends AbstractRangeNode<Date, TimeRangeNode> {
    private static final int RANGE_DAY = 86400;
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private WeekdayRangeNode weekdayRangeNode = null;

    public TimeRangeNode(Date from, Date to, RangeState state) {
        this.setFrom(from);
        this.setTo(to);
        this.setState(state);
    }

    public TimeRangeNode(WeekdayRangeNode weekdayRangeNode) {
        this(null, null, RangeState.INITIAL);
        this.weekdayRangeNode = weekdayRangeNode;
    }

    public String toString() {
        String stateString = this.getState().equals((Object)RangeState.ENABLED) ? "+" : (this.getState().equals((Object)RangeState.DISABLED) ? "-" : (this.getState().equals((Object)RangeState.INITIAL) ? "I" : "?"));
        stateString = stateString + "[" + TIME_FORMAT.format((Date)this.getFrom()) + ", " + TIME_FORMAT.format((Date)this.getTo()) + "), ";
        return stateString;
    }

    @Override
    public TimeRangeNode cloneNode() {
        TimeRangeNode rangeNode = new TimeRangeNode((Date)this.getFrom(), (Date)this.getTo(), this.getState());
        rangeNode.weekdayRangeNode = this.weekdayRangeNode;
        return rangeNode;
    }

    @Override
    public void mergeContent(TimeRangeNode newDateRangeNode) {
    }

    @Override
    public void setFrom(Date from) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (from == null) {
            calendar.clear();
            super.setFrom(calendar.getTime());
        } else {
            calendar.setTime(from);
            int hour = calendar.get(11);
            int min = calendar.get(12);
            int sec = calendar.get(13);
            calendar.clear();
            calendar.set(11, hour);
            calendar.set(12, min);
            calendar.set(13, sec);
            super.setFrom(calendar.getTime());
        }
    }

    @Override
    public void setTo(Date to) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (to == null) {
            calendar.clear();
            calendar.add(5, 1);
            super.setTo(calendar.getTime());
        } else {
            calendar.setTime(to);
            int hour = calendar.get(11);
            int min = calendar.get(12);
            int sec = calendar.get(13);
            calendar.clear();
            if (hour == 0 && min == 0 && sec == 0) {
                calendar.add(5, 1);
            } else {
                calendar.set(11, hour);
                calendar.set(12, min);
                calendar.set(13, sec);
            }
            super.setTo(calendar.getTime());
        }
    }

    public Date maxValid(Date requestDate) {
        Date to = (Date)this.getTo();
        if (to.compareTo(requestDate) < 0) {
            return null;
        }
        return to;
    }

    @Override
    public Date nearestValid(IPeriode periode, Date requestDate, Date maxDate) {
        Date verifyDate;
        Calendar calendar = GregorianCalendar.getInstance();
        if (this.getState().equals((Object)RangeState.INITIAL)) {
            Set treeData = this.weekdayRangeNode.getTreeData();
            for (TimeRangeNode dateRangeNode : treeData) {
                if (!dateRangeNode.getState().equals((Object)RangeState.ENABLED) && !dateRangeNode.getState().equals((Object)RangeState.NEUTRAL)) continue;
                return null;
            }
        }
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            return null;
        }
        if (requestDate == null) {
            return (Date)super.getFrom();
        }
        if (periode != null && periode instanceof FixPeriode) {
            calendar.setTime(requestDate);
            int reqMilli = calendar.get(14);
            FixPeriode fixPeriode = (FixPeriode)periode;
            verifyDate = fixPeriode.calcNearestPeriode(requestDate);
            calendar.setTime(verifyDate);
            calendar.set(14, reqMilli);
            verifyDate = calendar.getTime();
        } else {
            verifyDate = requestDate;
        }
        int modValue = 0;
        TreeSet<Integer> modValueTreeSet = new TreeSet<Integer>();
        while (verifyDate == null || verifyDate.compareTo(maxDate) == -1) {
            Date verifyFromTime = this.getFrom(verifyDate);
            Date verifyToTime = this.getTo(verifyDate);
            int requestDateCompareToFromDate = verifyDate.compareTo(verifyFromTime);
            int requestDateCompareToToDate = verifyDate.compareTo(verifyToTime);
            if (requestDateCompareToFromDate > -1 && requestDateCompareToToDate < 0) {
                return verifyDate;
            }
            if (periode != null && periode instanceof FixPeriode) {
                FixPeriode fixPeriode = (FixPeriode)periode;
                Date newVerifyDate = this.getFrom(verifyDate);
                calendar.setTime(newVerifyDate);
                if (newVerifyDate.compareTo(verifyDate) < 0) {
                    calendar.add(5, 1);
                }
                calendar.set(14, 0);
                verifyDate = fixPeriode.calcNearestPeriode(calendar.getTime());
                modValue = (modValue + fixPeriode.getPeriode()) % 86400;
            } else {
                Date newVerifyDate = this.getFrom(verifyDate);
                calendar.setTime(newVerifyDate);
                if (newVerifyDate.compareTo(verifyDate) < 0) {
                    calendar.add(5, 1);
                }
                calendar.set(14, 0);
                verifyDate = calendar.getTime();
                int hour = calendar.get(11);
                int min = calendar.get(12);
                int sec = calendar.get(13);
                modValue = ((hour * 60 + min) * 60 + sec) % 86400;
            }
            if (modValueTreeSet.contains(modValue)) {
                return null;
            }
            modValueTreeSet.add(modValue);
        }
        return null;
    }

    private Date getTo(Date time) {
        if (time == null) {
            return (Date)super.getTo();
        }
        Calendar calendar = GregorianCalendar.getInstance();
        Date rawTo = (Date)super.getTo();
        calendar.setTime(rawTo);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        calendar.setTime(time);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        Date newTo = calendar.getTime();
        if (newTo.compareTo(time) < 0 || hour == 0 && min == 0 && sec == 0) {
            calendar.add(5, 1);
            newTo = calendar.getTime();
        }
        return newTo;
    }

    private Date getFrom(Date time) {
        if (time == null) {
            return (Date)super.getFrom();
        }
        Calendar calendar = GregorianCalendar.getInstance();
        Date rawFrom = (Date)super.getFrom();
        calendar.setTime(rawFrom);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        calendar.setTime(this.getTo(time));
        calendar.add(13, -1);
        Date mergeTo = calendar.getTime();
        calendar.setTime(mergeTo);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        return calendar.getTime();
    }
}

