#ifndef NULL_PTR
#define NULL_PTR 0
#endif
#define OS_LINUX
#include "include/cryptoki_v2.h"
#include "include/RSA/pkcs11.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


void check_return_value(CK_RV rv, const char *message)
{
	if (rv != CKR_OK) {
		fprintf(stderr, "Error at %s: %u\n",
		message, (unsigned int)rv);
		exit(EXIT_FAILURE);
	}
}

CK_RV initialize()
{
	return C_Initialize(NULL);
}

CK_SLOT_ID get_slot()
{
	CK_RV rv;
	CK_SLOT_ID slotId;
	CK_ULONG slotCount = 10;
	CK_SLOT_ID *slotIds = malloc(sizeof(CK_SLOT_ID) * slotCount);
	rv = C_GetSlotList(CK_TRUE, slotIds, &slotCount);
	check_return_value(rv, "get slot list");
	if (slotCount < 1) {
		fprintf(stderr, "Error; could not find any slots\n");
		exit(1);
	}

	slotId = slotIds[0];
	free(slotIds);
	printf("\n Slot count: %d\n\n", (int)slotCount);
	return slotId;
}

CK_SESSION_HANDLE start_session(CK_SLOT_ID slotId)
{
	CK_RV rv;
	CK_SESSION_HANDLE session;
	rv = C_OpenSession(slotId,
		CKF_SERIAL_SESSION,
		NULL, 
		NULL,
		&session);
	check_return_value(rv, "open session");
	printf(" start session: rv is %d session handle is %x \n",rv,session);
	return session;
}


void login(CK_SESSION_HANDLE session, CK_BYTE *pin)
{
	CK_RV rv;
	if (pin) {
		rv = C_Login(session, CKU_USER, pin, strlen((char *)pin));
		check_return_value(rv, "log in");
		printf(" Tried logging in using %s rv = %d \n",pin,rv);
	}
}

void logout(CK_SESSION_HANDLE session)
{
	CK_RV rv;
	rv = C_Logout(session);
	if (rv != CKR_USER_NOT_LOGGED_IN) {
		check_return_value(rv, "log out");
	}
}

void end_session(CK_SESSION_HANDLE session)
{
	CK_RV rv;
	rv = C_CloseSession(session);
	check_return_value(rv, "close session");
	printf(" End session, rv = %d \n",rv);
}

void finalize()
{
	C_Finalize(NULL);
}

void show_key_info(CK_SESSION_HANDLE session, CK_OBJECT_HANDLE key, int label_bufSize,int id_bufSize)
{
 	int i;
	CK_RV rv;
	CK_UTF8CHAR *label = (CK_UTF8CHAR *) malloc(label_bufSize);
	// the id size has to be >= 20, or else a "BUFFER_TO_SMALL" error happens.
	CK_BYTE *id = (CK_BYTE *) malloc(id_bufSize);
	size_t label_len;
	char *label_str;
	memset(id, 0, id_bufSize);
	CK_ATTRIBUTE template[] = {
		{CKA_LABEL, label,label_bufSize},
		{CKA_ID, id,id_bufSize}
	};
	printf(" Calling getAttributeValue \n");
	rv = C_GetAttributeValue(session, key, template, 2);
	printf(" GetAttributeValue returned %d \n\n",rv);
	check_return_value(rv, "get attribute value");
	fprintf(stdout, " Found a key:\n");
	label_len = template[0].ulValueLen;

	if (label_len > 0) {
		label_str = malloc(label_len + 1);
		memcpy(label_str, label, label_len);
		label_str[label_len] = '\0';
		fprintf(stdout, "\tKey label: %s\n", label_str);
		free(label_str);
	} 
	else 
	{
		fprintf(stdout, "\tKey label too large, or not found\n");
	}
	if (template[1].ulValueLen > 0) {
        fprintf(stdout, "\tKey ID: ");
        for (i = 0; i < id_bufSize; i++)
        {
            if (0 == id[i])
                break;

//            fprintf(stdout, "%x", id[i]);
            fprintf(stdout, "%2.2x:", id[i]);
        }
	} 
	else 
	{
		fprintf(stdout, "\tKey id too large, or not found\n");
	}
        fprintf(stdout, "\n");
	free(label);
	free(id);
}

#define MAX_OBJECTS 4096;
read_all_public_keys(int session, int label_bufSize, int id_bufSize)
{
    CK_RV rv;
    CK_OBJECT_CLASS keyClass = CKO_PUBLIC_KEY;
    CK_ATTRIBUTE template[] = {
        { CKA_CLASS, &keyClass, sizeof(keyClass) }
    };
    CK_ULONG objectCount;
    CK_OBJECT_HANDLE object;
    int number_objects;

    rv = C_FindObjectsInit(session, template, 1);
    printf(" C_findObjectsInit return value is %d (0==success) \n", rv);
    check_return_value(rv, "Find objects init");

    rv = C_FindObjects(session, &object, 1, &objectCount);
    printf(" C_FindObjects returns %d objects, return value %d \n", objectCount, rv);
    check_return_value(rv, "Find first object");
    // in object count loop.
    while (objectCount > 0) {
        show_key_info(session, object, label_bufSize, id_bufSize);
        rv = C_FindObjects(session, &object, 1, &objectCount);
        check_return_value(rv, "Find other objects");
    }
    rv = C_FindObjectsFinal(session);
    check_return_value(rv, "Find objects final");
}

void read_private_keys(int session, int label_bufSize, int id_bufSize)
{
	CK_RV rv;
	CK_OBJECT_CLASS keyClass = CKO_PRIVATE_KEY;
	CK_ATTRIBUTE template[] = {
		{ CKA_CLASS, &keyClass, sizeof(keyClass) }
	};

	CK_ULONG objectCount,objectCount2;
	CK_OBJECT_HANDLE object;
	rv = C_FindObjectsInit(session, template, 1);
	printf(" C_findObjectsInit return value is %d (0==success) \n",rv);
	check_return_value(rv, "Find objects init");
	
	rv = C_FindObjects(session, &object, 1, &objectCount);
	printf(" C_FindObjects returns %d objects, return value %d \n",objectCount,rv);
	check_return_value(rv, "Find first object");
	objectCount2 = objectCount;
	// in object count loop.
	while (objectCount2 > 0) {
		show_key_info(session, object,label_bufSize,id_bufSize);
		rv = C_FindObjects(session, &object, 1, &objectCount2);
		check_return_value(rv, "Find other objects");
		objectCount2 = objectCount2-1;
	}
	rv = C_FindObjectsFinal(session);
	check_return_value(rv, "Find objects final");
}


int main(int argc, char **argv)
{
	int i, writeAll = -1;;
	CK_SLOT_ID slot;
	CK_SESSION_HANDLE session;
	CK_BYTE *userPin = NULL;
    	int id_bufSize = 64;
    	int label_bufSize = 256;
	CK_RV rv;

	if (argc == 4)
    	{
		userPin = (CK_BYTE *) argv[1];
        	label_bufSize = atoi(argv[2]);
       		id_bufSize = atoi(argv[3]);
        	printf("\n\tArgs: userPin=%s\n",  userPin);
 		printf("\tlabel_bufSize=%d(normal value: 256)\n", label_bufSize);
		printf("\tid_bufSize=%d (normal value: 20)\n", id_bufSize);
    	}
    	else
    	{
            	printf("\n\t Usage:\n");
		printf("\n\t%s SECRET_KEY label_buffer_size(256) id_buffer_size(20)\n\n",argv[0]);
		return EXIT_FAILURE;
	}
	rv = initialize();
	check_return_value(rv, "initialize");

	slot = get_slot();
	session = start_session(slot);
	login(session, userPin);
	read_private_keys(session,label_bufSize,id_bufSize);
	
	//logout(session);
	end_session(session);
	finalize();
	return EXIT_SUCCESS;
}
