/*
 * Decompiled with CFR 0.152.
 */
package axway.rmi.agent;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class CustomAgent {
    private CustomAgent() {
    }

    public static void premain(String agentArgs) throws IOException {
        System.setProperty("java.rmi.server.randomIDs", "true");
        int port = Integer.parseInt(System.getProperty("axway.rmi.agent.port", "9000"));
        System.out.println("Create RMI registry on port " + port);
        LocateRegistry.createRegistry(port);
        System.out.println("Get the platform's MBean server");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        System.out.println("Initialize the environment map");
        HashMap env = new HashMap();
        System.out.println("Create an RMI connector server");
        String hostname = InetAddress.getLocalHost().getHostName();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + port + "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi");
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        System.out.println("Start the RMI connector server on port " + port);
        cs.start();
        System.out.println("RMI connector server started on port " + port);
    }
}

