/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.business;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.MaintenancePeriodDao;
import com.prelytis.dashboard.dao.UserDao;
import com.prelytis.dashboard.dao.filter.DbDefaultFilter;
import com.prelytis.dashboard.dao.filter.DbMaintenancePeriodFilter;
import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.helper.ExpressionEvaluationDataHelper;
import com.prelytis.dashboard.helper.LocaleHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.value.LifeCycleRequest;
import com.prelytis.dashboard.value.LifeCycleResponse;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.ParameterRequest;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.SystemRequest;
import com.prelytis.dashboard.value.data.BeanMaintenancePeriod;
import com.prelytis.dashboard.value.data.BeanUser;
import com.prelytis.dashboard.value.data.BeanUserExecutionContext;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.MaintenancePeriodMessage;
import java.io.Serializable;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.log4j.LogManager;

public class MaintenancePeriodFacade
extends AbstractFacade {
    private final List<MaintenancePeriod> maintenancePeriods = new ArrayList<MaintenancePeriod>();
    private final Map<Integer, MaintenancePeriod> maintenancePeriodsByProfile = new HashMap<Integer, MaintenancePeriod>();

    public MaintenancePeriodFacade(DashboardFacade facade) {
        super(facade);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response dashboardRequest(Request request) throws DashboardException {
        MaintenancePeriodMessage message;
        Response response;
        block24: {
            response = null;
            if (request instanceof LifeCycleRequest) {
                LifeCycleRequest lifeCycleRequest = (LifeCycleRequest)request;
                LifeCycleRequest.Action action = lifeCycleRequest.getAction();
                switch (action) {
                    case RELOAD_CONTEXT: 
                    case RELOAD_SYSTEM_PREFERENCES: 
                    case START_SERVICE: {
                        LifeCycleResponse lifeCycleResponse = (LifeCycleResponse)this.getFacade().dashboardRequest((Request)lifeCycleRequest);
                        if (lifeCycleResponse.getState() != null && lifeCycleResponse.getState() == 1) {
                            this.reloadMaintenancePeriods(DaoFactory.getInstance());
                        }
                        return lifeCycleResponse;
                    }
                    case STOP_SERVICE: {
                        this.clearMaintenancePeriod();
                        return this.getFacade().dashboardRequest((Request)lifeCycleRequest);
                    }
                }
            } else {
                ParameterRequest parameterRequest;
                if (request instanceof SystemRequest || request instanceof LogoutRequest) {
                    return this.getFacade().dashboardRequest(request);
                }
                if (request instanceof ParameterRequest && (parameterRequest = (ParameterRequest)request).getAction() != null && parameterRequest.getAction() == ParameterRequest.Action.SAVE && parameterRequest.getElement() instanceof BeanMaintenancePeriod) {
                    response = this.getFacade().dashboardRequest(request);
                    this.reloadMaintenancePeriods(DaoFactory.getInstance());
                    return response;
                }
            }
            DaoFactory daoFactory = DaoFactory.getInstance();
            Integer userProfile = null;
            Locale locale = null;
            TimeZone tz = null;
            if (!this.maintenancePeriodsByProfile.isEmpty()) {
                Principal principal;
                LoginRequest loginRequest;
                boolean useUID = true;
                if (request instanceof LoginRequest && (loginRequest = (LoginRequest)request).getAction() == LoginRequest.Action.LOGIN && (principal = loginRequest.getUserPrincipal()) != null) {
                    UserDao userDao = daoFactory.getUserDao();
                    try {
                        BeanUser user = (BeanUser)userDao.getCore(principal.getName());
                        BeanUserExecutionContext ec = null;
                        for (BeanUserExecutionContext bec : user.getExecutionContextList()) {
                            if ((request.getExecutionContext() != null || bec.getObjectID() != user.getDefaultExecutionContextOID()) && (request.getExecutionContext() == null || !request.getExecutionContext().equals(bec.getName()))) continue;
                            ec = bec;
                            break;
                        }
                        if (ec != null) {
                            userProfile = ec.getProfile();
                            locale = LocaleHelper.getLocale(daoFactory, user);
                            tz = LocaleHelper.getTimeZone(user);
                            useUID = false;
                        }
                    }
                    catch (Exception e) {
                        LogManager.getLogger(this.getClass()).warn((Object)e);
                    }
                }
                if (useUID && request.getUserSessionGuid() != null) {
                    ExpressionEvaluationData data = ExpressionEvaluationDataHelper.getInstance(daoFactory).getExpressionEvaluationData(request.getUserSessionGuid(), request.getExecutionContext());
                    userProfile = data.getProfile();
                    locale = data.getLocale();
                    tz = data.getTimeZone();
                }
            }
            MaintenancePeriod maintenancePeriod = null;
            if (userProfile != null) {
                maintenancePeriod = this.maintenancePeriodsByProfile.get(userProfile);
            }
            message = null;
            if (maintenancePeriod != null) {
                Date now = new Date();
                Date maintenance = maintenancePeriod.getNextMaintenance();
                Date info = maintenancePeriod.getNextInfo();
                Date end = maintenancePeriod.getNextEnd();
                if (info != null && info.before(now)) {
                    if (maintenance != null && maintenance.before(now)) {
                        if (end != null && now.after(end)) {
                            this.updateMaintenancePeriods();
                            break block24;
                        } else {
                            DateFormat df = DateFormat.getDateTimeInstance();
                            if (locale != null) {
                                df.setCalendar(Calendar.getInstance(tz, locale));
                            }
                            String param = df.format(end);
                            throw ExceptionHelper.getInstance(locale).createDashboardException("maintenancePeriod", new String[]{param}, null);
                        }
                    }
                    message = new MaintenancePeriodMessage(new Date(), maintenance);
                }
            }
        }
        response = this.getFacade().dashboardRequest(request);
        if (message != null) {
            response.getNotifications().add(message);
        }
        return response;
    }

    private void clearMaintenancePeriod() {
        this.maintenancePeriods.clear();
        this.maintenancePeriodsByProfile.clear();
    }

    @Override
    public void init(Map<String, String> properties) {
    }

    private void reloadMaintenancePeriods(DaoFactory daoFactory) {
        this.maintenancePeriods.clear();
        this.maintenancePeriodsByProfile.clear();
        MaintenancePeriodDao maintenancePeriodDao = daoFactory.getMaintenancePeriodDao();
        DbMaintenancePeriodFilter filter = new DbMaintenancePeriodFilter();
        filter.setActive(Boolean.TRUE);
        List list = maintenancePeriodDao.listAll((DbDefaultFilter)filter, 1);
        for (Element elt : list) {
            BeanMaintenancePeriod maintenancePeriod = (BeanMaintenancePeriod)elt;
            MaintenancePeriod mp = new MaintenancePeriod();
            mp.setStartDate(maintenancePeriod.getStartDate());
            mp.setEndDate(maintenancePeriod.getEndDate());
            mp.setHour(maintenancePeriod.getHour());
            mp.setMinute(maintenancePeriod.getMinute());
            mp.setDayOfWeek(maintenancePeriod.getDayOfWeek());
            mp.setDayOfMonth(maintenancePeriod.getDayOfMonth());
            mp.setMonth(maintenancePeriod.getMonth());
            mp.setInformationDuration(maintenancePeriod.getInformationDuration());
            mp.setMaintenanceDuration(maintenancePeriod.getMaintenanceDuration());
            mp.setProfile(maintenancePeriod.getProfile());
            this.maintenancePeriods.add(mp);
        }
        this.updateMaintenancePeriods();
    }

    private boolean isActive(Date date, MaintenancePeriod maintenancePeriod) {
        if (maintenancePeriod.getStartDate() == null) {
            if (maintenancePeriod.getEndDate() == null) {
                return true;
            }
            return date.before(maintenancePeriod.getEndDate());
        }
        if (maintenancePeriod.getEndDate() == null) {
            return date.after(maintenancePeriod.getStartDate());
        }
        return date.after(maintenancePeriod.getStartDate()) && date.before(maintenancePeriod.getEndDate());
    }

    private void updateMaintenancePeriods() {
        int[] profiles;
        Date currentDate = new Date();
        ArrayList<MaintenancePeriod> active = new ArrayList<MaintenancePeriod>();
        for (MaintenancePeriod mp : this.maintenancePeriods) {
            if (this.isActive(currentDate, mp)) {
                this.updateForNextMaintenancePeriod(mp, currentDate);
                active.add(mp);
                continue;
            }
            mp.nextEnd = null;
            mp.nextInfo = null;
            mp.nextMaintenance = null;
        }
        this.maintenancePeriodsByProfile.clear();
        for (int profile : profiles = new int[]{2, 0, 3, 1}) {
            TreeMap<Date, Integer> map = new TreeMap<Date, Integer>();
            for (MaintenancePeriod mp : active) {
                if (mp.getProfile() < profile) continue;
                if (mp.getNextInfo() != null) {
                    map.put(mp.getNextInfo(), 1);
                }
                if (mp.getNextMaintenance() != null) {
                    map.put(mp.getNextMaintenance(), 2);
                }
                if (mp.getNextEnd() == null) continue;
                map.put(mp.getNextEnd(), 3);
            }
            if (map.isEmpty()) continue;
            int current = 0;
            MaintenancePeriod mpp = new MaintenancePeriod();
            for (Map.Entry entry : map.entrySet()) {
                if (current < (Integer)entry.getValue()) {
                    current = (Integer)entry.getValue();
                    switch (current) {
                        case 1: {
                            mpp.setNextInfo((Date)entry.getKey());
                            break;
                        }
                        case 2: {
                            mpp.setNextMaintenance((Date)entry.getKey());
                            break;
                        }
                        case 3: {
                            mpp.setNextEnd((Date)entry.getKey());
                        }
                    }
                    continue;
                }
                if (current != 3) continue;
                if ((Integer)entry.getValue() != 3) break;
                mpp.setNextEnd((Date)entry.getKey());
            }
            this.maintenancePeriodsByProfile.put(profile, mpp);
        }
    }

    private void updateForNextMaintenancePeriod(MaintenancePeriod mp, Date curDate) {
        int offset;
        mp.nextEnd = null;
        mp.nextInfo = null;
        mp.nextMaintenance = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(12, -mp.getMaintenanceDuration());
        curDate = calendar.getTime();
        Date date = mp.getStartDate();
        if (date == null || curDate.after(date)) {
            date = curDate;
        }
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (mp.getMinute() != -1) {
            offset = mp.getMinute() - calendar.get(12);
            if (offset < 0) {
                offset += 60;
            }
            calendar.add(12, offset);
        }
        if (mp.getHour() != -1) {
            offset = mp.getHour() - calendar.get(11);
            if (offset < 0) {
                offset += 24;
            }
            calendar.add(10, offset);
        }
        if (mp.getMonth() != -1) {
            offset = mp.getMonth() - calendar.get(2);
            if (offset < 0) {
                offset += 12;
            }
            calendar.add(2, offset);
        }
        int offset1 = 0;
        int offset2 = 0;
        int cpt = 0;
        while (!(mp.getDayOfWeek() != -1 && (offset1 = mp.getDayOfWeek() - calendar.get(7)) == 0 || mp.getDayOfMonth() != -1 && (offset2 = mp.getDayOfMonth() - calendar.get(5)) == 0 || mp.getDayOfWeek() == -1 && mp.getDayOfMonth() == -1)) {
            if (offset2 < 0) {
                calendar.add(2, 1);
                calendar.add(5, offset2);
            } else if (offset1 < 0) {
                calendar.add(5, offset1 += 7);
            } else {
                calendar.add(5, Math.max(offset1, offset2));
            }
            if (++cpt <= 100) continue;
            return;
        }
        date = calendar.getTime();
        if (mp.getEndDate() != null && date.after(mp.getEndDate())) {
            return;
        }
        mp.nextMaintenance = date;
        calendar.add(12, -mp.getInformationDuration());
        mp.nextInfo = calendar.getTime();
        calendar.setTime(date);
        calendar.add(12, mp.getMaintenanceDuration());
        mp.nextEnd = calendar.getTime();
    }

    private static class MaintenancePeriod
    implements Serializable {
        private static final long serialVersionUID = -9060917390781465848L;
        private Date endDate;
        private Date startDate;
        private int hour;
        private int minute;
        private int month;
        private int dayOfMonth;
        private int dayOfWeek;
        private int informationDuration;
        private int maintenanceDuration;
        private int profile;
        private Date nextInfo;
        private Date nextMaintenance;
        private Date nextEnd;

        private MaintenancePeriod() {
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public int getHour() {
            return this.hour;
        }

        public void setHour(int hour) {
            this.hour = hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public void setMinute(int minute) {
            this.minute = minute;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDayOfMonth() {
            return this.dayOfMonth;
        }

        public void setDayOfMonth(int dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public int getDayOfWeek() {
            return this.dayOfWeek;
        }

        public void setDayOfWeek(int dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public int getInformationDuration() {
            return this.informationDuration;
        }

        public void setInformationDuration(int informationDuration) {
            this.informationDuration = informationDuration;
        }

        public int getMaintenanceDuration() {
            return this.maintenanceDuration;
        }

        public void setMaintenanceDuration(int maintenanceDuration) {
            this.maintenanceDuration = maintenanceDuration;
        }

        public Date getNextInfo() {
            return this.nextInfo;
        }

        public void setNextInfo(Date nextInfo) {
            this.nextInfo = nextInfo;
        }

        public Date getNextMaintenance() {
            return this.nextMaintenance;
        }

        public void setNextMaintenance(Date nextMaintenance) {
            this.nextMaintenance = nextMaintenance;
        }

        public Date getNextEnd() {
            return this.nextEnd;
        }

        public void setNextEnd(Date nextEnd) {
            this.nextEnd = nextEnd;
        }

        public int getProfile() {
            return this.profile;
        }

        public void setProfile(int profile) {
            this.profile = profile;
        }
    }
}

