/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.business;

import com.prelytis.dashboard.dao.ConnectionTraceDao;
import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.db.RequestContext;
import com.prelytis.dashboard.ext.AbstractFacade;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardFacade;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.I18nElement;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.persistence.ConnectionTrace;
import com.prelytis.dashboard.persistence.DataSourceConfiguration;
import com.prelytis.dashboard.persistence.DatasourceTrace;
import com.prelytis.dashboard.value.DocumentRequest;
import com.prelytis.dashboard.value.DocumentResponse;
import com.prelytis.dashboard.value.ExecutionContext;
import com.prelytis.dashboard.value.LifeCycleRequest;
import com.prelytis.dashboard.value.LoginRequest;
import com.prelytis.dashboard.value.LoginResponse;
import com.prelytis.dashboard.value.LogoutRequest;
import com.prelytis.dashboard.value.Request;
import com.prelytis.dashboard.value.Response;
import com.prelytis.dashboard.value.data.SecurityAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TraceFacade
extends AbstractFacade {
    private static final Logger log = LogManager.getLogger(TraceFacade.class);
    private boolean debug;
    private int logLongRunningRequestThreshold;
    private boolean connectionTrace;
    private int connectionTraceHistory;
    private long nextClean;
    private boolean traceJdbcLeak;

    public TraceFacade(DashboardFacade dashboardFacade) {
        super(dashboardFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response dashboardRequest(Request value) throws DashboardException {
        long start = System.nanoTime();
        long duration = 0L;
        if (this.debug) {
            log.info((Object)new StringBuffer().append("Request ").append(start).append(" : ").append(value.getClass().toString()).toString());
        }
        Response response = null;
        try {
            response = this.getFacade().dashboardRequest(value);
        }
        catch (DashboardException e) {
            if (this.debug) {
                log.error((Object)e, (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.debug) {
                log.error((Object)e, (Throwable)e);
            }
            throw e;
        }
        finally {
            RequestContext context;
            duration = System.nanoTime() - start;
            if (this.logLongRunningRequestThreshold >= 0 && duration > (long)this.logLongRunningRequestThreshold && (context = RequestContext.getCurrentInstance()) != null) {
                log.info((Object)context.toString());
            }
        }
        try {
            DataSourceConfiguration dsc;
            DataSource ds;
            Configuration configuration;
            if (this.connectionTrace) {
                String userSessionGuid;
                DocumentRequest request;
                DaoFactory factory = DaoFactory.getInstance();
                if (response instanceof DocumentResponse) {
                    I18nElement elt;
                    request = (DocumentRequest)value;
                    DocumentResponse docResponse = (DocumentResponse)response;
                    userSessionGuid = request.getUserSessionGuid();
                    SessionType documentType = request.getDocumentType();
                    SecurityAdapter doc = docResponse.getDocument();
                    String documentName = null;
                    if (doc != null && (elt = doc.getElement()) != null) {
                        documentName = elt.getName();
                    }
                    boolean onDashBoard = request.isDocumentFromDashboard();
                    if (userSessionGuid == null) {
                        log.debug((Object)"TraceFacade: userSessionGuid is null on DocumentRequest");
                    } else if (documentType == null || documentName == null) {
                        log.warn((Object)"TraceFacade: documentType or documentName is null on DocumentRequest");
                    } else if (!request.isPreview()) {
                        ConnectionTraceDao connectionTraceDao = factory.getConnectionTraceDao();
                        connectionTraceDao.saveDocuments(userSessionGuid, documentType, documentName, onDashBoard, (double)duration);
                    }
                } else if (value instanceof LoginRequest) {
                    LoginRequest logRequest = (LoginRequest)value;
                    if (logRequest.getAction() == LoginRequest.Action.LOGIN && response instanceof LoginResponse) {
                        LoginResponse logResponse = (LoginResponse)response;
                        userSessionGuid = logResponse.getUserSessionGuid();
                        String userName = logResponse.getUserName();
                        ExecutionContext ec = logResponse.getDefaultExecutionContext();
                        String entityName = ec.getName();
                        String workspaceName = ec.getName();
                        Date connectionDate = logResponse.getConnectionDate();
                        Integer connectionType = logResponse.getConnectionType();
                        if (userSessionGuid == null) {
                            log.debug((Object)"TraceFacade: userSessionGuid is null on LoginRequest");
                        } else if (userName == null || entityName == null || workspaceName == null || connectionDate == null || connectionType == null) {
                            log.warn((Object)"TraceFacade: userName, entityName, workspaceName, connectionDate or connectionType is null on LoginResponse");
                        } else {
                            ConnectionTraceDao connectionTraceDao = factory.getConnectionTraceDao();
                            connectionTraceDao.saveConnection(userSessionGuid, userName, workspaceName, entityName, connectionDate, connectionType.intValue());
                        }
                    }
                } else if (value instanceof LogoutRequest) {
                    request = (LogoutRequest)value;
                    String userSessionGuid2 = request.getUserSessionGuid();
                    Date disconnectionDate = new Date();
                    if (userSessionGuid2 == null) {
                        log.debug((Object)"TraceFacade: userSessionGuid is null on LogoutRequest");
                    } else {
                        ConnectionTraceDao connectionTraceDao = factory.getConnectionTraceDao();
                        connectionTraceDao.saveDisconnection(userSessionGuid2, disconnectionDate);
                    }
                }
                if (this.connectionTraceHistory > 0) {
                    boolean execution = false;
                    if (this.nextClean == 0L || this.nextClean < System.currentTimeMillis()) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(new Date());
                        cal.add(5, 1);
                        this.nextClean = cal.getTimeInMillis();
                        execution = true;
                    }
                    if (execution) {
                        ConnectionTraceDao connectionTraceDao = factory.getConnectionTraceDao();
                        connectionTraceDao.cleanData(this.connectionTraceHistory);
                    }
                }
            }
            if (value instanceof LifeCycleRequest) {
                configuration = Configuration.getInstance();
                DataSourceConfiguration dsc2 = configuration.getDataSourceConfiguration();
                this.traceJdbcLeak = dsc2.isTraceJdbcLeak();
            }
            if (this.traceJdbcLeak && (ds = (dsc = (configuration = Configuration.getInstance()).getDataSourceConfiguration()).getDataSource()) instanceof DatasourceTrace) {
                DatasourceTrace dst = (DatasourceTrace)ds;
                for (ConnectionTrace con : dst.getConnectionList()) {
                    log.error((Object)con.getTrace());
                }
                for (ConnectionTrace con : dst.getStatementList()) {
                    log.error((Object)con.getTrace());
                }
                for (ConnectionTrace con : dst.getResultSetList()) {
                    log.error((Object)con.getTrace());
                }
            }
        }
        catch (DashboardRuntimeException e) {
            log.warn((Object)e);
        }
        catch (RuntimeException e) {
            log.warn((Object)e);
        }
        finally {
            if (this.debug) {
                long end = System.nanoTime();
                log.info((Object)new StringBuffer().append("Request ").append(start).append(" duration ").append((double)(end - start) / 1000000.0).append("ms").toString());
            }
        }
        return response;
    }

    @Override
    public void init(Map<String, String> properties) {
        try {
            this.debug = this.getProperty(properties, "debug", false);
            this.connectionTrace = this.getProperty(properties, "connectionTrace", false);
            this.connectionTraceHistory = this.getProperty(properties, "connectionTraceHistory", -1);
            this.logLongRunningRequestThreshold = this.getProperty(properties, "logLongRunningRequestThreshold", -1);
        }
        catch (Exception e) {
            log.warn((Object)"Error while initializing TraceFacade");
            this.debug = false;
            this.connectionTrace = false;
            this.connectionTraceHistory = -1;
            this.logLongRunningRequestThreshold = -1;
        }
    }

    private int getProperty(Map<String, String> properties, String key, int defValue) {
        String v = properties.get(key);
        if (v == null) {
            return defValue;
        }
        return Integer.parseInt(v);
    }

    private boolean getProperty(Map<String, String> properties, String key, boolean defValue) {
        String v = properties.get(key);
        if (v == null) {
            return defValue;
        }
        return Boolean.parseBoolean(v);
    }
}

