/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data;

import com.prelytis.dashboard.data.CrossTableCalculationLine;
import com.prelytis.dashboard.data.CrossTableHeaderDefinition;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueString;
import com.prelytis.dashboard.value.tree.TreeNode;

public class CrossTableHeader {
    private final int id;
    private final TreeNode<CrossTableHeaderDefinition> def;
    private final Value value;
    private final Value sortValue;
    private final CrossTableCalculationLine calculationLine;
    private final int start;
    private final int end;
    private int span;

    public CrossTableHeader(int id, TreeNode<CrossTableHeaderDefinition> def, Value value, Value sortValue) {
        this.id = id;
        this.calculationLine = null;
        this.start = -1;
        this.end = -1;
        this.def = def;
        this.value = value;
        this.sortValue = sortValue;
    }

    public CrossTableHeader(int id, CrossTableCalculationLine calculationLine, int start, int end) {
        this.id = id;
        this.calculationLine = calculationLine;
        this.start = start;
        this.end = end;
        this.def = null;
        this.value = ValueString.valueOf((Object)calculationLine.getDescription());
        this.sortValue = null;
    }

    public int getId() {
        return this.id;
    }

    public TreeNode<CrossTableHeaderDefinition> getDef() {
        return this.def;
    }

    public Value getValue() {
        return this.value;
    }

    public Value getSortValue() {
        return this.sortValue;
    }

    public boolean isCalculated() {
        return this.calculationLine != null;
    }

    public CrossTableCalculationLine getCalculationLine() {
        return this.calculationLine;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }
}

