/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueAverage;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueFraction;
import com.prelytis.dashboard.db.value.ValueInteger;
import com.prelytis.dashboard.db.value.ValueLong;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.FractionPart;
import java.math.BigDecimal;

final class CalculationAverage
extends CalculationSimple {
    private ValueFraction value;
    private FractionPart denominateur;

    CalculationAverage() {
    }

    @Override
    public void addValue(Value value) throws DashboardException {
        if (value == null) {
            return;
        }
        if (value instanceof ValueAverage) {
            ValueAverage ref = (ValueAverage)value;
            ValueDecimalNumber n = ref.getNumerator();
            ValueLong d = ref.getDenominator();
            this.add(n.getDecimalValue(), (ValueDecimalNumber)d);
        } else if (value instanceof ValueDecimalNumber) {
            this.add(((ValueDecimalNumber)value).getDecimalValue(), (ValueDecimalNumber)ValueInteger.valueOf((int)1));
        }
    }

    private void add(BigDecimal n, ValueDecimalNumber d) {
        if (this.denominateur == null) {
            this.denominateur = new FractionPart();
        }
        ValueFraction fraction = new ValueFraction(this.value == null ? n : this.value.getBigDecimal().add(n), this.denominateur);
        fraction.addDenominator(d);
        this.value = fraction;
    }

    @Override
    public Value getValue() {
        if (this.value == null) {
            return ValueNull.DOUBLE;
        }
        return this.value;
    }

    @Override
    public void reset() {
        this.denominateur = null;
        this.value = null;
    }
}

