/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import java.math.BigDecimal;

final class CalculationEvolution
extends CalculationSimple {
    private Value prevValue;
    private BigDecimal value;

    CalculationEvolution() {
    }

    @Override
    public void addValue(Value value) {
        if (value != null && this.prevValue != null && value instanceof ValueDecimalNumber && this.prevValue instanceof ValueDecimalNumber) {
            BigDecimal pValue = ((ValueDecimalNumber)this.prevValue).getDecimalValue();
            BigDecimal cValue = ((ValueDecimalNumber)value).getDecimalValue();
            this.value = cValue.subtract(pValue);
        } else {
            this.value = null;
        }
        this.prevValue = value;
    }

    @Override
    public Value getValue() {
        if (this.value == null) {
            return ValueNull.DOUBLE;
        }
        return new ValueBigDecimal(this.value);
    }

    @Override
    public void reset() {
        this.value = null;
        this.prevValue = null;
    }
}

