/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueFraction;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.Fraction;
import com.prelytis.dashboard.value.util.FractionPart;

public final class CalculationFractionWrapper
extends CalculationSimple {
    private FractionPart denominateur;
    private CalculationSimple calculation;
    private boolean valid;

    public CalculationFractionWrapper(CalculationSimple calculation) {
        this.calculation = calculation;
    }

    @Override
    public void addValue(Value value) throws DashboardException {
        if (this.valid && value instanceof ValueFraction) {
            ValueFraction vf = (ValueFraction)value;
            Fraction f = (Fraction)vf.getNumber();
            if (this.denominateur == null) {
                this.denominateur = f.getDenominator();
            } else if (this.denominateur != f.getDenominator()) {
                this.valid = false;
            }
            this.calculation.addValue((Value)new ValueBigDecimal(f.getNumerator().getDecimalValue()));
        }
    }

    @Override
    public Value getValue() {
        Value value = this.calculation.getValue();
        if (this.valid && value instanceof ValueDecimalNumber && this.denominateur != null) {
            ValueDecimalNumber vdn = (ValueDecimalNumber)value;
            return new ValueFraction(vdn.getDecimalValue(), this.denominateur);
        }
        return ValueNull.DOUBLE;
    }

    @Override
    public void reset() {
        this.denominateur = null;
        if (this.calculation != null) {
            this.calculation.reset();
        }
        this.valid = true;
    }
}

