/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.math.BigDecimal;

final class CalculationMedian
extends CalculationSimple {
    private BigDecimal min;
    private BigDecimal max;

    CalculationMedian() {
    }

    @Override
    public void addValue(Value value) throws DashboardException {
        if (value == null) {
            return;
        }
        if (value instanceof ValueDecimalNumber) {
            BigDecimal ref = ((ValueDecimalNumber)value).getDecimalValue();
            this.min = this.min == null ? ref : this.min.min(ref);
            this.max = this.max == null ? ref : this.max.max(ref);
        }
    }

    @Override
    public Value getValue() {
        if (this.min == null || this.max == null) {
            return ValueNull.BIG_DECIMAL;
        }
        return new ValueBigDecimal(this.min.add(this.max).divide(BigDecimal.valueOf(2L), MATH_CONTEXT));
    }

    @Override
    public void reset() {
        this.max = null;
        this.min = null;
    }
}

