/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueBigDecimal;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueNull;
import java.math.BigDecimal;

final class CalculationPercEvolution
extends CalculationSimple {
    private ValueBigDecimal prevValue;
    private ValueBigDecimal value;

    CalculationPercEvolution() {
    }

    @Override
    public void addValue(Value value) {
        if (value != null && this.prevValue != null && value instanceof ValueDecimalNumber && this.prevValue instanceof ValueDecimalNumber) {
            BigDecimal pValue = this.prevValue.getDecimalValue();
            BigDecimal cValue = ((ValueDecimalNumber)value).getDecimalValue();
            this.value = pValue.signum() != 0 ? new ValueBigDecimal(cValue.subtract(pValue).divide(pValue, MATH_CONTEXT)) : null;
        } else {
            this.value = null;
        }
        this.prevValue = value != null ? new ValueBigDecimal(((ValueDecimalNumber)value).getDecimalValue()) : null;
    }

    @Override
    public Value getValue() {
        if (this.value == null) {
            return ValueNull.BIG_DECIMAL;
        }
        return this.value;
    }

    @Override
    public void reset() {
        this.value = null;
        this.prevValue = null;
    }
}

