/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationAverage;
import com.prelytis.dashboard.data.calculation.CalculationBase;
import com.prelytis.dashboard.data.calculation.CalculationClearWhenDifferent;
import com.prelytis.dashboard.data.calculation.CalculationCount;
import com.prelytis.dashboard.data.calculation.CalculationEvolution;
import com.prelytis.dashboard.data.calculation.CalculationFirstValue;
import com.prelytis.dashboard.data.calculation.CalculationLastValue;
import com.prelytis.dashboard.data.calculation.CalculationList;
import com.prelytis.dashboard.data.calculation.CalculationMax;
import com.prelytis.dashboard.data.calculation.CalculationMedian;
import com.prelytis.dashboard.data.calculation.CalculationMin;
import com.prelytis.dashboard.data.calculation.CalculationPercEvolution;
import com.prelytis.dashboard.data.calculation.CalculationPercTotal;
import com.prelytis.dashboard.data.calculation.CalculationStandardDeviation;
import com.prelytis.dashboard.data.calculation.CalculationSum;
import com.prelytis.dashboard.data.calculation.CalculationTrend;
import com.prelytis.dashboard.data.calculation.CalculationVariance;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.FieldCalculation;
import com.prelytis.dashboard.value.data.SummaryCalculation;
import java.math.MathContext;

public abstract class CalculationSimple {
    protected static final MathContext MATH_CONTEXT = MathContext.DECIMAL32;
    private static final boolean DEBUG = false;

    CalculationSimple() {
    }

    public abstract void addValue(Value var1) throws DashboardException;

    public abstract void reset();

    public abstract Value getValue();

    public static final CalculationSimple getCalculation(FieldAgregation agregation) throws DashboardException {
        CalculationSimple cs = null;
        switch (agregation) {
            case AGREGATION_AVERAGE: {
                cs = new CalculationAverage();
                break;
            }
            case AGREGATION_COUNT: {
                cs = new CalculationCount();
                break;
            }
            case AGREGATION_MAX: {
                cs = new CalculationMax();
                break;
            }
            case AGREGATION_MEDIAN: {
                cs = new CalculationMedian();
                break;
            }
            case AGREGATION_MIN: {
                cs = new CalculationMin();
                break;
            }
            case AGREGATION_NONE: {
                cs = new CalculationClearWhenDifferent();
                break;
            }
            case AGREGATION_STANDARD_DEVIATION: {
                cs = new CalculationStandardDeviation();
                break;
            }
            case AGREGATION_SUM: {
                cs = new CalculationSum();
                break;
            }
            case AGREGATION_SUM_SQUARRED: {
                cs = new CalculationSum();
                break;
            }
            case AGREGATION_VARIANCE: {
                cs = new CalculationVariance();
                break;
            }
            case AGREGATION_FIRST_VALUE: {
                cs = new CalculationFirstValue();
                break;
            }
            case AGREGATION_LAST_VALUE: {
                cs = new CalculationLastValue();
                break;
            }
            case AGREGATION_LIST: {
                cs = new CalculationList();
                break;
            }
            default: {
                throw new DashboardException();
            }
        }
        return cs;
    }

    public static final CalculationSimple getCalculation(FieldCalculation calculation) throws DashboardException {
        CalculationSimple cs = null;
        switch (calculation) {
            case CALCULATION_NONE: 
            case CALCULATION_RATIO: 
            case CALCULATION_PERCENT_EVOL_PREV_COL: 
            case CALCULATION_TREND_PREV_COL: 
            case CALCULATION_EVOL_PREV_COL: {
                return null;
            }
            case CALCULATION_CUMUL: {
                cs = new CalculationSum();
                break;
            }
            case CALCULATION_EVOL: {
                cs = new CalculationEvolution();
                break;
            }
            case CALCULATION_PERCENT_EVOL: {
                cs = new CalculationPercEvolution();
                break;
            }
            case CALCULATION_PERCENT_TOTAL: {
                cs = new CalculationPercTotal();
                break;
            }
            case CALCULATION_TREND: {
                cs = new CalculationTrend();
                break;
            }
            default: {
                throw new DashboardException();
            }
        }
        return cs;
    }

    public static final CalculationSimple getCalculation(SummaryCalculation calculation) throws DashboardException {
        CalculationSimple cs = null;
        switch (calculation) {
            case AVERAGE: {
                cs = new CalculationAverage();
                break;
            }
            case COUNT: {
                cs = new CalculationCount();
                break;
            }
            case EVOLUTION: {
                cs = new CalculationEvolution();
                break;
            }
            case MAX: {
                cs = new CalculationMax();
                break;
            }
            case MEDIAN: {
                cs = new CalculationMedian();
                break;
            }
            case MIN: {
                cs = new CalculationMin();
                break;
            }
            case PERC_EVOLUTION: {
                cs = new CalculationEvolution();
                break;
            }
            case PERC_TOTAL: {
                cs = new CalculationPercTotal();
                break;
            }
            case STANDARD_DEVIATION: {
                cs = new CalculationStandardDeviation();
                break;
            }
            case TOTAL: {
                cs = new CalculationSum();
                break;
            }
            case VARIANCE: {
                cs = new CalculationVariance();
                break;
            }
            case TOTAL_SQUARRED: {
                cs = new CalculationBase();
                break;
            }
            default: {
                throw new DashboardException();
            }
        }
        return cs;
    }
}

