/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.calculation;

import com.prelytis.dashboard.data.calculation.CalculationSimple;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.db.value.ValueDecimalNumber;
import com.prelytis.dashboard.db.value.ValueDouble;
import com.prelytis.dashboard.db.value.ValueNull;
import com.prelytis.dashboard.interfaces.DashboardException;
import java.math.BigDecimal;

final class CalculationStandardDeviation
extends CalculationSimple {
    private BigDecimal sum;
    private BigDecimal sumSquarred;
    private BigDecimal count;

    CalculationStandardDeviation() {
    }

    @Override
    public void addValue(Value value) throws DashboardException {
        if (value == null) {
            return;
        }
        if (value instanceof ValueDecimalNumber) {
            BigDecimal d = ((ValueDecimalNumber)value).getDecimalValue();
            this.sum = this.sum.add(d);
            this.sumSquarred = this.sumSquarred.add(d.pow(2));
            this.count = this.count.add(BigDecimal.ONE);
        }
    }

    @Override
    public Value getValue() {
        if (this.count.longValue() <= 1L) {
            return ValueNull.BIG_DECIMAL;
        }
        BigDecimal bd = this.sumSquarred.subtract(this.sum.pow(2).divide(this.count, MATH_CONTEXT)).divide(this.count.subtract(BigDecimal.ONE), MATH_CONTEXT);
        return new ValueDouble(Math.sqrt(bd.doubleValue()));
    }

    @Override
    public void reset() {
        this.sum = BigDecimal.ZERO;
        this.sumSquarred = BigDecimal.ZERO;
        this.count = BigDecimal.ZERO;
    }
}

