/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.comparator;

import com.prelytis.dashboard.data.transformation.parameter.RowCell;
import com.prelytis.dashboard.data.transformation.parameter.RowParameter;
import com.prelytis.dashboard.db.ValueComparator;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.db.value.Value;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;

public class RowComparator
implements Comparator<RowParameter> {
    private List<SortColumn> sortColumns;
    private ValueComparator valueComparator;

    public RowComparator(Collator collator, List<SortColumn> sortColumns) {
        this.sortColumns = sortColumns;
        this.valueComparator = new ValueComparator(collator);
    }

    @Override
    public int compare(RowParameter o1, RowParameter o2) {
        int comp = 0;
        for (SortColumn sc : this.sortColumns) {
            if (sc.getCol() < 0 || sc.getCol() >= o1.getCells().size()) continue;
            RowCell r1 = o1.getCells().get(sc.getCol());
            Value v1 = r1.getValue();
            RowCell r2 = o2.getCells().get(sc.getCol());
            Value v2 = r2.getValue();
            switch (sc.getSortOrder()) {
                case SORT_ASCENDING: {
                    comp = this.valueComparator.compare(v1, v2);
                    break;
                }
                case SORT_DESCENDING: {
                    comp = this.valueComparator.compare(v2, v1);
                }
            }
            if (comp == 0) continue;
            return comp;
        }
        return o2.getRowNumber() - o1.getRowNumber();
    }
}

