/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine;

import com.prelytis.dashboard.data.engine.Engine;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.SortField;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractEngine
implements Engine {
    protected static final Logger log = LogManager.getLogger(AbstractEngine.class);
    private ExecutionContext context;
    private Collection<Field> fieldList;
    private List<SortField> sortFieldList;
    private boolean forceGroupBy = true;

    public final DashboardException getDashboardException(String key, String[] params) {
        ExpressionEvaluationData data = this.context == null ? null : this.context.getData();
        return ExceptionHelper.getInstance(data == null ? Locale.ENGLISH : data.getLocale()).createDashboardException(key, params, null);
    }

    protected DashboardException getDashBoardException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        log.error((Object)e);
        return new DashboardException((Throwable)e);
    }

    public AbstractEngine(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public ExecutionContext getContext() {
        return this.context;
    }

    @Override
    public Collection<Field> getFieldList() {
        return this.fieldList;
    }

    @Override
    public void setFieldList(Collection<Field> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public List<SortField> getSortFieldList() {
        return this.sortFieldList;
    }

    @Override
    public void setSortFieldList(List<SortField> sortFieldList) {
        this.sortFieldList = sortFieldList;
    }

    public boolean getForceGroupBy() {
        return this.forceGroupBy;
    }

    public void setForceGroupBy(boolean forceGroupBy) {
        this.forceGroupBy = forceGroupBy;
    }

    public String toString() {
        if (this.context == null || this.context.getQuery() == null) {
            return super.toString();
        }
        return this.context.getQuery().getName();
    }
}

