/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine;

import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.ExpressionBuilder;
import com.prelytis.dashboard.data.engine.ds.ToBeRemovedException;
import com.prelytis.dashboard.helper.ExceptionHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.parsing.ExpressionParser;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.query.BooleanExpression;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.query.PromptOperand;
import com.prelytis.dashboard.value.util.AllExpression;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommandExpression {
    private ExecutionContext context;
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();

    public CommandExpression(ExecutionContext context) {
        this.context = context;
    }

    public Expression getExpression(Expression expression) throws DashboardException {
        try {
            return this.getExp(expression);
        }
        catch (ToBeRemovedException e) {
            return null;
        }
    }

    public Expression getExp(Expression expression) throws DashboardException {
        if (expression == null) {
            return null;
        }
        if (expression instanceof LogicalExpression) {
            return this.getLogicalExpression((LogicalExpression)expression);
        }
        if (expression instanceof ComparisonExpression) {
            return this.getComparisonExpression((ComparisonExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return expression;
        }
        throw this.getDashboardException("unknownExpression");
    }

    private DashboardException getDashboardException(String key) {
        ExpressionEvaluationData data = this.context == null ? null : this.context.getData();
        return ExceptionHelper.getInstance(data == null ? Locale.ENGLISH : data.getLocale()).createDashboardException(key, null, null);
    }

    private Expression getLogicalExpression(LogicalExpression expression) throws DashboardException {
        LogicalExpression newExpression = new LogicalExpression();
        List newExpList = newExpression.getExpressionList();
        for (Expression exp : expression.getExpressionList()) {
            try {
                exp = this.getExpression(exp);
                if (exp instanceof LogicalExpression) {
                    LogicalExpression le = (LogicalExpression)exp;
                    if (le.getOperator() == expression.getOperator()) {
                        newExpList.addAll(le.getExpressionList());
                        continue;
                    }
                    newExpList.add(le);
                    continue;
                }
                if (exp == null) continue;
                newExpList.add(exp);
            }
            catch (ToBeRemovedException e) {
                if (expression.getOperator() != 2) continue;
                throw new ToBeRemovedException();
            }
        }
        if (newExpList.size() == 0) {
            return null;
        }
        if (newExpList.size() == 1) {
            return (Expression)newExpList.get(0);
        }
        newExpression.setOperator(expression.getOperator());
        return newExpression;
    }

    private Expression getComparisonExpression(ComparisonExpression expression) throws DashboardException {
        if (!(expression.getLeftOperand() instanceof FieldOperand)) {
            throw this.getDashboardException("unknownOperand");
        }
        FieldOperand lo = (FieldOperand)expression.getLeftOperand();
        FieldOperand nlo = new FieldOperand();
        nlo.setField(lo.getField());
        Operand ro = expression.getRightOperand();
        if (ro instanceof ConstantOperand) {
            ConstantOperand constant = (ConstantOperand)ro;
            Object[] values = this.getValues(constant.getValue());
            ConstantOperand newConstant = new ConstantOperand();
            newConstant.setDataType(constant.getDataType());
            newConstant.setValue((Object)values);
            return ExpressionBuilder.getCE(nlo, expression.getOperator(), (Operand)constant, false);
        }
        if (ro instanceof FieldOperand) {
            FieldOperand field = (FieldOperand)ro;
            FieldOperand newField = new FieldOperand();
            newField.setField(field.getField());
            return ExpressionBuilder.getCE(nlo, expression.getOperator(), (Operand)newField, false);
        }
        if (ro instanceof PromptOperand) {
            boolean useFilter;
            PromptOperand prompt = (PromptOperand)ro;
            Map<String, ReportFilter> filterMap = this.context.getFilterMap();
            ReportFilter rf = null;
            Object[] values = null;
            if (filterMap != null) {
                rf = filterMap.get(prompt.getName());
            }
            if (rf != null) {
                useFilter = rf.getUseFilter();
                values = rf.getValues();
            } else {
                useFilter = prompt.isUsed();
                values = prompt.getValues();
            }
            if (prompt.isMandatory()) {
                useFilter = true;
            }
            if (useFilter) {
                if (prompt.getPromptType() == 4) {
                    String s = String.valueOf(values[0]).replaceAll("\\*", "\\\\*").replaceAll("\\?", "\\\\?");
                    boolean isSimpleValue = false;
                    ExpressionParser p = new ExpressionParser((Reader)new StringReader(s));
                    return ExpressionBuilder.buildExpression(expression, p, prompt, nlo, isSimpleValue);
                }
                try {
                    values = this.getValues(values);
                }
                catch (ToBeRemovedException e) {
                    if (rf != null) {
                        rf.setUseFilter(false);
                    }
                    throw new ToBeRemovedException();
                }
                ConstantOperand co = new ConstantOperand();
                co.setDataType(prompt.getDataType());
                co.setValue((Object)values);
                boolean isSimpleValue = true;
                return ExpressionBuilder.getCE(nlo, expression.getOperator(), (Operand)co, isSimpleValue);
            }
            return null;
        }
        throw this.getDashboardException("unknownOperand");
    }

    private Object[] getValues(Object obj) throws DashboardException {
        ArrayList<Object> l = new ArrayList<Object>();
        this.fill(l, obj);
        if (l.isEmpty()) {
            return null;
        }
        return l.toArray(new Object[l.size()]);
    }

    private void fill(List<Object> l, Object obj) throws DashboardException {
        if (obj instanceof Object[]) {
            for (Object o : (Object[])obj) {
                this.fill(l, o);
            }
        } else {
            if (obj instanceof AllExpression) {
                throw new ToBeRemovedException();
            }
            if (obj instanceof com.prelytis.dashboard.value.util.Expression) {
                this.fill(l, this.helper.evaluateExpression((com.prelytis.dashboard.value.util.Expression)obj, this.context.getData()));
            } else {
                if (obj instanceof String && "*".equals(obj)) {
                    throw new ToBeRemovedException();
                }
                l.add(obj);
            }
        }
    }
}

