/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.ds;

import com.prelytis.dashboard.dao.value.DbJdbcDriverFunctionMapping;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.engine.ds.TempField;
import com.prelytis.dashboard.data.engine.ds.TempFieldConstant;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.DataExpressionParser;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanSQLFctImplDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.Operand;
import java.util.ArrayList;
import org.apache.log4j.LogManager;

public class CommandTempField {
    private EngineDS mediator;
    private DataExpressionParser parser = DataExpressionParser.getInstance();

    public CommandTempField(EngineDS mediator) {
        this.mediator = mediator;
    }

    TempField getTempField(String fieldName) throws DashboardException {
        AbstractBeanReportAvlField avlField = this.mediator.getAvlField(fieldName);
        if (avlField == null) {
            throw this.mediator.getDashboardException("unknownField", new String[]{fieldName});
        }
        if (avlField instanceof BeanReportAvlCalcField) {
            return this.getTempField(fieldName, ((BeanReportAvlCalcField)avlField).getOperand());
        }
        if (avlField instanceof BeanReportAvlField) {
            return this.mediator.getTempField((BeanReportAvlField)avlField);
        }
        throw this.mediator.getDashboardException("unknownFieldType", null);
    }

    TempField getTempField(Operand operand) throws DashboardException {
        if (operand instanceof FieldOperand) {
            return this.getTempField((FieldOperand)operand);
        }
        if (operand instanceof ConstantOperand) {
            return this.getTempField((ConstantOperand)operand);
        }
        if (operand instanceof CalcFunctionOperand) {
            return this.getTempField("unknown", (CalcFunctionOperand)operand);
        }
        throw this.mediator.getDashboardException("notImplemented", null);
    }

    TempField getTempField(FieldOperand operand) throws DashboardException {
        return this.getTempField(operand.getField());
    }

    TempFieldConstant getTempField(ConstantOperand operand) throws DashboardException {
        TempFieldConstant tfc = new TempFieldConstant();
        tfc.setConstant(this.mediator.getValue(operand.getValue()));
        tfc.setDatatype(operand.getDataType());
        return tfc;
    }

    TempField getTempField(String fieldName, CalcFunctionOperand function) throws DashboardException {
        DbJdbcDriverFunctionMapping mapping = this.mediator.getSqlFunctionMapping(function.getSQLFunctionOID());
        if (mapping == null) {
            LogManager.getLogger(this.getClass()).warn((Object)("No mapping defined for function " + function.getSQLFunctionOID()));
            throw this.mediator.getDashboardException("notImplemented", null);
        }
        BeanSQLFunctionDefinition fct = mapping.getFunction();
        BeanSQLFctImplDefinition impl = mapping.getImplementation();
        boolean isSql = true;
        ArrayList<TempField> fieldList = new ArrayList<TempField>();
        for (IOperandGroup group : function.getOperandGroups()) {
            for (IOperandGroupElement element : group.getElementList()) {
                for (ICalculatedOperand child : element.getOperands()) {
                    TempField field = this.getTempField(fieldName, child);
                    isSql = isSql && this.mediator.isSql(field);
                    fieldList.add(field);
                }
            }
        }
        if (isSql) {
            return this.mediator.getTempFieldSql(function, fct, impl, fieldList);
        }
        LogManager.getLogger(this.getClass()).warn((Object)("No implementation declared for " + (fct == null ? "?" : fct.getName())));
        throw this.mediator.getDashboardException("notImplemented", null);
    }

    private TempField getTempField(String fieldName, ICalculatedOperand calulatedOperand) throws DashboardException {
        Operand operand = calulatedOperand.getOperand();
        if (operand instanceof ConstantOperand) {
            ConstantOperand constant = (ConstantOperand)operand;
            TempFieldConstant resu = new TempFieldConstant();
            resu.setConstant(this.mediator.getValue(constant.getValue()));
            resu.setDatatype(constant.getDataType());
            return resu;
        }
        if (operand instanceof FieldOperand) {
            FieldOperand field = (FieldOperand)operand;
            AbstractBeanReportAvlField avlField = this.mediator.getAvlField(field.getField());
            if (avlField == null) {
                throw this.mediator.getDashboardException("unknownFieldInCalcField", new String[]{field.getField(), fieldName});
            }
            if (avlField instanceof BeanReportAvlCalcField) {
                ICalculatedOperand op = ((BeanReportAvlCalcField)avlField).getOperand();
                return this.getTempField(fieldName, op);
            }
            if (avlField instanceof BeanReportAvlField) {
                return this.mediator.getTempField((BeanReportAvlField)avlField);
            }
            throw this.mediator.getDashboardException("unknownFieldInCalcField", new String[]{"?", fieldName});
        }
        if (operand instanceof CalcFunctionOperand) {
            return this.getTempField(fieldName, (CalcFunctionOperand)operand);
        }
        throw this.mediator.getDashboardException("unknownOperand", null);
    }
}

