/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.ds;

import com.prelytis.dashboard.dao.value.DbJdbcDriverFunctionMapping;
import com.prelytis.dashboard.data.engine.AbstractEngine;
import com.prelytis.dashboard.data.engine.CommandExpression;
import com.prelytis.dashboard.data.engine.CommandParameter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.SortField;
import com.prelytis.dashboard.data.engine.SqlString;
import com.prelytis.dashboard.data.engine.ds.CommandQuery;
import com.prelytis.dashboard.data.engine.ds.CommandTempField;
import com.prelytis.dashboard.data.engine.ds.TempField;
import com.prelytis.dashboard.data.engine.ds.TempFieldColumn;
import com.prelytis.dashboard.data.engine.ds.TempFieldConstant;
import com.prelytis.dashboard.data.engine.ds.TempFieldSql;
import com.prelytis.dashboard.data.engine.ds.TempFieldType;
import com.prelytis.dashboard.data.engine.ds.ToBeRemovedException;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.Column;
import com.prelytis.dashboard.db.operation.ColumnAverage;
import com.prelytis.dashboard.db.operation.ColumnCalculated;
import com.prelytis.dashboard.db.operation.ColumnConstant;
import com.prelytis.dashboard.db.operation.ColumnMedian;
import com.prelytis.dashboard.db.operation.ColumnSimple;
import com.prelytis.dashboard.db.operation.ColumnStdDev;
import com.prelytis.dashboard.db.operation.ColumnVariance;
import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationAgregate;
import com.prelytis.dashboard.db.operation.OperationCalculate;
import com.prelytis.dashboard.db.operation.OperationFilter;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operator.AgregationOnColumn;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanSQLFctImplDefinition;
import com.prelytis.dashboard.value.data.BeanSQLFunctionDefinition;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.SortOrder;
import com.prelytis.dashboard.value.query.BooleanExpression;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.ComparisonExpression;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineDS
extends AbstractEngine {
    private Map<Field, PosAgreg> fieldPosition;
    private LogicalExpression topExpression;
    private ColumnCalculated filter;
    private List<Column> columns = new ArrayList<Column>();
    private List<AgregationOnColumn> agregations = new ArrayList<AgregationOnColumn>();
    private CommandQuery commandQuery;
    private CommandParameter commandParameter;
    private CommandTempField commandTempField;
    private CommandExpression commandExpression;

    private EngineDS(ExecutionContext context, CommandParameter cp, BeanQueryDataStructureTable table) {
        super(context);
        this.fieldPosition = new HashMap<Field, PosAgreg>();
        this.commandParameter = cp;
        this.commandQuery = CommandQuery.getInstance(this, context, table);
        this.commandTempField = new CommandTempField(this);
        this.commandExpression = new CommandExpression(context);
    }

    private int addField(Field field) throws DashboardException {
        PosAgreg posInResult = this.fieldPosition.get(field);
        if (posInResult == null) {
            TempField tf = this.commandTempField.getTempField(field.getName());
            if (tf.getType() == TempFieldType.CONSTANT) {
                TempFieldConstant tfc = (TempFieldConstant)tf;
                SqlString s = new SqlString();
                s.setSql("?");
                s.getParameterList().add(tfc.getConstant());
                TempFieldSql sql = new TempFieldSql();
                sql.setAgregated(false);
                sql.setDatatype(tfc.getDatatype());
                sql.setGroupByList(new ArrayList<SqlString>());
                sql.setSql(s);
                tf = sql;
            }
            switch (tf.getType()) {
                case COLUMN: {
                    TempFieldColumn tfC = (TempFieldColumn)tf;
                    posInResult = new PosAgreg(this.columns.size(), field.getAgregation());
                    this.fieldPosition.put(field, posInResult);
                    this.columns.add(tfC.getColumn());
                    break;
                }
                case CONSTANT: {
                    TempFieldConstant tfc = (TempFieldConstant)tf;
                    posInResult = new PosAgreg(this.columns.size(), field.getAgregation());
                    this.fieldPosition.put(field, posInResult);
                    ColumnConstant cc = new ColumnConstant();
                    cc.setValue(tfc.getConstant());
                    this.columns.add((Column)cc);
                    break;
                }
                case SQL: {
                    TempFieldSql tfs = (TempFieldSql)tf;
                    posInResult = new PosAgreg(this.addColumn(field, tfs), FieldAgregation.AGREGATION_NONE);
                }
            }
        }
        AgregationOnColumn ag = new AgregationOnColumn(posInResult.agregation, posInResult.position);
        Integer pos = this.agregations.size();
        this.agregations.add(ag);
        return pos;
    }

    @Override
    public Operation getOperation() throws DashboardException {
        if (this.getFieldList() == null || this.getFieldList().isEmpty()) {
            throw this.getDashboardException("emptyFieldList", null);
        }
        for (Field field : this.getFieldList()) {
            this.addField(field);
        }
        if (this.getSortFieldList() != null) {
            for (SortField sortField : this.getSortFieldList()) {
                this.addSort(sortField.getField(), sortField.getSortOrder());
            }
        }
        TempField tempField = null;
        TempFieldSql queryFilter = null;
        try {
            queryFilter = this.commandQuery.getQueryFilter();
        }
        catch (ToBeRemovedException toBeRemovedException) {
            // empty catch block
        }
        if (this.topExpression != null) {
            Expression exp = this.commandExpression.getExpression((Expression)this.topExpression);
            try {
                tempField = this.getTempFilter(exp);
            }
            catch (ToBeRemovedException e) {
                log.debug((Object)"top ToBeRemovedException, no filter applied");
            }
        }
        this.commandQuery.updateQuery(queryFilter, tempField);
        if (this.shouldClearGroupBy()) {
            this.commandQuery.clearGroupByCollection();
        }
        QuerySQL querySQL = this.commandQuery.getQuerySQL();
        OperationSelect select = new OperationSelect();
        BeanWorldDefinition world = this.getContext().getWorld();
        if (!world.isUseDefault()) {
            select.setResultSetConcurrency(Integer.valueOf(world.getResultSetConcurrency()));
            select.setResultSetType(Integer.valueOf(world.getResultSetType()));
            select.setFetchSize(Integer.valueOf(world.getFetchSize()));
        }
        WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)this.getContext().getWorld(), (DriverCharacteristics)this.getContext().getDriver(), (ExpressionEvaluationData)this.getContext().getData());
        ConnectionHelper helper = ConnectionHelper.getInstance((WorldHelper)worldHelper);
        select.setDatabase(helper.getPoolDbInfo());
        select.setQuerySQL(querySQL);
        OperationSelect operation = select;
        OperationCalculate calculate = new OperationCalculate();
        calculate.setColumnList(this.columns);
        calculate.setOperation((Operation)operation);
        operation = calculate;
        if (this.filter != null) {
            OperationFilter filter = new OperationFilter();
            filter.setCalculation(this.filter);
            filter.setOperation((Operation)operation);
            operation = filter;
        }
        boolean agregationNeeded = false;
        boolean colOrderNeeded = false;
        ArrayList<ColumnSimple> colOrderList = new ArrayList<ColumnSimple>();
        int col = 0;
        for (AgregationOnColumn aoc : this.agregations) {
            if (aoc.getAgregation() != FieldAgregation.AGREGATION_NONE) {
                agregationNeeded = true;
                break;
            }
            if (aoc.getCol() != col) {
                colOrderNeeded = true;
            }
            ColumnSimple cs = new ColumnSimple();
            cs.setCol(aoc.getCol());
            colOrderList.add(cs);
            ++col;
        }
        if (agregationNeeded) {
            OperationAgregate agregate = new OperationAgregate();
            agregate.setAgregationList(this.agregations);
            agregate.setOperation((Operation)operation);
            operation = agregate;
        } else if (colOrderNeeded) {
            OperationCalculate colOrder = new OperationCalculate();
            colOrder.setColumnList(colOrderList);
            colOrder.setOperation((Operation)operation);
            operation = colOrder;
        }
        return operation;
    }

    protected boolean shouldClearGroupBy() {
        if (this.getForceGroupBy() || this.getFieldList() == null) {
            return false;
        }
        for (Field field : this.getFieldList()) {
            if (field.getAgregation() == FieldAgregation.AGREGATION_NONE) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setFilter(Expression expression) throws DashboardException {
        if (expression == null) {
            return;
        }
        if (this.topExpression == null) {
            this.topExpression = new LogicalExpression();
            this.topExpression.setOperator(1);
        }
        this.topExpression.getExpressionList().add(expression);
    }

    @Override
    public void setFilter(List<AbstractBeanReportFilter> reportFilterList) throws DashboardException {
        if (reportFilterList != null && !reportFilterList.isEmpty()) {
            throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
        }
    }

    private int addSort(Field field, SortOrder sortOrder) throws DashboardException {
        PosAgreg pos = this.fieldPosition.get(field);
        if (pos == null) {
            throw this.getDashboardException("unknownFieldSort", new String[]{field.getName()});
        }
        this.addSort("C" + pos.position, sortOrder == SortOrder.SORT_ASCENDING);
        return 0;
    }

    private int addColumn(Field field, TempFieldSql tfs) {
        int posInResult = this.columns.size();
        this.fieldPosition.put(field, new PosAgreg(posInResult, FieldAgregation.AGREGATION_NONE));
        FieldAgregation agregation = field.getAgregation();
        if (tfs.isAgregated()) {
            agregation = FieldAgregation.AGREGATION_NONE;
        }
        SqlString sql = tfs.getSql();
        DataType datatype = tfs.getDatatype();
        Collection<SqlString> groupByList = tfs.getGroupByList();
        switch (agregation) {
            case AGREGATION_AVERAGE: {
                Integer sumPos = this.addField(this.getSqlString("SUM(", sql, ")", field.isDistinctValues()), datatype);
                Integer countPos = this.addField(this.getSqlString("COUNT(", sql, ")", field.isDistinctValues()), DataType.INTEGER);
                ColumnAverage avgCol = new ColumnAverage();
                avgCol.setCountCol(countPos.intValue());
                avgCol.setSumCol(sumPos.intValue());
                this.columns.add((Column)avgCol);
                break;
            }
            case AGREGATION_COUNT: {
                Integer countPos = this.addField(this.getSqlString("COUNT(", sql, ")", field.isDistinctValues()), DataType.INTEGER);
                ColumnSimple countCol = new ColumnSimple();
                countCol.setCol(countPos.intValue());
                this.columns.add((Column)countCol);
                break;
            }
            case AGREGATION_MAX: {
                Integer maxPos = this.addField(this.getSqlString("MAX(", sql, ")", field.isDistinctValues()), datatype);
                ColumnSimple maxCol = new ColumnSimple();
                maxCol.setCol(maxPos.intValue());
                this.columns.add((Column)maxCol);
                break;
            }
            case AGREGATION_MEDIAN: {
                Integer minPos = this.addField(this.getSqlString("MIN(", sql, ")", field.isDistinctValues()), datatype);
                Integer maxPos = this.addField(this.getSqlString("MAX(", sql, ")", field.isDistinctValues()), datatype);
                ColumnMedian medianCol = new ColumnMedian();
                medianCol.setMaxCol(maxPos.intValue());
                medianCol.setMinCol(minPos.intValue());
                this.columns.add((Column)medianCol);
                break;
            }
            case AGREGATION_MIN: {
                Integer minPos = this.addField(this.getSqlString("MIN(", sql, ")", field.isDistinctValues()), datatype);
                ColumnSimple minCol = new ColumnSimple();
                minCol.setCol(minPos.intValue());
                this.columns.add((Column)minCol);
                break;
            }
            case AGREGATION_NONE: {
                Integer nonePos = this.addField(sql, datatype);
                if (groupByList != null) {
                    this.addGroupBy(groupByList);
                }
                ColumnSimple noneCol = new ColumnSimple();
                noneCol.setCol(nonePos.intValue());
                this.columns.add((Column)noneCol);
                break;
            }
            case AGREGATION_STANDARD_DEVIATION: {
                Integer countPos = this.addField(this.getSqlString("COUNT(", sql, ")", field.isDistinctValues()), DataType.INTEGER);
                Integer sumPos = this.addField(this.getSqlString("SUM(", sql, ")", field.isDistinctValues()), datatype);
                Integer sumSquarePos = this.addField(this.getSqlString("SUM((", sql, ")*(", "))"), datatype);
                ColumnStdDev stdDevCol = new ColumnStdDev();
                stdDevCol.setCountCol(countPos.intValue());
                stdDevCol.setSumCol(sumPos.intValue());
                stdDevCol.setSumSquareCol(sumSquarePos.intValue());
                this.columns.add((Column)stdDevCol);
                break;
            }
            case AGREGATION_SUM: {
                Integer sumPos = this.addField(this.getSqlString("SUM(", sql, ")", field.isDistinctValues()), datatype);
                ColumnSimple sumCol = new ColumnSimple();
                sumCol.setCol(sumPos.intValue());
                this.columns.add((Column)sumCol);
                break;
            }
            case AGREGATION_SUM_SQUARRED: {
                Integer sumSquarePos = this.addField(this.getSqlString("SUM((", sql, ")*(", "))"), datatype);
                ColumnSimple sumCol = new ColumnSimple();
                sumCol.setCol(sumSquarePos.intValue());
                this.columns.add((Column)sumCol);
                break;
            }
            case AGREGATION_VARIANCE: {
                Integer countPos = this.addField(this.getSqlString("COUNT(", sql, ")", field.isDistinctValues()), DataType.INTEGER);
                Integer sumPos = this.addField(this.getSqlString("SUM(", sql, ")", field.isDistinctValues()), datatype);
                Integer sumSquarePos = this.addField(this.getSqlString("SUM((", sql, ")*(", "))"), datatype);
                ColumnVariance stdVariance = new ColumnVariance();
                stdVariance.setCountCol(countPos.intValue());
                stdVariance.setSumCol(sumPos.intValue());
                stdVariance.setSumSquareCol(sumSquarePos.intValue());
                this.columns.add((Column)stdVariance);
            }
        }
        return posInResult;
    }

    private SqlString getSqlString(String prefix, SqlString sql, String suffix, boolean distinct) {
        ArrayList<Value> parameterList = new ArrayList<Value>();
        for (Value value : sql.getParameterList()) {
            parameterList.add(value);
        }
        SqlString s = new SqlString();
        s.getParameterList().addAll(parameterList);
        s.setSql(new StringBuffer().append(prefix).append(distinct ? "DISTINCT " : "").append(sql.getSql()).append(suffix).toString());
        return s;
    }

    private SqlString getSqlString(String prefix, SqlString sql, String mid, String suffix) {
        ArrayList<Value> parameterList = new ArrayList<Value>();
        for (Value value : sql.getParameterList()) {
            parameterList.add(value);
        }
        SqlString s = new SqlString();
        s.getParameterList().addAll(parameterList);
        s.setSql(new StringBuffer().append(prefix).append(sql.getSql()).append(mid).append(sql.getSql()).append(suffix).toString());
        return s;
    }

    private TempField getTempFilter(Expression exp) throws DashboardException {
        if (exp == null) {
            return null;
        }
        if (exp instanceof LogicalExpression) {
            return this.getLogicalTempField((LogicalExpression)exp);
        }
        if (exp instanceof ComparisonExpression) {
            return this.getComparisonTempField((ComparisonExpression)exp);
        }
        if (exp instanceof BooleanExpression) {
            return this.commandTempField.getTempField(((BooleanExpression)exp).getOperand());
        }
        throw this.getDashboardException("unknownExpression", null);
    }

    private TempField getLogicalTempField(LogicalExpression source) throws DashboardException {
        int nbExc = 0;
        boolean isSql = true;
        ArrayList<TempField> fieldList = new ArrayList<TempField>();
        for (Expression e : source.getExpressionList()) {
            try {
                TempField field = this.getTempFilter(e);
                isSql = isSql && this.isSql(field);
                fieldList.add(field);
            }
            catch (ToBeRemovedException ex) {
                if (source.getOperator() == 2) {
                    throw new ToBeRemovedException();
                }
                ++nbExc;
            }
        }
        if (nbExc == source.getExpressionList().size()) {
            throw new ToBeRemovedException();
        }
        if (isSql) {
            String operator = source.getOperator() == 1 ? " AND " : " OR ";
            return this.commandQuery.getLogicalSqlTempField(fieldList, operator);
        }
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    private TempField getComparisonTempField(ComparisonExpression srcCompExp) throws DashboardException {
        TempField leftField = this.getTempField((FieldOperand)srcCompExp.getLeftOperand());
        boolean isSql = this.isSql(leftField);
        Operand rightOperand = srcCompExp.getRightOperand();
        TempField rightField = null;
        if (rightOperand instanceof FieldOperand) {
            rightField = this.getTempField((FieldOperand)rightOperand);
            isSql &= this.isSql(rightField);
        }
        if (isSql) {
            if (rightField != null) {
                return this.commandQuery.getComparisonSqlTempField(leftField, srcCompExp.getOperator(), rightField);
            }
            return this.commandQuery.getComparisonSqlTempField(leftField, srcCompExp.getOperator(), rightOperand, srcCompExp.isSimpleValue());
        }
        throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
    }

    private TempField getTempField(FieldOperand operand) throws DashboardException {
        return this.commandTempField.getTempField(operand);
    }

    DashboardException getDashboardException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    TempFieldConstant getTempField(ConstantOperand operand) throws DashboardException {
        return this.commandTempField.getTempField(operand);
    }

    public AbstractBeanReportAvlField getAvlField(String name) {
        return this.commandParameter.getAvlField(name);
    }

    public BeanQueryDataStructureTableField getTableField(String name) throws DashboardException {
        return this.commandParameter.getTableField(name);
    }

    public DbJdbcDriverFunctionMapping getSqlFunctionMapping(int functionOID) {
        return this.commandParameter.getSqlFunctionMapping(functionOID);
    }

    TempField getTempFieldSql(CalcFunctionOperand function, BeanSQLFunctionDefinition fct, BeanSQLFctImplDefinition impl, List<TempField> fieldList) throws DashboardException {
        return this.commandQuery.getTempFieldSql(function, fct, impl, fieldList);
    }

    public TempField getTempField(BeanReportAvlField avlField) throws DashboardException {
        return this.commandQuery.getTempField(avlField);
    }

    void addSort(String alias, boolean sortOrder) {
        this.commandQuery.addSort(alias, sortOrder);
    }

    Value getValue(Object value) throws DashboardException {
        return this.commandQuery.getValue(value);
    }

    void addGroupBy(Collection<SqlString> groupByList) {
        this.commandQuery.addGroupBy(groupByList);
    }

    Integer addField(SqlString sql, DataType datatype) {
        return this.commandQuery.addField(sql, datatype);
    }

    boolean isSql(TempField field) {
        return this.commandQuery.isSql(field);
    }

    public CommandQuery getCommandQuery() {
        return this.commandQuery;
    }

    public static EngineDS getInstance(ExecutionContext context) {
        BeanQueryStar ds = (BeanQueryStar)context.getQuery();
        return new EngineDS(context, CommandParameter.getInstance(context), ds.getTableFact());
    }

    public static EngineDS getInstance(ExecutionContext context, CommandParameter cp, BeanQueryDataStructureTable table) {
        return new EngineDS(context, cp, table);
    }

    private static class PosAgreg {
        private final int position;
        private final FieldAgregation agregation;

        private PosAgreg(int position, FieldAgregation agregation) {
            this.position = position;
            this.agregation = agregation;
        }
    }
}

