/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.multi;

import com.prelytis.dashboard.data.engine.CommandParameter;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.util.DataType;

public class CommandParameterMulti {
    private final CommandParameter commandParameter;

    private CommandParameterMulti(CommandParameter cp) {
        this.commandParameter = cp;
    }

    public BeanQueryDataStructureTableField addField(String table, String name, String sqlField, DataType dataType) throws DashboardException {
        BeanQueryDataStructureTable dsTable = this.commandParameter.getTable(table);
        BeanQueryDataStructureTableField dsField = new BeanQueryDataStructureTableField();
        dsField.setDataType(dataType);
        dsField.setName(name);
        dsField.setSqlField(sqlField);
        this.commandParameter.add(dsTable, dsField);
        return dsField;
    }

    public AbstractBeanReportAvlField getAvlField(String name) {
        return this.commandParameter.getAvlField(name);
    }

    public BeanQueryDataStructureTableField getTableField(String name, FieldAgregation agregation) throws DashboardException {
        BeanQueryDataStructureTableField field = this.commandParameter.getTableField(name);
        return field;
    }

    public LogicalExpression getQueryFilter() throws DashboardException {
        return this.commandParameter.getQueryFilter();
    }

    public BeanQueryDataStructureTable getTable(String name) throws DashboardException {
        return this.commandParameter.getTable(name);
    }

    public static CommandParameterMulti getInstance(ExecutionContext context) {
        return new CommandParameterMulti(CommandParameter.getInstance(context));
    }
}

