/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.multi;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.EntityDao;
import com.prelytis.dashboard.data.engine.AbstractEngine;
import com.prelytis.dashboard.data.engine.Engine;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.SortField;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.engine.multi.CommandFieldFilter;
import com.prelytis.dashboard.data.engine.multi.EngineWrapper;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationCalculate;
import com.prelytis.dashboard.db.operation.OperationH2;
import com.prelytis.dashboard.db.operation.OperationSort;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.interfaces.SecurityException;
import com.prelytis.dashboard.model.helper.EntityHelper;
import com.prelytis.dashboard.model.helper.QueryHelper;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.QueryDSTableHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableIndex;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureFinal;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableField;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoin;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTableJoinElement;
import com.prelytis.dashboard.value.data.BeanQuerySQLFilter;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.LogicalExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.FieldMetaData;
import com.prelytis.dashboard.value.util.Table;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineMulti
extends AbstractEngine {
    private DaoFactory daoFactory;
    private final Map<Integer, EngineWrapper> engineMap;
    private final CommandFieldFilter commandFieldFilter;
    private ExecutionContext contextH2;
    private Expression expression;
    private List<AbstractBeanReportFilter> filterList;
    private final QueryDSTableHelper queryH2Helper;
    private final BeanQueryDataStructureFinal queryH2;
    private final Map<String, AbstractBeanReportAvlField> fieldMapH2;
    private final Map<Integer, Map<String, ReportFilter>> sqlFilterMap;
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();

    public EngineMulti(DaoFactory daoFactory, ExecutionContext context) {
        super(context);
        this.daoFactory = daoFactory;
        this.engineMap = new HashMap<Integer, EngineWrapper>();
        this.commandFieldFilter = new CommandFieldFilter(this, context);
        BeanQueryDataStructureTable dsTable = new BeanQueryDataStructureTable();
        this.queryH2 = new BeanQueryDataStructureFinal();
        this.queryH2.setMaxLines(context.getQuery().getMaxLines());
        this.queryH2.setTableFact(dsTable);
        this.queryH2Helper = new QueryDSTableHelper((BeanQueryStar)this.queryH2, context.getData().getLocale());
        this.fieldMapH2 = new HashMap<String, AbstractBeanReportAvlField>();
        this.sqlFilterMap = new HashMap<Integer, Map<String, ReportFilter>>();
        for (BeanQuerySQLFilter filter : this.getContext().getQuery().getBeanQuerySQLFilterList()) {
            Map<String, ReportFilter> list = this.sqlFilterMap.get(filter.getTableId());
            if (list == null) {
                list = new HashMap<String, ReportFilter>();
                this.sqlFilterMap.put(filter.getTableId(), list);
            }
            ReportFilter f = this.getContext().getFilterMap() == null ? null : this.getContext().getFilterMap().get(filter.getName());
            ReportFilter flt = new ReportFilter();
            flt.setName(filter.getSql());
            flt.setDatatype(filter.getDataType());
            if (f != null) {
                flt.setValue(f.getValue());
            } else {
                flt.setValue(filter.getDefaultValue());
            }
            list.put(flt.getName(), flt);
        }
    }

    @Override
    public Operation getOperation() throws DashboardException {
        int cpt = 0;
        if (this.getFieldList() != null) {
            for (Field field : this.getFieldList()) {
                this.commandFieldFilter.addField(field);
                ++cpt;
            }
        }
        ArrayList<SortColumn> scl = null;
        if (this.getSortFieldList() != null) {
            scl = new ArrayList<SortColumn>();
            for (SortField sortField : this.getSortFieldList()) {
                this.commandFieldFilter.addField(sortField.getField());
                SortColumn sc = new SortColumn();
                sc.setCol(cpt);
                sc.setSortOrder(sortField.getSortOrder());
                scl.add(sc);
                ++cpt;
            }
        }
        this.commandFieldFilter.setFilter(this.expression);
        this.commandFieldFilter.init();
        this.contextH2.setQuery((IQueryDefinition)this.queryH2);
        this.contextH2.setFieldMap(this.fieldMapH2);
        EngineDS engineDS = EngineDS.getInstance(this.contextH2);
        engineDS.setForceGroupBy(this.getForceGroupBy());
        engineDS.setFieldList(this.commandFieldFilter.getFieldListH2());
        engineDS.setFilter(this.commandFieldFilter.getExpressionH2());
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        ArrayList<SQLTable> tableList = new ArrayList<SQLTable>();
        for (Map.Entry<Integer, EngineWrapper> entry : this.engineMap.entrySet()) {
            EngineWrapper engine = entry.getValue();
            Engine e = engine.getEngine();
            e.setFieldList(engine.getFieldSet().keySet());
            e.setFilter((Expression)engine.getExpression());
            operationList.add(e.getOperation());
            SQLTable table = new SQLTable();
            table.setName(entry.getValue().getDsTable().getName());
            List fieldList = table.getFieldList();
            for (FieldMetaData fmd : engine.getFieldSet().values()) {
                fieldList.add(fmd);
            }
            tableList.add(table);
        }
        OperationH2 operationH2 = new OperationH2();
        operationH2.setOperationList(operationList);
        operationH2.setTableList(tableList);
        operationH2.setResult(engineDS.getOperation());
        ArrayList<SQLTableIndex> indexList = new ArrayList<SQLTableIndex>();
        this.fill(indexList, this.queryH2.getTableFact(), 1);
        operationH2.setIndexList(indexList);
        OperationCalculate oc = new OperationCalculate();
        oc.setColumnList(this.commandFieldFilter.getColumnList());
        oc.setOperation((Operation)operationH2);
        if (this.getSortFieldList() == null || this.getSortFieldList().isEmpty()) {
            return oc;
        }
        OperationSort os = new OperationSort();
        os.setCollator(Collator.getInstance());
        os.setColumnList(scl);
        os.setOperation((Operation)oc);
        return os;
    }

    private int fill(List<SQLTableIndex> indexList, BeanQueryDataStructureTable table, int cpt) {
        BeanQueryDataStructureTableJoin join = table.getJoin();
        if (join.getJoinElementList() != null && !join.getJoinElementList().isEmpty()) {
            SQLTableIndex pki = new SQLTableIndex();
            pki.setName("pk_" + cpt);
            pki.setTable(table.getTable().getName());
            SQLTableIndex fki = new SQLTableIndex();
            fki.setName("fk_" + cpt);
            fki.setTable(table.getParentTable().getTable().getName());
            List pk = pki.getFieldList();
            List fk = fki.getFieldList();
            for (BeanQueryDataStructureTableJoinElement elt : join.getJoinElementList()) {
                fk.add(elt.getLeftField());
                pk.add(elt.getRightField());
            }
            indexList.add(pki);
            indexList.add(fki);
        }
        for (BeanQueryDataStructureTable c : table.getTableChildList()) {
            cpt = this.fill(indexList, c, cpt + 1);
        }
        return cpt;
    }

    @Override
    public void setFilter(Expression expression) throws DashboardException {
        this.expression = expression;
    }

    @Override
    public void setFilter(List<AbstractBeanReportFilter> reportFilterList) throws DashboardException {
        this.filterList = reportFilterList;
    }

    public ExecutionContext getContextH2() {
        return this.contextH2;
    }

    public void setContextH2(ExecutionContext contextH2) {
        this.contextH2 = contextH2;
    }

    EngineWrapper getEngine(BeanQueryDataStructureTable dsTable) throws DashboardException {
        Integer tableId = dsTable.getId();
        EngineWrapper engineWrapper = this.engineMap.get(tableId);
        if (engineWrapper != null) {
            return engineWrapper;
        }
        EngineHelper helper = EngineHelper.getInstance(this.daoFactory);
        QueryHelper queryHelper = QueryHelper.getInstance(this.daoFactory);
        IQueryDefinition query = queryHelper.getFinal(dsTable.getName());
        EntityHelper entityHelper = EntityHelper.getInstance(this.daoFactory);
        EntityDao.Relation relation = entityHelper.getRelation(this.getContext().getQuery().getOwnerEntOID(), query.getOwnerEntOID());
        if (relation != EntityDao.Relation.SAME && relation != EntityDao.Relation.PARENT) {
            StringBuffer sb = new StringBuffer();
            sb.append("Cannot use query '").append(query.getName()).append("' in query '").append(this.getContext().getQuery().getName()).append("' (see entity rules))");
            throw new SecurityException(sb.toString());
        }
        Map<String, ReportFilter> filterMap = this.sqlFilterMap.get(tableId);
        Engine engine = helper.getEngine(query, this.getContext().getData(), filterMap, true);
        if (engine instanceof EngineDS) {
            LogicalExpression e = new LogicalExpression();
            e.setOperator(1);
            engine.setFilter((Expression)e);
        }
        if (engine instanceof AbstractEngine) {
            ((AbstractEngine)engine).setForceGroupBy(this.getForceGroupBy());
        }
        engineWrapper = new EngineWrapper(this);
        engineWrapper.setEngine(engine);
        this.engineMap.put(dsTable.getId(), engineWrapper);
        Table t = new Table();
        t.setName(dsTable.getName());
        if (dsTable.getParentTable() != null) {
            EngineWrapper parentEngine = this.getEngine(dsTable.getParentTable());
            BeanQueryDataStructureTable tableH2 = this.queryH2Helper.addTable(parentEngine.getDsTable(), t);
            engineWrapper.setDsTable(tableH2);
            BeanQueryDataStructureTableJoin join = dsTable.getJoin();
            BeanQueryDataStructureTableJoin joinH2 = tableH2.getJoin();
            joinH2.setJoinType(join.getJoinType());
            for (BeanQueryDataStructureTableJoinElement joinElt : join.getJoinElementList()) {
                BeanQueryDataStructureTableField leftField = this.getField(dsTable.getParentTable(), joinElt.getLeftField());
                parentEngine.addField(leftField.getName(), FieldAgregation.AGREGATION_NONE, leftField);
                BeanQueryDataStructureTableField rightField = this.getField(dsTable, joinElt.getRightField());
                engineWrapper.addField(rightField.getName(), FieldAgregation.AGREGATION_NONE, rightField);
                BeanQueryDataStructureTableJoinElement joinEltH2 = new BeanQueryDataStructureTableJoinElement();
                joinEltH2.setLeftField(leftField.getSqlField());
                joinEltH2.setRightField(rightField.getSqlField());
                joinH2.getJoinElementList().add(joinEltH2);
            }
        } else {
            BeanQueryDataStructureTable tableH2 = this.queryH2Helper.addTable(null, t);
            engineWrapper.setDsTable(tableH2);
        }
        return engineWrapper;
    }

    private BeanQueryDataStructureTableField getField(BeanQueryDataStructureTable dsTable, String fieldname) {
        for (BeanQueryDataStructureTableField field : dsTable.getTableFieldList()) {
            if (!field.getSqlField().equals(fieldname)) continue;
            return field;
        }
        return null;
    }

    void addFieldH2(BeanQueryDataStructureTable dsTable, String sqlField, String name, FieldAgregation agregation, String descriptionKey, int sqlType, DateTruncation dt, String fieldGroupName, boolean active, int size, int digits, boolean nullable) {
        this.queryH2Helper.addField(dsTable, sqlField, name, descriptionKey, sqlType, dt, fieldGroupName, active, size, digits, nullable);
    }

    void addFieldH2(BeanQueryDataStructureTable dsTable, String sqlField, String name, FieldAgregation agregation, String descriptionKey, DataType dataType, DateTruncation dt, String fieldGroupName, boolean active, int size, int digits, boolean nullable) {
        this.queryH2Helper.addField(dsTable, sqlField, name, descriptionKey, dataType, dt, fieldGroupName, active, size, digits, nullable);
    }

    String getName(String name, FieldAgregation agregation) {
        return agregation == FieldAgregation.AGREGATION_NONE ? name : name + "_" + agregation;
    }

    void addAvlFieldH2(String name, FieldAgregation agregation, AbstractBeanReportAvlField avlField) {
        this.fieldMapH2.put(this.getName(name, agregation), avlField);
    }

    EngineWrapper getEngine(String dsTableName) throws DashboardException {
        return this.getEngine(this.commandFieldFilter.getTable(dsTableName));
    }

    Object getValue(Object value) throws DashboardException {
        if (value instanceof com.prelytis.dashboard.value.util.Expression) {
            return Value.valueOf((Object)this.helper.evaluateExpression((com.prelytis.dashboard.value.util.Expression)value, this.getContext().getData(), this.getContext().getFilterMap()));
        }
        return value;
    }
}

