/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.sql;

import com.prelytis.dashboard.data.engine.AbstractEngine;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.Field;
import com.prelytis.dashboard.data.engine.SortField;
import com.prelytis.dashboard.data.helper.QuerySQLHelper;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operation.Column;
import com.prelytis.dashboard.db.operation.ColumnCalculated;
import com.prelytis.dashboard.db.operation.ColumnCalculatedParameter;
import com.prelytis.dashboard.db.operation.ColumnConstant;
import com.prelytis.dashboard.db.operation.ColumnSimple;
import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationAgregate;
import com.prelytis.dashboard.db.operation.OperationCalculate;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operation.OperationSort;
import com.prelytis.dashboard.db.operation.SortColumn;
import com.prelytis.dashboard.db.operator.AgregationOnColumn;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.value.data.AbstractBeanReportAvlField;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanReportAvlCalcField;
import com.prelytis.dashboard.value.data.BeanReportAvlField;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.data.FieldAgregation;
import com.prelytis.dashboard.value.query.CalcFunctionOperand;
import com.prelytis.dashboard.value.query.ConstantOperand;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.query.FieldOperand;
import com.prelytis.dashboard.value.query.ICalculatedOperand;
import com.prelytis.dashboard.value.query.IOperandGroup;
import com.prelytis.dashboard.value.query.IOperandGroupElement;
import com.prelytis.dashboard.value.query.Operand;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.IPoolDBInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EngineSql
extends AbstractEngine {
    private Map<String, AbstractBeanReportAvlField> fieldMap;
    private Map<String, Integer> queryFieldPosition;
    private List<Column> columns;
    private List<AgregationOnColumn> agregations;
    private List<AbstractBeanReportFilter> reportFilterList;
    private List<SortColumn> sortList;

    public EngineSql(ExecutionContext context) {
        super(context);
        this.fieldMap = context.getFieldMap();
        this.columns = new ArrayList<Column>();
        this.agregations = new ArrayList<AgregationOnColumn>();
        this.queryFieldPosition = new HashMap<String, Integer>();
        this.sortList = new ArrayList<SortColumn>();
    }

    private int addField(Field field) throws DashboardException {
        int posInResult;
        AbstractBeanReportAvlField avlField = this.fieldMap.get(field.getName());
        if (avlField instanceof BeanReportAvlCalcField) {
            ICalculatedOperand operand = ((BeanReportAvlCalcField)avlField).getOperand();
            posInResult = this.columns.size();
            this.columns.add(this.getColumn(field.getName(), operand));
        } else if (avlField instanceof BeanReportAvlField) {
            Integer posInQuery = this.getPositionInQuery((BeanReportAvlField)avlField);
            posInResult = this.columns.size();
            this.columns.add(this.getColumnSimple(posInQuery));
        } else {
            throw this.getDashboardException("unsupportedFieldInCalcField", new String[]{field.getName()});
        }
        AgregationOnColumn ag = new AgregationOnColumn(field.getAgregation(), posInResult);
        this.agregations.add(ag);
        return posInResult;
    }

    @Override
    public Operation getOperation() throws DashboardException {
        BeanQuerySQL query = (BeanQuerySQL)this.getContext().getQuery();
        int pos = 0;
        for (BeanQuerySQLField beanQuerySQLField : query.getBeanQuerySQLFieldList()) {
            this.queryFieldPosition.put(beanQuerySQLField.getName(), pos);
            ++pos;
        }
        for (Field field : this.getFieldList()) {
            this.addField(field);
        }
        if (this.getSortFieldList() != null) {
            for (SortField sortField : this.getSortFieldList()) {
                int col = this.addField(sortField.getField());
                SortColumn sort = new SortColumn();
                sort.setCol(col);
                sort.setSortOrder(sortField.getSortOrder());
                this.sortList.add(sort);
            }
        }
        OperationSelect select = new OperationSelect();
        BeanWorldDefinition beanWorldDefinition = this.getContext().getWorld();
        if (!beanWorldDefinition.isUseDefault()) {
            select.setResultSetConcurrency(Integer.valueOf(beanWorldDefinition.getResultSetConcurrency()));
            select.setResultSetType(Integer.valueOf(beanWorldDefinition.getResultSetType()));
            select.setFetchSize(Integer.valueOf(beanWorldDefinition.getFetchSize()));
        }
        select.setDatabase(this.getDatabase());
        select.setQuerySQL(this.getQuerySql());
        OperationSelect operation = select;
        OperationCalculate calculate = new OperationCalculate();
        calculate.setColumnList(this.columns);
        calculate.setOperation((Operation)operation);
        operation = calculate;
        boolean agregationNeeded = false;
        for (AgregationOnColumn aoc : this.agregations) {
            if (aoc.getAgregation() == FieldAgregation.AGREGATION_NONE) continue;
            agregationNeeded = true;
            break;
        }
        if (agregationNeeded) {
            OperationAgregate agregate = new OperationAgregate();
            agregate.setAgregationList(this.agregations);
            agregate.setOperation((Operation)operation);
            operation = agregate;
        }
        if (!this.sortList.isEmpty()) {
            OperationSort sort = new OperationSort();
            Locale locale = this.getContext().getData().getLocale();
            Collator collator = Collator.getInstance(locale);
            sort.setCollator(collator);
            sort.setColumnList(this.sortList);
            sort.setOperation((Operation)operation);
            operation = sort;
        }
        return operation;
    }

    @Override
    public void setFilter(Expression expression) throws DashboardException {
        if (expression != null) {
            throw new DashboardRuntimeException(ErrorCode.NOT_IMPLEMENTED);
        }
    }

    @Override
    public void setFilter(List<AbstractBeanReportFilter> reportFilterList) throws DashboardException {
        this.reportFilterList = reportFilterList;
    }

    private Column getColumn(String fieldName, ICalculatedOperand op) throws DashboardException {
        Operand operand = op.getOperand();
        if (operand instanceof ConstantOperand) {
            return this.getColumnConstant((ConstantOperand)operand);
        }
        if (operand instanceof CalcFunctionOperand) {
            CalcFunctionOperand function = (CalcFunctionOperand)operand;
            ArrayList<ColumnCalculatedParameter> parameterList = new ArrayList<ColumnCalculatedParameter>();
            int groupNum = 0;
            for (IOperandGroup group : function.getOperandGroups()) {
                int numInGroupNum = 0;
                for (IOperandGroupElement element : group.getElementList()) {
                    int paramNum = 0;
                    for (ICalculatedOperand calc : element.getOperands()) {
                        Column col = this.getColumn(fieldName, calc);
                        parameterList.add(this.getParameter(groupNum, numInGroupNum, paramNum, col));
                        ++paramNum;
                    }
                    ++numInGroupNum;
                }
                ++groupNum;
            }
            ColumnCalculated col = new ColumnCalculated();
            col.setFunctionOid(function.getSQLFunctionOID());
            col.setParameterList(parameterList);
            return col;
        }
        if (operand instanceof FieldOperand) {
            String avlFieldName = ((FieldOperand)operand).getField();
            AbstractBeanReportAvlField avlField = this.fieldMap.get(avlFieldName);
            if (avlField == null) {
                throw this.getDashboardException("unknownFieldInCalcField", new String[]{avlFieldName, fieldName});
            }
            if (avlField instanceof BeanReportAvlField) {
                Integer pos = this.getPositionInQuery((BeanReportAvlField)avlField);
                return this.getColumnSimple(pos);
            }
            if (avlField instanceof BeanReportAvlCalcField) {
                return this.getColumn(avlFieldName, ((BeanReportAvlCalcField)avlField).getOperand());
            }
            throw this.getDashboardException("unknownFieldInCalcField", new String[]{fieldName});
        }
        throw this.getDashboardException("unknownOperandInCalcField", new String[]{fieldName});
    }

    private ColumnCalculatedParameter getParameter(int groupNum, int numInGroupNum, int paramNum, Column column) {
        ColumnCalculatedParameter parameter = new ColumnCalculatedParameter();
        parameter.setGroupNum(groupNum);
        parameter.setNumInGroupNum(numInGroupNum);
        parameter.setParamNum(paramNum);
        parameter.setColumn(column);
        return parameter;
    }

    private Column getColumnConstant(ConstantOperand operand) {
        ColumnConstant constant = new ColumnConstant();
        constant.setValue(Value.valueOf((Object)operand.getValue()));
        return constant;
    }

    private Column getColumnSimple(int col) {
        ColumnSimple column = new ColumnSimple();
        column.setCol(col);
        return column;
    }

    private Integer getPositionInQuery(BeanReportAvlField avlField) throws DashboardException {
        BeanQuerySQLField queryField = avlField.getField();
        Integer pos = this.queryFieldPosition.get(queryField.getName());
        if (pos == null) {
            throw this.getDashboardException("fieldNotFoundInQuery", new String[]{queryField.getName()});
        }
        return pos;
    }

    private QuerySQL getQuerySql() throws DashboardException {
        QuerySQLHelper helper = new QuerySQLHelper();
        return helper.getQuerySQL(this.getContext(), this.reportFilterList);
    }

    private IPoolDBInfo getDatabase() throws DashboardException {
        ExecutionContext context = this.getContext();
        WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)context.getWorld(), (DriverCharacteristics)context.getDriver(), (ExpressionEvaluationData)context.getData());
        ConnectionHelper helper = ConnectionHelper.getInstance((WorldHelper)worldHelper);
        return helper.getPoolDbInfo();
    }
}

