/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.engine.sql;

import com.prelytis.dashboard.data.engine.AbstractEngine;
import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.data.engine.ds.EngineDS;
import com.prelytis.dashboard.data.helper.QuerySQLHelper;
import com.prelytis.dashboard.db.operation.Operation;
import com.prelytis.dashboard.db.operation.OperationH2;
import com.prelytis.dashboard.db.operation.OperationSelect;
import com.prelytis.dashboard.db.operator.ConnectionHelper;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.IQueryDefinition;
import com.prelytis.dashboard.util.GuidFactory;
import com.prelytis.dashboard.util.QueryDSTableHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureFinal;
import com.prelytis.dashboard.value.data.BeanQueryDataStructureTable;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQueryStar;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.query.Expression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.DateTruncation;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;
import java.util.List;

public class EngineSql4Multi
extends AbstractEngine {
    private List<AbstractBeanReportFilter> reportFilterList;
    private Expression expression;
    private ExecutionContext contextH2;

    public EngineSql4Multi(ExecutionContext context) {
        super(context);
    }

    @Override
    public Operation getOperation() throws DashboardException {
        BeanQueryDataStructureTable dsTable = new BeanQueryDataStructureTable();
        GuidFactory guidFactory = GuidFactory.getInstance();
        String fakeName = guidFactory.generateGUID((Object)dsTable);
        dsTable.setName(fakeName);
        BeanQueryDataStructureFinal query = new BeanQueryDataStructureFinal();
        query.setMaxLines(this.getContext().getQuery().getMaxLines());
        query.setTableFact(dsTable);
        QueryDSTableHelper helper = new QueryDSTableHelper((BeanQueryStar)query, this.getContext().getData().getLocale());
        BeanQuerySQL initialQuery = (BeanQuerySQL)this.getContext().getQuery();
        SQLTable sqlTable = new SQLTable();
        sqlTable.setName(dsTable.getName());
        List fieldList = sqlTable.getFieldList();
        for (BeanQuerySQLField field : initialQuery.getBeanQuerySQLFieldList()) {
            DataType dataType = field.getDataType();
            helper.addField(dsTable, field.getName(), field.getName(), field.getDescriptionKey(), field.getDataType(), DateTruncation.NONE, field.getFieldGroupName(), field.isActive(), field.getSize(), field.getDigits(), field.isNullable());
            FieldMetaData fmd = DataType.isChar((DataType)dataType) ? new FieldMetaData(0, field.getName(), field.getDescriptionKey(), field.getDataType(), field.getSize()) : (DataType.isNumeric((DataType)dataType) ? new FieldMetaData(0, field.getName(), field.getDescriptionKey(), field.getDataType(), field.getSize(), field.getDigits()) : new FieldMetaData(0, field.getName(), field.getDescriptionKey(), field.getDataType()));
            fieldList.add(fmd);
        }
        ArrayList<SQLTable> tableList = new ArrayList<SQLTable>();
        tableList.add(sqlTable);
        this.contextH2.setQuery((IQueryDefinition)query);
        this.contextH2.setFieldMap(this.getContext().getFieldMap());
        EngineDS engineH2 = EngineDS.getInstance(this.contextH2);
        engineH2.setForceGroupBy(this.getForceGroupBy());
        engineH2.setFieldList(this.getFieldList());
        engineH2.setFilter(this.expression);
        engineH2.setSortFieldList(this.getSortFieldList());
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(this.getSqlOperation());
        OperationH2 operationH2 = new OperationH2();
        operationH2.setOperationList(operationList);
        operationH2.setTableList(tableList);
        operationH2.setResult(engineH2.getOperation());
        return operationH2;
    }

    private Operation getSqlOperation() throws DashboardException {
        OperationSelect select = new OperationSelect();
        BeanWorldDefinition world = this.getContext().getWorld();
        if (!world.isUseDefault()) {
            select.setResultSetConcurrency(Integer.valueOf(world.getResultSetConcurrency()));
            select.setResultSetType(Integer.valueOf(world.getResultSetType()));
            select.setFetchSize(Integer.valueOf(world.getFetchSize()));
        }
        WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)this.getContext().getWorld(), (DriverCharacteristics)this.getContext().getDriver(), (ExpressionEvaluationData)this.getContext().getData());
        ConnectionHelper ch = ConnectionHelper.getInstance((WorldHelper)worldHelper);
        select.setDatabase(ch.getPoolDbInfo());
        QuerySQLHelper qh = new QuerySQLHelper();
        select.setQuerySQL(qh.getQuerySQL(this.getContext(), this.reportFilterList));
        return select;
    }

    @Override
    public void setFilter(Expression expression) throws DashboardException {
        this.expression = expression;
    }

    @Override
    public void setFilter(List<AbstractBeanReportFilter> reportFilterList) throws DashboardException {
        this.reportFilterList = reportFilterList;
    }

    public ExecutionContext getContextH2() {
        return this.contextH2;
    }

    public void setContextH2(ExecutionContext contextH2) {
        this.contextH2 = contextH2;
    }
}

