/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.helper;

import com.prelytis.dashboard.data.engine.ExecutionContext;
import com.prelytis.dashboard.db.QuerySQL;
import com.prelytis.dashboard.db.operator.WorldHelper;
import com.prelytis.dashboard.db.operator.WorldType;
import com.prelytis.dashboard.db.value.Value;
import com.prelytis.dashboard.helper.QuerySQLPattern;
import com.prelytis.dashboard.helper.QuerySQLPatternListHelper;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.util.ExpressionEvaluationHelper;
import com.prelytis.dashboard.util.conversion.Conv2SQLString;
import com.prelytis.dashboard.util.parsing.ExpressionParser;
import com.prelytis.dashboard.util.parsing.PatternExpression;
import com.prelytis.dashboard.value.data.AbstractBeanReportFilter;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.data.BeanQuerySQLField;
import com.prelytis.dashboard.value.data.BeanQuerySQLFilter;
import com.prelytis.dashboard.value.data.BeanWorldDefinition;
import com.prelytis.dashboard.value.data.DriverCharacteristics;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.util.AllExpression;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class QuerySQLHelper {
    private final ExpressionEvaluationHelper helper = ExpressionEvaluationHelper.getInstance();

    public QuerySQL getQuerySQL(ExecutionContext context, List<AbstractBeanReportFilter> reportFilterList) throws DashboardException {
        ArrayList<QuerySQLPattern> patternList = new ArrayList<QuerySQLPattern>();
        BeanQuerySQL querySql = (BeanQuerySQL)context.getQuery();
        QuerySQL query = new QuerySQL();
        query.setUsePreparedStatement(querySql.getUsePreparedStatement());
        query.setMaxRows(querySql.getMaxLines());
        List sqlFilterList = querySql.getBeanQuerySQLFilterList();
        Map<String, ReportFilter> filterMap = context.getFilterMap();
        ExpressionEvaluationData data = context.getData();
        WorldHelper worldHelper = WorldHelper.getInstance((BeanWorldDefinition)context.getWorld(), (DriverCharacteristics)context.getDriver(), (ExpressionEvaluationData)data);
        String driverClassName = worldHelper.getDriverClassName();
        String schema = worldHelper.getDefaultTablePrefix();
        patternList.add(QuerySQLPattern.getFixedPattern("s:schema", schema));
        patternList.add(QuerySQLPattern.getFixedPattern("schema", schema));
        QuerySQLPatternListHelper persFieldHelper = new QuerySQLPatternListHelper();
        persFieldHelper.fill(patternList, data);
        HashMap<Integer, String> filterPatternMap = new HashMap<Integer, String>();
        HashMap filterValueMap = new HashMap();
        HashMap<Integer, DataType> filterDataTypeMap = new HashMap<Integer, DataType>();
        block11: for (int i = 0; i < sqlFilterList.size(); ++i) {
            ReportFilter filter;
            int promptType;
            int mode;
            BeanQuerySQLFilter sqlFilter = (BeanQuerySQLFilter)sqlFilterList.get(i);
            AbstractBeanReportFilter reportFilter = null;
            if (reportFilterList != null) {
                if (reportFilterList.size() > i) {
                    reportFilter = reportFilterList.get(i);
                }
                if (reportFilter == null || !reportFilter.getName().equals(sqlFilter.getName()) || reportFilter.getDataType() != sqlFilter.getDataType()) {
                    reportFilter = null;
                }
            }
            String filterName = null;
            Object defaultValue = null;
            String operand = null;
            if (reportFilter == null) {
                defaultValue = sqlFilter.getDefaultValue();
                filterName = sqlFilter.getName();
                filterDataTypeMap.put(i + 1, sqlFilter.getDataType());
                mode = sqlFilter.getFltMode();
                promptType = 1;
                operand = sqlFilter.getOperand();
            } else {
                filterName = reportFilter.getName();
                defaultValue = reportFilter.getDefaultValue();
                filterDataTypeMap.put(i + 1, reportFilter.getDataType());
                mode = reportFilter.getMode();
                promptType = reportFilter.getPromptType();
                operand = reportFilter.getOperand();
            }
            Object[] param = null;
            if (filterMap != null && (filter = filterMap.get(filterName)) != null) {
                param = filter.getValues();
            }
            if (param == null || param.length == 0) {
                param = new Object[]{"{s:schema}".equals(defaultValue) ? schema : defaultValue};
            }
            param = this.helper.evaluateExpression(param, data);
            StringBuilder newPattern = new StringBuilder();
            ArrayList<Object> filterPatternList = new ArrayList<Object>();
            switch (mode) {
                case 2: {
                    StringBuilder str = new StringBuilder();
                    if (promptType == 4) {
                        str.append(param[0]);
                    } else {
                        for (int p = 0; p < param.length; ++p) {
                            if (p != 0) {
                                str.append(",");
                            }
                            if (param[p] != null) {
                                str.append(param[p].toString().replaceAll("\\,", "\\\\,"));
                                continue;
                            }
                            str.append("null");
                        }
                    }
                    newPattern.append("?");
                    filterPatternList.add(str.toString());
                    filterPatternMap.put(i + 1, newPattern.toString());
                    filterValueMap.put(i + 1, filterPatternList);
                    continue block11;
                }
                case 1: {
                    if (DataType.isChar((DataType)sqlFilter.getDataType())) {
                        int j;
                        List lNotLikeList;
                        List lLikeList;
                        List lNotInList;
                        Object[] lInList;
                        PatternExpression pe;
                        if (promptType == 4) {
                            if (param.length == 1 && param[0] != null && !"".equals(param[0])) {
                                try {
                                    ExpressionParser p = new ExpressionParser((Reader)new StringReader(String.valueOf(param[0])));
                                    pe = p.Parse();
                                }
                                catch (Exception e) {
                                    throw this.getDashboardException(e);
                                }
                            } else {
                                pe = new PatternExpression();
                            }
                        } else {
                            pe = new PatternExpression();
                            if (param != null) {
                                for (Object o : param) {
                                    pe.addClause(String.valueOf(o), true);
                                }
                            }
                        }
                        if ("<>".equals(sqlFilter.getOperand())) {
                            lInList = pe.getNotInList();
                            lNotInList = pe.getInList();
                            lLikeList = pe.getNotLikeList();
                            lNotLikeList = pe.getLikeList();
                        } else {
                            lInList = pe.getInList();
                            lNotInList = pe.getNotInList();
                            lLikeList = pe.getLikeList();
                            lNotLikeList = pe.getNotLikeList();
                        }
                        if (lInList.isEmpty() && lLikeList.isEmpty() && lNotInList.isEmpty() && lNotLikeList.isEmpty()) {
                            newPattern.append(operand + " is null ");
                            filterPatternMap.put(i + 1, newPattern.toString());
                            continue block11;
                        }
                        boolean posAdded = false;
                        boolean negAdded = false;
                        Object l = lInList;
                        if (l.size() > 0) {
                            newPattern.append("(");
                            newPattern.append("(");
                            posAdded = true;
                            if (l.size() == 1) {
                                newPattern.append(operand + "=?");
                                filterPatternList.add(l.get(0));
                            } else {
                                newPattern.append(operand + " IN (");
                                for (j = 0; j < l.size(); ++j) {
                                    if (j != 0) {
                                        newPattern.append(",");
                                    }
                                    newPattern.append("?");
                                    filterPatternList.add(l.get(j));
                                }
                                newPattern.append(")");
                            }
                        }
                        if ((l = lLikeList).size() > 0) {
                            if (posAdded) {
                                newPattern.append(" OR ");
                            } else {
                                posAdded = true;
                                newPattern.append("(");
                                newPattern.append("(");
                            }
                            for (j = 0; j < l.size(); ++j) {
                                if (j != 0) {
                                    newPattern.append(" OR ");
                                }
                                newPattern.append(operand + " LIKE ?");
                                this.addEscapeClause(newPattern, driverClassName);
                                filterPatternList.add(l.get(j));
                            }
                        }
                        if (posAdded) {
                            newPattern.append(")");
                        }
                        if ((l = lNotInList).size() > 0) {
                            if (posAdded) {
                                newPattern.append(" AND ");
                            }
                            newPattern.append("(");
                            negAdded = true;
                            if (l.size() == 1) {
                                newPattern.append(operand + "<>?");
                                filterPatternList.add(l.get(0));
                            } else {
                                newPattern.append(operand + " NOT IN (");
                                for (j = 0; j < l.size(); ++j) {
                                    if (j != 0) {
                                        newPattern.append(",");
                                    }
                                    newPattern.append("?");
                                    filterPatternList.add(l.get(j));
                                }
                                newPattern.append(")");
                            }
                        }
                        if ((l = lNotLikeList).size() > 0) {
                            if (negAdded || posAdded) {
                                newPattern.append(" AND ");
                            }
                            if (!negAdded) {
                                newPattern.append("(");
                                negAdded = true;
                            }
                            for (j = 0; j < l.size(); ++j) {
                                if (j != 0) {
                                    newPattern.append(" AND ");
                                }
                                newPattern.append(operand + " NOT LIKE ?");
                                this.addEscapeClause(newPattern, driverClassName);
                                filterPatternList.add(l.get(j));
                            }
                        }
                        if (negAdded) {
                            newPattern.append(")");
                        }
                        if (posAdded) {
                            newPattern.append(")");
                        }
                        filterPatternMap.put(i + 1, newPattern.toString());
                        filterValueMap.put(i + 1, filterPatternList);
                        continue block11;
                    }
                    if (param.length == 0 || param[0] == null || "".equals(param[0])) {
                        newPattern.append(operand).append(" is null ");
                        filterPatternMap.put(i + 1, newPattern.toString());
                        continue block11;
                    }
                    if (param.length == 1) {
                        newPattern.append(operand).append("=?");
                        filterPatternList.add(param[0]);
                        filterPatternMap.put(i + 1, newPattern.toString());
                        filterValueMap.put(i + 1, filterPatternList);
                        continue block11;
                    }
                    newPattern.append(operand).append(" IN (");
                    boolean first = true;
                    for (Object o : param) {
                        if (first) {
                            first = false;
                        } else {
                            newPattern.append(",");
                        }
                        newPattern.append("?");
                        filterPatternList.add(o);
                    }
                    newPattern.append(")");
                    filterPatternMap.put(i + 1, newPattern.toString());
                    filterValueMap.put(i + 1, filterPatternList);
                    continue block11;
                }
                default: {
                    newPattern.append("?");
                    filterPatternList.add(QuerySQLHelper.replaceJoker(param[0]));
                    filterPatternMap.put(i + 1, newPattern.toString());
                    filterValueMap.put(i + 1, filterPatternList);
                }
            }
        }
        String request = querySql.getRequest();
        StringTokenizer st = new StringTokenizer(request, "[?]", true);
        StringBuffer str = new StringBuffer();
        String lastToken = "";
        String start = "";
        String end = "";
        int paramIndex = 0;
        block19: while (st.hasMoreTokens()) {
            String queryPart = st.nextToken();
            char car = queryPart.charAt(0);
            switch (car) {
                case '[': {
                    if (start.equals("?") && lastToken.equals("")) {
                        start = "?[";
                        continue block19;
                    }
                    if (!start.equals("")) {
                        lastToken = lastToken.concat("[");
                        continue block19;
                    }
                    str.append("[");
                    continue block19;
                }
                case '?': {
                    if (!start.equals("")) {
                        str.append(start);
                        continue block19;
                    }
                    if (!lastToken.equals("")) {
                        str.append(lastToken);
                    }
                    start = "?";
                    end = "]";
                    lastToken = "";
                    continue block19;
                }
                case ']': {
                    if ("]".equals(end)) {
                        Integer tokenIndex = Integer.valueOf(lastToken);
                        String subQuery = (String)filterPatternMap.get(tokenIndex);
                        List filterPatternList = (List)filterValueMap.get(tokenIndex);
                        DataType dataType = (DataType)filterDataTypeMap.get(tokenIndex);
                        StringTokenizer subSt = new StringTokenizer(subQuery, "?", true);
                        int listIndex = 0;
                        while (subSt.hasMoreTokens()) {
                            String subQueryPart = subSt.nextToken();
                            if (subQueryPart.charAt(0) == '?') {
                                str.append("?[").append(++paramIndex).append("]");
                                patternList.add(new QuerySQLPattern(Integer.valueOf(paramIndex).toString(), dataType, filterPatternList.get(listIndex++)));
                                continue;
                            }
                            str.append(subQueryPart);
                        }
                        start = "";
                        end = "";
                        lastToken = "";
                        continue block19;
                    }
                    if (start.equals("")) {
                        str.append(car);
                        continue block19;
                    }
                    lastToken = lastToken.concat(queryPart);
                    continue block19;
                }
            }
            if (start.equals("")) {
                str.append(queryPart);
                continue;
            }
            lastToken = lastToken.concat(queryPart);
        }
        query.setQueryString(str.toString());
        List fieldList = query.getFieldList();
        int cpt = 0;
        for (BeanQuerySQLField sqlField : querySql.getBeanQuerySQLFieldList()) {
            if (DataType.isChar((DataType)sqlField.getDataType())) {
                fieldList.add(new FieldMetaData(cpt, sqlField.getName(), sqlField.getDescriptionKey(), sqlField.getDataType(), sqlField.getSize()));
            } else if (DataType.isNumeric((DataType)sqlField.getDataType())) {
                fieldList.add(new FieldMetaData(cpt, sqlField.getName(), sqlField.getDescriptionKey(), sqlField.getDataType(), sqlField.getSize(), sqlField.getDigits()));
            } else {
                fieldList.add(new FieldMetaData(cpt, sqlField.getName(), sqlField.getDescriptionKey(), sqlField.getDataType()));
            }
            ++cpt;
        }
        return this.getTransformedQuerySQL(query, patternList);
    }

    public QuerySQL getTransformedQuerySQL(QuerySQL query, List<QuerySQLPattern> patternList) {
        Conv2SQLString conv2SQLWString = new Conv2SQLString("null");
        String request = this.replaceAll(query.getQueryString());
        boolean usePreparedStmt = query.isUsePreparedStatement();
        HashMap<String, QuerySQLPattern> patternMap = new HashMap<String, QuerySQLPattern>();
        for (QuerySQLPattern pattern : patternList) {
            patternMap.put(pattern.getPattern(), pattern);
        }
        StringTokenizer st = new StringTokenizer(request, "[{}?]", true);
        StringBuffer str = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        String lastToken = new String();
        String start = new String();
        String end = new String();
        block12: while (st.hasMoreTokens()) {
            String queryPart = st.nextToken();
            char car = queryPart.charAt(0);
            switch (car) {
                case '[': {
                    if (start.equals("?") && lastToken.equals("")) {
                        start = "?[";
                        continue block12;
                    }
                    if (!start.equals("")) {
                        lastToken = lastToken.concat("[");
                        continue block12;
                    }
                    str.append("[");
                    continue block12;
                }
                case '{': {
                    if (!start.equals("")) {
                        lastToken = lastToken.concat("{");
                        continue block12;
                    }
                    start = "{";
                    end = "}";
                    lastToken = "";
                    continue block12;
                }
                case '}': {
                    Object pattern;
                    if ("}".equals(end)) {
                        if (patternMap.containsKey(lastToken)) {
                            pattern = (QuerySQLPattern)patternMap.get(lastToken);
                            if (usePreparedStmt && ((QuerySQLPattern)pattern).getCanBeUsedAsAParameter()) {
                                str.append("?");
                                paramList.add(((QuerySQLPattern)pattern).getValue());
                            } else if (((QuerySQLPattern)pattern).getCanBeUsedAsAParameter()) {
                                try {
                                    str.append(conv2SQLWString.getValue(((QuerySQLPattern)pattern).getValue()));
                                }
                                catch (Exception exception) {}
                            } else {
                                str.append(((QuerySQLPattern)pattern).getValue());
                            }
                        } else {
                            str.append(start);
                            str.append(lastToken);
                            str.append(car);
                        }
                        start = "";
                        end = "";
                        lastToken = "";
                        continue block12;
                    }
                    if (start.equals("")) {
                        str.append(car);
                        continue block12;
                    }
                    lastToken = lastToken.concat(queryPart);
                    continue block12;
                }
                case '?': {
                    if (!start.equals("")) {
                        str.append(start);
                        continue block12;
                    }
                    if (!lastToken.equals("")) {
                        str.append(lastToken);
                    }
                    start = "?";
                    end = "]";
                    lastToken = "";
                    continue block12;
                }
                case ']': {
                    Object pattern;
                    if ("]".equals(end)) {
                        if (patternMap.containsKey(lastToken)) {
                            pattern = (QuerySQLPattern)patternMap.get(lastToken);
                            if (usePreparedStmt && ((QuerySQLPattern)pattern).getCanBeUsedAsAParameter()) {
                                str.append("?");
                                paramList.add(((QuerySQLPattern)pattern).getValue());
                            } else {
                                try {
                                    str.append(conv2SQLWString.getValue(((QuerySQLPattern)pattern).getValue()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            start = "";
                            end = "";
                            lastToken = "";
                            continue block12;
                        }
                        str.append(start);
                        str.append(lastToken);
                        str.append(car);
                        start = "";
                        end = "";
                        lastToken = "";
                        continue block12;
                    }
                    if (start.equals("")) {
                        str.append(car);
                        continue block12;
                    }
                    lastToken = lastToken.concat(queryPart);
                    continue block12;
                }
            }
            if (start.equals("")) {
                str.append(queryPart);
                continue;
            }
            lastToken = lastToken.concat(queryPart);
        }
        patternMap.clear();
        QuerySQL resu = new QuerySQL();
        resu.setQueryString(str.toString());
        resu.setUsePreparedStatement(usePreparedStmt);
        resu.setMaxRows(query.getMaxRows());
        List fieldList = resu.getFieldList();
        for (FieldMetaData fmd : query.getFieldList()) {
            if (fmd.getDataType() == null || fmd.getDataType().equals((Object)DataType.BLOB)) {
                Logger.getLogger(QuerySQLHelper.class).info((Object)"Skipping null or BLOB column");
                continue;
            }
            fieldList.add(fmd);
        }
        List sqlParamlist = resu.getParameterList();
        for (Object e : paramList) {
            sqlParamlist.add(Value.valueOf(e));
        }
        return resu;
    }

    private DashboardException getDashboardException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    private static Object replaceJoker(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof AllExpression) {
            return "%";
        }
        if (value instanceof String) {
            StringTokenizer st = new StringTokenizer((String)value, "*?", true);
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                int length;
                String t = st.nextToken();
                if (t.equals("*")) {
                    if (sb.toString().endsWith("\\")) {
                        length = sb.length();
                        sb.delete(length - 1, length).append(t);
                        continue;
                    }
                    sb.append("%");
                    continue;
                }
                if (t.equals("?")) {
                    if (sb.toString().endsWith("\\")) {
                        length = sb.length();
                        sb.delete(length - 1, length).append(t);
                        continue;
                    }
                    sb.append("_");
                    continue;
                }
                sb.append(t);
            }
            return sb.toString();
        }
        return value;
    }

    private String replaceAll(String name) {
        Date date = new Date();
        String str = name;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yy");
        str = str.replaceAll("\\[shortyear\\]", sdf.format(date));
        str = str.replaceAll("\\{s:shortyear\\}", sdf.format(date));
        sdf.applyPattern("yyyy");
        str = str.replaceAll("\\[year\\]", sdf.format(date));
        str = str.replaceAll("\\{s:year\\}", sdf.format(date));
        sdf.applyPattern("MM");
        str = str.replaceAll("\\[month\\]", sdf.format(date));
        str = str.replaceAll("\\{s:month\\}", sdf.format(date));
        sdf.applyPattern("W");
        str = str.replaceAll("\\[weekofmonth\\]", sdf.format(date));
        str = str.replaceAll("\\{s:weekofmonth\\}", sdf.format(date));
        sdf.applyPattern("ww");
        str = str.replaceAll("\\[weekofyear\\]", sdf.format(date));
        str = str.replaceAll("\\{s:weekofyear\\}", sdf.format(date));
        sdf.applyPattern("DDD");
        str = str.replaceAll("\\[dayofyear\\]", sdf.format(date));
        str = str.replaceAll("\\{s:dayofyear\\}", sdf.format(date));
        sdf.applyPattern("dd");
        str = str.replaceAll("\\[dayofmonth\\]", sdf.format(date));
        str = str.replaceAll("\\{s:dayofmonth\\}", sdf.format(date));
        sdf.applyPattern("F");
        str = str.replaceAll("\\[dayofweek\\]", sdf.format(date));
        str = str.replaceAll("\\{s:dayofweek\\}", sdf.format(date));
        sdf.applyPattern("HH");
        str = str.replaceAll("\\[hour\\]", sdf.format(date));
        str = str.replaceAll("\\{s:hour\\}", sdf.format(date));
        sdf.applyPattern("mm");
        str = str.replaceAll("\\[minute\\]", sdf.format(date));
        str = str.replaceAll("\\{s:minute\\}", sdf.format(date));
        sdf.applyPattern("yyyyMMddHHmmss");
        str = str.replaceAll("\\[now\\]", sdf.format(date));
        str = str.replaceAll("\\{s:now\\}", sdf.format(date));
        sdf.applyPattern("yyyyMMdd");
        str = str.replaceAll("\\[today\\]", sdf.format(date));
        str = str.replaceAll("\\{s:today\\}", sdf.format(date));
        sdf.applyPattern("yyyy0101");
        str = str.replaceAll("\\[firstdayinyear\\]", sdf.format(date));
        str = str.replaceAll("\\{s:firstdayinyear\\}", sdf.format(date));
        sdf.applyPattern("yyyyMM01");
        str = str.replaceAll("\\[firstdayinmonth\\]", sdf.format(date));
        str = str.replaceAll("\\{s:firstdayinmonth\\}", sdf.format(date));
        return str;
    }

    private void addEscapeClause(StringBuilder buffer, String driverClass) {
        if (driverClass.equals(WorldType.MYSQL.toString())) {
            buffer.append(" ESCAPE '\\\\'");
        } else if (driverClass.equals(WorldType.ORACLE.toString()) || driverClass.equals(WorldType.DB2.toString()) || driverClass.equals(WorldType.MICROSOFT.toString())) {
            buffer.append(" ESCAPE '\\'");
        }
    }
}

