/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.data.link;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.WorkspaceDao;
import com.prelytis.dashboard.dao.filter.DbLinkFilter;
import com.prelytis.dashboard.data.link.LinkDefinition;
import com.prelytis.dashboard.data.link.LinkDefinitionComparator;
import com.prelytis.dashboard.data.link.LinkFieldParam;
import com.prelytis.dashboard.data.link.LinkHelper;
import com.prelytis.dashboard.data.link.RefField;
import com.prelytis.dashboard.data.link.RefType;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.Element;
import com.prelytis.dashboard.interfaces.SessionType;
import com.prelytis.dashboard.model.helper.DashBoardHelper;
import com.prelytis.dashboard.model.helper.ExtSessionHelper;
import com.prelytis.dashboard.model.helper.FormHelper;
import com.prelytis.dashboard.model.helper.ReportHelper;
import com.prelytis.dashboard.util.TableFactory;
import com.prelytis.dashboard.value.chart.Cell;
import com.prelytis.dashboard.value.chart.ColRow;
import com.prelytis.dashboard.value.chart.ICellElt;
import com.prelytis.dashboard.value.chart.Link;
import com.prelytis.dashboard.value.chart.Table;
import com.prelytis.dashboard.value.data.AbstractBeanReport;
import com.prelytis.dashboard.value.data.BeanDashBoardDefinition;
import com.prelytis.dashboard.value.data.BeanExtSessionDefinition;
import com.prelytis.dashboard.value.data.BeanFormDefinition;
import com.prelytis.dashboard.value.data.BeanLinkDefinition;
import com.prelytis.dashboard.value.data.BeanLinkField;
import com.prelytis.dashboard.value.data.BeanReportSection;
import com.prelytis.dashboard.value.data.BeanReportStd;
import com.prelytis.dashboard.value.data.BeanReportStdUsedField;
import com.prelytis.dashboard.value.data.ReportFilter;
import com.prelytis.dashboard.value.structure.SectionDocument;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class LinkHelperStd {
    private static final Logger log = LogManager.getLogger(LinkHelperStd.class);
    private final LinkHelper linkHelper = LinkHelper.getInstance();
    private final Comparator<LinkDefinition> comparator;
    private final Map<RefField, List<LinkDefinition>> linkMap = new HashMap<RefField, List<LinkDefinition>>();

    public LinkHelperStd(DaoFactory daoFactory, BeanReportStd report, List<? extends ReportFilter> srcFilterList, ExpressionEvaluationData data) throws DashboardException {
        this.comparator = new LinkDefinitionComparator(data.getLocale());
        try {
            int i;
            List sectionList = report.getSectionList();
            List srcFieldList = report.getFieldList();
            HashMap<String, RefField> linkableFieldMap = new HashMap<String, RefField>(sectionList.size() + srcFieldList.size());
            for (i = 0; i < sectionList.size(); ++i) {
                BeanReportSection section = (BeanReportSection)sectionList.get(i);
                linkableFieldMap.put(section.getName(), new RefField(RefType.SECTION, i));
            }
            for (i = 0; i < srcFieldList.size(); ++i) {
                BeanReportStdUsedField field = (BeanReportStdUsedField)srcFieldList.get(i);
                linkableFieldMap.put(field.getName(), new RefField(RefType.DATA, i));
            }
            Map<String, ReportFilter> srcFilterMap = this.linkHelper.getReportFilterMap(srcFilterList);
            WorkspaceDao workspaceDao = daoFactory.getWorkspaceDao();
            com.prelytis.dashboard.model.helper.LinkHelper linkHelper = com.prelytis.dashboard.model.helper.LinkHelper.getInstance(daoFactory);
            FormHelper formHelper = FormHelper.getInstance(daoFactory);
            DashBoardHelper dashboardHelper = DashBoardHelper.getInstance(daoFactory);
            ExtSessionHelper externSessionHelper = ExtSessionHelper.getInstance(daoFactory);
            ReportHelper reportHelper = ReportHelper.getInstance(daoFactory);
            DbLinkFilter linkFilter = new DbLinkFilter();
            linkFilter.setSrcReport(Integer.valueOf(report.getObjectID()));
            List<Element> list = linkHelper.list(linkFilter, 2, null, null, data);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                try {
                    ReportFilter dstFilter;
                    int j;
                    int accessLevel;
                    BeanLinkDefinition linkDef = (BeanLinkDefinition)list.get(i2);
                    LinkFieldParam[] fields = null;
                    boolean valid = true;
                    SessionType dstSessionType = SessionType.NONE;
                    String dstDocumentName = null;
                    List<ReportFilter> dstFilterList = null;
                    if (linkDef.getDstReportName() != null) {
                        AbstractBeanReport dstReport = reportHelper.getDefinition(linkDef.getDstReportName());
                        dstDocumentName = dstReport.getName();
                        dstSessionType = SessionType.DOCUMENT;
                        dstFilterList = reportHelper.getLinkableFilterList(dstReport, data);
                    } else if (linkDef.getDstDashBoardName() != null) {
                        BeanDashBoardDefinition dstDashboard = dashboardHelper.getDefinition(linkDef.getDstDashBoardName());
                        dstDocumentName = dstDashboard.getName();
                        dstSessionType = SessionType.DASHBOARD;
                        dstFilterList = dashboardHelper.getFilterList(dstDashboard.getFilterList(), data);
                    } else if (linkDef.getDstExtSessionName() != null) {
                        BeanExtSessionDefinition dstExtSession = externSessionHelper.getDefinition(linkDef.getDstExtSessionName());
                        dstDocumentName = dstExtSession.getName();
                        dstSessionType = SessionType.EXTERN;
                        dstFilterList = externSessionHelper.getLinkableFilterList(dstExtSession.getParameterList(), null, data);
                    } else if (linkDef.getDstFormName() != null) {
                        BeanFormDefinition dstForm = formHelper.getDefinition(linkDef.getDstFormName());
                        dstDocumentName = dstForm.getName();
                        dstSessionType = SessionType.FORM;
                        dstFilterList = formHelper.getFilterList(dstForm.getUsedFields());
                    } else {
                        valid = false;
                    }
                    Map<String, ReportFilter> dstFilterMap = this.linkHelper.getReportFilterMap(dstFilterList);
                    if (valid) {
                        valid = linkableFieldMap.containsKey(linkDef.getLinkedFieldName());
                    }
                    if (valid && (accessLevel = workspaceDao.getAccessLevelForEC(data.getExecutionContextOid().intValue(), dstSessionType, dstDocumentName).getAccessLevel()) == 0) {
                        valid = false;
                    }
                    if (valid) {
                        List fieldFilterList = linkDef.getBeanLinkFieldFilterList();
                        fields = new LinkFieldParam[fieldFilterList.size()];
                        for (j = 0; j < fieldFilterList.size() && valid; ++j) {
                            BeanLinkField fieldFilter = (BeanLinkField)fieldFilterList.get(j);
                            dstFilter = dstFilterMap.get(fieldFilter.getDst());
                            if (linkableFieldMap.containsKey(fieldFilter.getSrc()) && dstFilter != null) {
                                RefField field = (RefField)linkableFieldMap.get(fieldFilter.getSrc());
                                fields[j] = new LinkFieldParam(fieldFilter.getSrc(), fieldFilter.getDst(), field);
                                continue;
                            }
                            valid = false;
                        }
                    }
                    if (valid) {
                        List filterFilterList = linkDef.getBeanLinkFilterFilterList();
                        for (j = 0; j < filterFilterList.size() && valid; ++j) {
                            BeanLinkField filterFilter = (BeanLinkField)filterFilterList.get(j);
                            dstFilter = dstFilterMap.get(filterFilter.getDst());
                            ReportFilter srcFilter = srcFilterMap.get(filterFilter.getSrc());
                            if (dstFilter != null && srcFilter != null) {
                                if (srcFilter.getUseFilter()) {
                                    dstFilter.setUseFilter(true);
                                    dstFilter.setValues(srcFilter.getValues());
                                    continue;
                                }
                                dstFilter.setUseFilter(false);
                                dstFilter.setValues(null);
                                continue;
                            }
                            valid = false;
                        }
                    }
                    if (!valid) continue;
                    LinkDefinition link = new LinkDefinition();
                    link.setName(linkDef.getName());
                    link.setDescription((String)linkDef.getDescriptionMap().get(data.getLocale()));
                    link.setSessionType(dstSessionType);
                    link.setDocumentName(dstDocumentName);
                    link.setFields(fields);
                    link.setReportFilterList(dstFilterList);
                    link.setDstInNewWnd(linkDef.isDstInNewWindow());
                    link.setFrmValRefresh(linkDef.isFrmValRefresh());
                    link.setPreview(linkDef.isPreview());
                    link.setSortOrder(linkDef.getSortOrder());
                    RefField field = (RefField)linkableFieldMap.get(linkDef.getLinkedFieldName());
                    List<LinkDefinition> linkList = this.linkMap.get(field);
                    if (linkList == null) {
                        linkList = new ArrayList<LinkDefinition>();
                        this.linkMap.put(field, linkList);
                    }
                    linkList.add(link);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            throw this.getDashboardException(e);
        }
    }

    public void clear() {
        if (this.linkMap != null) {
            this.linkMap.clear();
        }
    }

    public boolean getHasLinks() {
        return this.linkMap.size() != 0;
    }

    public void setLinks(Table table, List<SectionDocument> sections) {
        for (Map.Entry<RefField, List<LinkDefinition>> entry : this.linkMap.entrySet()) {
            this.setLinks(entry.getKey(), entry.getValue(), table, sections);
        }
    }

    private void setLinks(RefField field, List<LinkDefinition> list, Table table, List<SectionDocument> sections) {
        Collections.sort(list, this.comparator);
        switch (field.getType()) {
            case SECTION: {
                ArrayList<Link> ll = new ArrayList<Link>();
                for (int i = 0; i < list.size(); ++i) {
                    LinkDefinition ld = list.get(i);
                    ll.add(this.getLink(sections, null, ld));
                }
                for (SectionDocument section : sections) {
                    if (section.getLinkList() != null) continue;
                    section.setLinkList(ll);
                }
                break;
            }
            case DATA: {
                ColRow col = (ColRow)table.getCols().get(field.getIndex());
                for (int j = 1; j < table.getRows().size(); ++j) {
                    ArrayList<Link> ll = new ArrayList<Link>();
                    Cell cell = (Cell)col.get(j);
                    for (int i = 0; i < list.size(); ++i) {
                        LinkDefinition ld = list.get(i);
                        ll.add(this.getLink(sections, cell, ld));
                    }
                    ICellElt elt = TableFactory.getCellElt((Cell)cell, (int)0);
                    if (elt.getLinkList() != null) continue;
                    elt.setLinkList(ll);
                }
                break;
            }
        }
    }

    private Link getLink(List<SectionDocument> sections, Cell cell, LinkDefinition ld) {
        Link link = this.linkHelper.getLink(ld);
        LinkFieldParam[] fields = ld.getFields();
        ColRow row = null;
        if (cell != null) {
            row = cell.getRow();
        }
        Map<String, ReportFilter> map = this.linkHelper.getReportFilterMap(link.getReportFilterList());
        for (int i = 0; i < fields.length; ++i) {
            Object[] values = null;
            RefField f = fields[i].getField();
            switch (f.getType()) {
                case SECTION: {
                    SectionDocument section;
                    if (sections.size() <= f.getIndex() || (section = sections.get(f.getIndex())) == null) break;
                    values = new Object[]{section.getData()};
                    break;
                }
                case DATA: {
                    if (row == null) break;
                    Cell tmp = (Cell)row.get(f.getIndex());
                    values = new Object[]{TableFactory.getCellElt((Cell)tmp, (int)0).getValue()};
                }
            }
            ReportFilter filter = map.get(fields[i].getDstName());
            filter.setUseFilter(true);
            filter.setValues(values);
        }
        return link;
    }

    private DashboardException getDashboardException(Exception e) {
        DashboardException de = e instanceof DashboardException ? (DashboardException)((Object)e) : new DashboardException((Throwable)e);
        de.log(log);
        return de;
    }
}

